/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.modification;

import java.util.Arrays;
import marytts.signalproc.adaptation.prosody.BasicProsodyModifierParams;
import marytts.signalproc.analysis.RegularizedPostWarpedCepstrumEstimator;
import marytts.signalproc.analysis.RegularizedPreWarpedCepstrumEstimator;
import marytts.signalproc.process.TDPSOLAInstants;
import marytts.signalproc.process.TDPSOLAProcessor;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzer;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmPlusTransientsSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechFrame;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignalWithContext;
import marytts.signalproc.sinusoidal.hntm.analysis.TransientSegment;
import marytts.signalproc.sinusoidal.hntm.synthesis.NoisePartWaveformSynthesizer;
import marytts.signalproc.window.Window;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class HntmProsodyModifier {
    public static HntmSpeechSignalWithContext modify(HntmSpeechSignal hntmSignal, HntmSpeechFrame[] leftContexts, HntmSpeechFrame[] rightContexts, BasicProsodyModifierParams pmodParams, HntmAnalyzerParams analysisParams) {
        int j;
        float alpha;
        int scaleIndex;
        int[] sortedIndices;
        HntmSpeechSignalWithContext output = null;
        if (!pmodParams.willProsodyBeModified()) {
            return new HntmSpeechSignalWithContext(hntmSignal, leftContexts, rightContexts);
        }
        if (pmodParams.tScalesTimes != null) {
            sortedIndices = MathUtils.quickSort(pmodParams.tScalesTimes);
            pmodParams.tScales = MathUtils.sortAs(pmodParams.tScales, sortedIndices);
        }
        float[] tScalesMod = new float[hntmSignal.frames.length + 1];
        float[] allScalesTimes = new float[hntmSignal.frames.length + 1];
        float[] pScalesMod = new float[hntmSignal.frames.length + 1];
        int i = 0;
        while (i < hntmSignal.frames.length) {
            allScalesTimes[i] = hntmSignal.frames[i].tAnalysisInSeconds;
            ++i;
        }
        allScalesTimes[hntmSignal.frames.length] = hntmSignal.frames[hntmSignal.frames.length - 1].tAnalysisInSeconds + (hntmSignal.frames[hntmSignal.frames.length - 1].tAnalysisInSeconds - hntmSignal.frames[hntmSignal.frames.length - 2].tAnalysisInSeconds);
        if (pmodParams.tScalesTimes != null) {
            if (pmodParams.tScales.length != pmodParams.tScalesTimes.length) {
                System.out.println("Error! Time scale array and associated instants should be of identical length");
                return null;
            }
            i = 0;
            while (i < allScalesTimes.length) {
                scaleIndex = MathUtils.findClosest(pmodParams.tScalesTimes, allScalesTimes[i]);
                if (allScalesTimes[i] > pmodParams.tScalesTimes[scaleIndex]) {
                    if (scaleIndex < pmodParams.tScalesTimes.length - 1) {
                        alpha = (double)(pmodParams.tScalesTimes[scaleIndex + 1] - pmodParams.tScalesTimes[scaleIndex]) > 1.0E-10 ? (pmodParams.tScalesTimes[scaleIndex + 1] - allScalesTimes[i]) / (pmodParams.tScalesTimes[scaleIndex + 1] - pmodParams.tScalesTimes[scaleIndex]) : 0.5f;
                        tScalesMod[i] = alpha * pmodParams.tScales[scaleIndex] + (1.0f - alpha) * pmodParams.tScales[scaleIndex + 1];
                    } else {
                        tScalesMod[i] = pmodParams.tScales[scaleIndex];
                    }
                } else if (allScalesTimes[i] < pmodParams.tScalesTimes[scaleIndex]) {
                    if (scaleIndex > 0) {
                        alpha = (double)(pmodParams.tScalesTimes[scaleIndex] - pmodParams.tScalesTimes[scaleIndex - 1]) > 1.0E-10 ? (pmodParams.tScalesTimes[scaleIndex] - allScalesTimes[i]) / (pmodParams.tScalesTimes[scaleIndex] - pmodParams.tScalesTimes[scaleIndex - 1]) : 0.5f;
                        tScalesMod[i] = alpha * pmodParams.tScales[scaleIndex - 1] + (1.0f - alpha) * pmodParams.tScales[scaleIndex];
                    } else {
                        tScalesMod[i] = pmodParams.tScales[scaleIndex];
                    }
                } else {
                    tScalesMod[i] = pmodParams.tScales[scaleIndex];
                }
                ++i;
            }
        } else {
            Arrays.fill(tScalesMod, pmodParams.tScales[0]);
        }
        if (pmodParams.pScalesTimes != null) {
            if (pmodParams.pScales.length != pmodParams.pScalesTimes.length) {
                System.out.println("Error! Pitch scale array and associated instants should be of identical length");
                return null;
            }
            i = 0;
            while (i < allScalesTimes.length) {
                scaleIndex = MathUtils.findClosest(pmodParams.pScalesTimes, allScalesTimes[i]);
                if (allScalesTimes[i] > pmodParams.pScalesTimes[scaleIndex]) {
                    if (scaleIndex < pmodParams.pScalesTimes.length - 1) {
                        alpha = (double)(pmodParams.pScalesTimes[scaleIndex + 1] - pmodParams.pScalesTimes[scaleIndex]) > 1.0E-10 ? (pmodParams.pScalesTimes[scaleIndex + 1] - allScalesTimes[i]) / (pmodParams.pScalesTimes[scaleIndex + 1] - pmodParams.pScalesTimes[scaleIndex]) : 0.5f;
                        pScalesMod[i] = alpha * pmodParams.pScales[scaleIndex] + (1.0f - alpha) * pmodParams.pScales[scaleIndex + 1];
                    } else {
                        pScalesMod[i] = pmodParams.pScales[scaleIndex];
                    }
                } else if (allScalesTimes[i] < pmodParams.pScalesTimes[scaleIndex]) {
                    if (scaleIndex > 0) {
                        alpha = (double)(pmodParams.pScalesTimes[scaleIndex] - pmodParams.pScalesTimes[scaleIndex - 1]) > 1.0E-10 ? (pmodParams.pScalesTimes[scaleIndex] - allScalesTimes[i]) / (pmodParams.pScalesTimes[scaleIndex] - pmodParams.pScalesTimes[scaleIndex - 1]) : 0.5f;
                        pScalesMod[i] = alpha * pmodParams.pScales[scaleIndex - 1] + (1.0f - alpha) * pmodParams.pScales[scaleIndex];
                    } else {
                        pScalesMod[i] = pmodParams.pScales[scaleIndex];
                    }
                } else {
                    pScalesMod[i] = pmodParams.pScales[scaleIndex];
                }
                ++i;
            }
        } else {
            Arrays.fill(pScalesMod, pmodParams.pScales[0]);
        }
        if (hntmSignal instanceof HntmPlusTransientsSpeechSignal && ((HntmPlusTransientsSpeechSignal)hntmSignal).transients != null) {
            int numTransientSegments = ((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments.length;
            if (output == null) {
                output = new HntmSpeechSignalWithContext();
            }
            output.hntmSignal = new HntmPlusTransientsSpeechSignal(hntmSignal.frames.length, hntmSignal.samplingRateInHz, hntmSignal.originalDurationInSeconds, numTransientSegments);
            output.leftContexts = new HntmSpeechFrame[hntmSignal.frames.length];
            output.rightContexts = new HntmSpeechFrame[hntmSignal.frames.length];
            if (numTransientSegments > 0) {
                float[] tempScales = new float[4 * numTransientSegments];
                float[] tempScalesTimes = new float[4 * numTransientSegments];
                float[] tempScales2 = ArrayUtils.copy(tScalesMod);
                float[] tempScalesTimes2 = ArrayUtils.copy(allScalesTimes);
                i = 0;
                while (i < numTransientSegments) {
                    tempScalesTimes[2 * i] = ((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments[i].startTime;
                    tempScales[2 * i] = 1.0f;
                    tempScalesTimes[2 * i + 1] = ((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments[i].getEndTime(hntmSignal.samplingRateInHz);
                    tempScales[2 * i + 1] = 1.0f;
                    if (tempScalesTimes2 != null) {
                        j = 0;
                        while (j < tempScalesTimes2.length) {
                            if (tempScalesTimes2[j] >= tempScalesTimes[2 * i] && tempScalesTimes2[j] <= tempScalesTimes[2 * i + 1]) {
                                tempScales2[j] = 1.0f;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                i = numTransientSegments;
                while (i < 2 * numTransientSegments) {
                    tempScalesTimes[2 * i] = ((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments[i - numTransientSegments].startTime - 0.001f;
                    tempScales[2 * i] = 1.0f;
                    j = 0;
                    while (j < allScalesTimes.length) {
                        if (tempScalesTimes[2 * i] > allScalesTimes[j]) {
                            tempScales[2 * i] = tScalesMod[j];
                            break;
                        }
                        ++j;
                    }
                    tempScalesTimes[2 * i + 1] = ((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments[i - numTransientSegments].getEndTime(hntmSignal.samplingRateInHz) + 0.001f;
                    tempScales[2 * i + 1] = 1.0f;
                    j = allScalesTimes.length - 1;
                    while (j >= 0) {
                        if (tempScalesTimes[2 * i + 1] < allScalesTimes[j]) {
                            tempScales[2 * i + 1] = tScalesMod[j];
                            break;
                        }
                        --j;
                    }
                    ++i;
                }
                tScalesMod = ArrayUtils.combine(tempScales, tempScales2);
                allScalesTimes = ArrayUtils.combine(tempScalesTimes, tempScalesTimes2);
                sortedIndices = MathUtils.quickSort(allScalesTimes);
                tScalesMod = MathUtils.sortAs(tScalesMod, sortedIndices);
                i = 0;
                while (i < numTransientSegments) {
                    ((HntmPlusTransientsSpeechSignal)output.hntmSignal).transients.segments[i] = new TransientSegment(((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments[i]);
                    ((HntmPlusTransientsSpeechSignal)output.hntmSignal).transients.segments[i].startTime = SignalProcUtils.timeScaledTime(((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments[i].startTime, tScalesMod, allScalesTimes);
                    ++i;
                }
            }
        } else {
            if (output == null) {
                output = new HntmSpeechSignalWithContext();
            }
            output.hntmSignal = new HntmSpeechSignal(hntmSignal.frames.length, hntmSignal.samplingRateInHz, hntmSignal.originalDurationInSeconds);
            output.leftContexts = new HntmSpeechFrame[hntmSignal.frames.length];
            output.rightContexts = new HntmSpeechFrame[hntmSignal.frames.length];
        }
        float[] tAnalysis = new float[hntmSignal.frames.length + 1];
        i = 0;
        while (i < hntmSignal.frames.length) {
            tAnalysis[i] = hntmSignal.frames[i].tAnalysisInSeconds;
            ++i;
        }
        tAnalysis[hntmSignal.frames.length] = hntmSignal.frames[hntmSignal.frames.length - 1].tAnalysisInSeconds + (hntmSignal.frames[hntmSignal.frames.length - 1].tAnalysisInSeconds - hntmSignal.frames[hntmSignal.frames.length - 2].tAnalysisInSeconds);
        boolean[] vuvs = new boolean[hntmSignal.frames.length + 1];
        i = 0;
        while (i < hntmSignal.frames.length) {
            vuvs[i] = (double)hntmSignal.frames[i].f0InHz > 10.0;
            ++i;
        }
        vuvs[hntmSignal.frames.length] = vuvs[hntmSignal.frames.length - 1];
        TDPSOLAInstants synthesisInstants = TDPSOLAProcessor.transformAnalysisInstants(tAnalysis, hntmSignal.samplingRateInHz, vuvs, tScalesMod, pScalesMod);
        if (output == null) {
            output = new HntmSpeechSignalWithContext();
        }
        output.hntmSignal = new HntmSpeechSignal(synthesisInstants.synthesisInstantsInSeconds.length, hntmSignal.samplingRateInHz, hntmSignal.originalDurationInSeconds);
        output.leftContexts = new HntmSpeechFrame[synthesisInstants.synthesisInstantsInSeconds.length];
        output.rightContexts = new HntmSpeechFrame[synthesisInstants.synthesisInstantsInSeconds.length];
        int currentSynthesisIndex = 0;
        boolean bBroke = false;
        i = 0;
        while (i < synthesisInstants.repeatSkipCounts.length) {
            j = 0;
            while (j <= synthesisInstants.repeatSkipCounts[i]) {
                if (i < hntmSignal.frames.length) {
                    output.hntmSignal.frames[currentSynthesisIndex] = new HntmSpeechFrame(hntmSignal.frames[i]);
                    if (leftContexts != null) {
                        output.leftContexts[currentSynthesisIndex] = new HntmSpeechFrame(leftContexts[i]);
                    }
                    if (rightContexts != null) {
                        output.rightContexts[currentSynthesisIndex] = new HntmSpeechFrame(rightContexts[i]);
                    }
                } else {
                    output.hntmSignal.frames[currentSynthesisIndex] = new HntmSpeechFrame(hntmSignal.frames[hntmSignal.frames.length - 1]);
                    if (leftContexts != null) {
                        output.leftContexts[currentSynthesisIndex] = new HntmSpeechFrame(leftContexts[hntmSignal.frames.length - 1]);
                    }
                    if (rightContexts != null) {
                        output.rightContexts[currentSynthesisIndex] = new HntmSpeechFrame(rightContexts[hntmSignal.frames.length - 1]);
                    }
                }
                output.hntmSignal.frames[currentSynthesisIndex].tAnalysisInSeconds = synthesisInstants.synthesisInstantsInSeconds[currentSynthesisIndex];
                if (++currentSynthesisIndex >= output.hntmSignal.frames.length) {
                    bBroke = true;
                    break;
                }
                ++j;
            }
            if (bBroke) break;
            ++i;
        }
        output.hntmSignal.originalDurationInSeconds = output.hntmSignal.frames[output.hntmSignal.frames.length - 1].tAnalysisInSeconds;
        if (analysisParams.noiseModel == 1 || analysisParams.noiseModel == 4 || analysisParams.noiseModel == 5) {
            double[] noisePartWaveform = NoisePartWaveformSynthesizer.synthesize(hntmSignal, leftContexts, rightContexts, analysisParams);
            int noiseWaveformLenMod = SignalProcUtils.time2sample(output.hntmSignal.originalDurationInSeconds, output.hntmSignal.samplingRateInHz);
            double[] noisePartWaveformMod = new double[noiseWaveformLenMod];
            double[] winWgtSum = new double[noiseWaveformLenMod];
            Arrays.fill(noisePartWaveformMod, 0.0);
            Arrays.fill(winWgtSum, 0.0);
            Window winNoise = null;
            double[] wgt = null;
            currentSynthesisIndex = 0;
            bBroke = false;
            boolean invert = false;
            i = 1;
            while (i < synthesisInstants.repeatSkipCounts.length - 1) {
                j = 0;
                while (j <= synthesisInstants.repeatSkipCounts[i]) {
                    int analysisStartInd;
                    int analysisEndInd = i < hntmSignal.frames.length - 1 ? SignalProcUtils.time2sample(hntmSignal.frames[i + 1].tAnalysisInSeconds, hntmSignal.samplingRateInHz) : noisePartWaveform.length - 1;
                    int wsNoise = analysisEndInd - (analysisStartInd = SignalProcUtils.time2sample(hntmSignal.frames[i - 1].tAnalysisInSeconds, hntmSignal.samplingRateInHz)) + 1;
                    if (wsNoise > 0) {
                        int kStart;
                        int halfWsNoise = (int)Math.floor(0.5 * (double)wsNoise + 0.5);
                        winNoise = Window.get(analysisParams.harmonicAnalysisWindowType, wsNoise);
                        wgt = winNoise.getCoeffs();
                        int synthesisMidInd = SignalProcUtils.time2sample(output.hntmSignal.frames[currentSynthesisIndex].tAnalysisInSeconds, output.hntmSignal.samplingRateInHz);
                        int synthesisStartInd = synthesisMidInd - halfWsNoise;
                        int synthesisEndInd = synthesisStartInd + wsNoise - 1;
                        int k = kStart = Math.max(0, synthesisStartInd);
                        while (k <= Math.min(synthesisEndInd, noiseWaveformLenMod - 1)) {
                            int kIndex = invert ? analysisEndInd - (k - kStart) : k - kStart + analysisStartInd;
                            int cfr_ignored_0 = noisePartWaveform.length;
                            try {
                                int n = k;
                                noisePartWaveformMod[n] = noisePartWaveformMod[n] + noisePartWaveform[kIndex] * wgt[k - kStart];
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                int n = k;
                                noisePartWaveformMod[n] = noisePartWaveformMod[n] + noisePartWaveform[kIndex - 1] * wgt[k - kStart];
                            }
                            ++k;
                        }
                    }
                    boolean bl = invert = !invert;
                    if (++currentSynthesisIndex >= output.hntmSignal.frames.length) {
                        bBroke = true;
                        break;
                    }
                    ++j;
                }
                if (bBroke) break;
                ++i;
            }
            i = 0;
            while (i < winWgtSum.length) {
                if (winWgtSum[i] > 0.0) {
                    int n = i;
                    noisePartWaveformMod[n] = noisePartWaveformMod[n] / winWgtSum[i];
                }
                ++i;
            }
            HntmAnalyzer.packNoisePartWaveforms(output.hntmSignal, noisePartWaveformMod);
        }
        if (HntmAnalyzerParams.UNWRAP_PHASES_ALONG_HARMONICS_AFTER_TIME_SCALING) {
            HntmAnalyzer.unwrapPhasesAlongHarmonics(output.hntmSignal);
        }
        pmodParams = new BasicProsodyModifierParams(tScalesMod, allScalesTimes, pScalesMod, allScalesTimes);
        if (pmodParams.pScales != null) {
            float[] currentCeps = null;
            i = 0;
            while (i < output.hntmSignal.frames.length) {
                boolean isVoiced = false;
                if (output.hntmSignal.frames[i].h != null && output.hntmSignal.frames[i].h.complexAmps != null && output.hntmSignal.frames[i].h.complexAmps.length > 0) {
                    isVoiced = true;
                }
                if (isVoiced) {
                    int pScaleInd;
                    float pScale;
                    int newTotalHarmonics;
                    if (!analysisParams.useHarmonicAmplitudesDirectly) {
                        currentCeps = output.hntmSignal.frames[i].h.getCeps(output.hntmSignal.frames[i].f0InHz, output.hntmSignal.samplingRateInHz, analysisParams);
                    }
                    if ((newTotalHarmonics = (int)Math.floor((double)((float)output.hntmSignal.frames[i].h.complexAmps.length / (pScale = pScalesMod[pScaleInd = MathUtils.findClosest(allScalesTimes, output.hntmSignal.frames[i].tAnalysisInSeconds)])) + 0.5)) > 0) {
                        int rightHarmonicInd;
                        int currentHarmonicNo;
                        double[] amps = new double[output.hntmSignal.frames[i].h.complexAmps.length];
                        int k = 0;
                        while (k < output.hntmSignal.frames[i].h.complexAmps.length) {
                            currentHarmonicNo = k + 1;
                            if (!analysisParams.useHarmonicAmplitudesDirectly) {
                                if (analysisParams.regularizedCepstrumWarpingMethod == 1) {
                                    amps[k] = RegularizedPreWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)currentHarmonicNo * output.hntmSignal.frames[i].f0InHz, output.hntmSignal.samplingRateInHz);
                                } else if (analysisParams.regularizedCepstrumWarpingMethod == 2) {
                                    amps[k] = RegularizedPostWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)currentHarmonicNo * output.hntmSignal.frames[i].f0InHz, output.hntmSignal.samplingRateInHz);
                                }
                            } else {
                                int leftHarmonicInd = (int)Math.floor((float)currentHarmonicNo * pScale) - 1;
                                amps[k] = leftHarmonicInd < 0 ? MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[0]) : ((rightHarmonicInd = leftHarmonicInd + 1) > output.hntmSignal.frames[i].h.complexAmps.length - 1 ? MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[output.hntmSignal.frames[i].h.complexAmps.length - 1]) : MathUtils.interpolatedSample((float)(leftHarmonicInd + 1) * output.hntmSignal.frames[i].f0InHz, (float)currentHarmonicNo * pScale * output.hntmSignal.frames[i].f0InHz, (float)(rightHarmonicInd + 1) * output.hntmSignal.frames[i].f0InHz, MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[leftHarmonicInd]), MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[rightHarmonicInd])));
                            }
                            double cfr_ignored_1 = amps[k];
                            double cfr_ignored_2 = amps[k];
                            ++k;
                        }
                        output.hntmSignal.frames[i].h.complexAmps = MathUtils.interpolate(output.hntmSignal.frames[i].h.complexAmps, newTotalHarmonics);
                        output.hntmSignal.frames[i].f0InHz *= pScale;
                        double[] linearAmps = new double[newTotalHarmonics];
                        double[] freqsInHz = new double[newTotalHarmonics];
                        double[] ampsMod = new double[newTotalHarmonics];
                        if (!analysisParams.useHarmonicAmplitudesDirectly) {
                            currentCeps = output.hntmSignal.frames[i].h.getCeps(output.hntmSignal.frames[i].f0InHz, output.hntmSignal.samplingRateInHz, analysisParams);
                        }
                        k = 0;
                        while (k < newTotalHarmonics) {
                            currentHarmonicNo = k + 1;
                            if (!analysisParams.useHarmonicAmplitudesDirectly) {
                                if (analysisParams.regularizedCepstrumWarpingMethod == 1) {
                                    ampsMod[k] = RegularizedPreWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)currentHarmonicNo * output.hntmSignal.frames[i].f0InHz, output.hntmSignal.samplingRateInHz);
                                } else if (analysisParams.regularizedCepstrumWarpingMethod == 2) {
                                    ampsMod[k] = RegularizedPostWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)currentHarmonicNo * output.hntmSignal.frames[i].f0InHz, output.hntmSignal.samplingRateInHz);
                                }
                            } else {
                                int leftHarmonicInd = (int)Math.floor((float)currentHarmonicNo * pScale) - 1;
                                ampsMod[k] = leftHarmonicInd < 0 ? MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[0]) : ((rightHarmonicInd = leftHarmonicInd + 1) > output.hntmSignal.frames[i].h.complexAmps.length - 1 ? MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[output.hntmSignal.frames[i].h.complexAmps.length - 1]) : MathUtils.interpolatedSample((float)(leftHarmonicInd + 1) * output.hntmSignal.frames[i].f0InHz, (float)currentHarmonicNo * pScale * output.hntmSignal.frames[i].f0InHz, (float)(rightHarmonicInd + 1) * output.hntmSignal.frames[i].f0InHz, MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[leftHarmonicInd]), MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[rightHarmonicInd])));
                            }
                            double cfr_ignored_3 = ampsMod[k];
                            double cfr_ignored_4 = ampsMod[k];
                            linearAmps[k] = ampsMod[k];
                            freqsInHz[k] = (float)currentHarmonicNo * output.hntmSignal.frames[i].f0InHz;
                            ++k;
                        }
                    } else {
                        output.hntmSignal.frames[i].h.complexAmps = null;
                    }
                }
                ++i;
            }
            if (HntmAnalyzerParams.UNWRAP_PHASES_ALONG_HARMONICS_AFTER_PITCH_SCALING) {
                HntmAnalyzer.unwrapPhasesAlongHarmonics(output.hntmSignal);
            }
        }
        return output;
    }
}

