/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.effects;

import marytts.signalproc.effects.BaseAudioEffect;
import marytts.signalproc.process.Chorus;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.MathUtils;

public class ChorusEffectBase
extends BaseAudioEffect {
    int[] delaysInMiliseconds;
    double[] amps;
    int frameLength;
    int maxDelayInMiliseconds;
    int maxDelayInSamples;
    int numTaps;
    public static int MAX_TAPS = 20;
    public static int MIN_DELAY = 0;
    public static int MAX_DELAY = 5000;
    public static double MIN_AMP = -5.0;
    public static double MAX_AMP = 5.0;

    public ChorusEffectBase() {
        this(16000);
    }

    public ChorusEffectBase(int samplingRate) {
        super(samplingRate);
        this.setExampleParameters("delay1" + chParamEquals + "466" + chParamSeparator + " amp1" + chParamEquals + "0.54" + chParamSeparator + " delay2" + chParamEquals + "600" + chParamSeparator + " amp2" + chParamEquals + "-0.10" + chParamSeparator + " delay3" + chParamEquals + "250" + chParamSeparator + " amp3" + chParamEquals + "0.30");
        this.strHelpText = this.getHelpText();
    }

    public void parseChildParameters(String param) {
        super.parseParameters(param);
    }

    @Override
    public void parseParameters(String param) {
        super.parseParameters(param);
        int[] tmpDelays = new int[MAX_TAPS];
        double[] tmpAmps = new double[MAX_TAPS];
        this.numTaps = 0;
        int i = 0;
        while (i < MAX_TAPS) {
            String strSearch = "delay" + String.valueOf(i + 1);
            tmpDelays[i] = this.expectIntParameter(strSearch);
            if (tmpDelays[i] > NULL_INT_PARAM) {
                ++this.numTaps;
                strSearch = "amp" + String.valueOf(i + 1);
                tmpAmps[i] = this.expectDoubleParameter(strSearch);
                if (tmpAmps[i] == NULL_DOUBLE_PARAM) {
                    tmpAmps[i] = 0.5;
                }
            }
            ++i;
        }
        if (this.numTaps > 0) {
            this.delaysInMiliseconds = new int[this.numTaps];
            this.amps = new double[this.numTaps];
            int tapInd = 0;
            i = 0;
            while (i < MAX_TAPS) {
                if (tmpDelays[i] > NULL_INT_PARAM) {
                    if (tapInd >= this.numTaps) break;
                    this.delaysInMiliseconds[tapInd] = tmpDelays[i];
                    this.amps[tapInd] = tmpAmps[i];
                    ++tapInd;
                }
                ++i;
            }
        } else {
            this.delaysInMiliseconds = null;
            this.amps = null;
        }
        this.initialise();
    }

    public void initialise() {
        if (this.delaysInMiliseconds != null) {
            this.numTaps = this.delaysInMiliseconds.length;
            if (this.numTaps > 0) {
                int i = 0;
                while (i < this.numTaps) {
                    this.delaysInMiliseconds[i] = MathUtils.CheckLimits(this.delaysInMiliseconds[i], MIN_DELAY, MAX_DELAY);
                    this.amps[i] = MathUtils.CheckLimits(this.amps[i], MIN_AMP, MAX_AMP);
                    ++i;
                }
                this.maxDelayInMiliseconds = MathUtils.getMax(this.delaysInMiliseconds);
                this.maxDelayInSamples = (int)((double)this.maxDelayInMiliseconds / 1000.0 * (double)this.fs);
                this.frameLength = Integer.getInteger("signalproc.lpcanalysissynthesis.framelength", 512);
                if (this.frameLength < this.maxDelayInSamples) {
                    this.frameLength *= 2;
                }
            }
        }
    }

    @Override
    public DoubleDataSource process(DoubleDataSource input) {
        Chorus chorus = new Chorus(this.delaysInMiliseconds, this.amps, this.fs);
        FrameOverlapAddSource foas = new FrameOverlapAddSource(input, 3, true, 1024, this.fs, chorus);
        return new BufferedDoubleDataSource(foas);
    }

    @Override
    public String getHelpText() {
        String strHelp = "Multi-Tap Chorus Effect:" + strLineBreak + "Adds chorus effect by summing up the original signal with delayed and amplitude scaled versions." + strLineBreak + "The parameters should consist of delay and amplitude pairs for each tap." + strLineBreak + "A variable number of taps (max 20) can be specified by simply defining more delay-amplitude pairs." + strLineBreak + "Each tap outputs a delayed and gain-scaled version of the original signal." + strLineBreak + "All tap outputs are summed up with the oiginal signal with appropriate gain normalization." + strLineBreak + "Parameters:" + strLineBreak + "   <delay1>" + strLineBreak + "   Definition : The amount of delay in miliseconds for tap #1" + strLineBreak + "   Range      : [0,5000]" + strLineBreak + "   <amp1>" + strLineBreak + "   Definition : Relative amplitude of the channel gain as compared to original signal gain for tap #1" + strLineBreak + "   Range      : [-5.0,5.0]" + strLineBreak + "   <delay2>" + strLineBreak + "   Definition : The amount of delay in miliseconds in delayed channel #2" + strLineBreak + "   Range      : [0,5000]" + strLineBreak + "   <amp2>" + strLineBreak + "   Definition : Relative amplitude of the channel gain as compared to original signal gain for delayed channel #2" + strLineBreak + "   Range      : [-5.0,5.0]" + strLineBreak + "   ..." + strLineBreak + "   <delayN>" + strLineBreak + "   Definition : The amount of delay in miliseconds in delayed channel #N" + strLineBreak + "   Range      : [0,5000]" + strLineBreak + "   <ampN>" + strLineBreak + "   Definition : Relative amplitude of the channel gain as compared to original signal gain for delayed channel #N" + strLineBreak + "   Range      : [-5.0,5.0]" + strLineBreak + "   Note: Maximum possible number of taps is N=20. Parameters for more taps will simply be neglected." + strLineBreak + "Example: (A three-tap chorus effect)" + strLineBreak + this.getExampleParameters();
        return strHelp;
    }

    @Override
    public String getName() {
        return "Chorus";
    }

    public DoubleDataSource apply(BufferedDoubleDataSource input) {
        Chorus c = new Chorus(this.delaysInMiliseconds, this.amps, this.fs);
        FrameOverlapAddSource foas = new FrameOverlapAddSource(input, 3, true, this.frameLength, this.fs, c);
        return new BufferedDoubleDataSource(foas);
    }
}

