/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.IOException;
import marytts.signalproc.analysis.ReflectionCoefficients;
import marytts.util.data.ESTTrackReader;
import marytts.util.data.ESTTrackWriter;

public class Lpc2Lprefc {
    private static float[][] convertData(float[][] lpc) {
        int nLPC = lpc[0].length;
        int nK = nLPC - 1;
        double[] a = new double[nLPC];
        a[0] = 1.0;
        double[] k = new double[nK];
        float[][] lprefc = new float[lpc.length][nK];
        int i = 0;
        while (i < lpc.length) {
            int j = 1;
            while (j < nLPC) {
                a[j] = lpc[i][j];
                ++j;
            }
            k = ReflectionCoefficients.lpc2lprefc(a);
            j = 0;
            while (j < nK) {
                lprefc[i][j] = (float)k[j];
                ++j;
            }
            ++i;
        }
        return lprefc;
    }

    public static void convert(String inFileName, String outFileName) throws IOException {
        ESTTrackReader etr = new ESTTrackReader(inFileName);
        float[][] lprefc = Lpc2Lprefc.convertData(etr.getFrames());
        ESTTrackWriter etw = new ESTTrackWriter(etr.getTimes(), lprefc, "lprefc");
        etw.doWriteAndClose(outFileName, etr.isBinary(), etr.isBigEndian());
    }

    public static void main(String[] args) throws IOException {
        Lpc2Lprefc.convert(args[0], args[1]);
    }
}

