/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.prosody;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import marytts.signalproc.analysis.Labels;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class BasicProsodyModifierParams
implements Serializable {
    public float[] tScales;
    public float[] tScalesTimes;
    public float[] pScales;
    public float[] pScalesTimes;

    public BasicProsodyModifierParams() {
    }

    public BasicProsodyModifierParams(BasicProsodyModifierParams existing) {
        this.setTScales(existing.tScales);
        this.setTScalesTimes(existing.tScalesTimes);
        this.setPScales(existing.pScales);
        this.setPScalesTimes(existing.pScalesTimes);
    }

    public BasicProsodyModifierParams(float[] tScalesIn, float[] tScalesTimesIn) {
        this();
        this.setTScales(tScalesIn);
        this.setTScalesTimes(tScalesTimesIn);
    }

    public BasicProsodyModifierParams(float[] tScalesIn, float[] tScalesTimesIn, float[] pScalesIn, float[] pScalesTimesIn) {
        this();
        this.setTScales(tScalesIn);
        this.setTScalesTimes(tScalesTimesIn);
        this.setPScales(pScalesIn);
        this.setPScalesTimes(pScalesTimesIn);
    }

    public BasicProsodyModifierParams(String sourcePtcFile, String sourceLabelFile, String targetPtcFile, String targetLabelFile, boolean isPitchScale, boolean isTimeScale) throws IOException {
        PitchReaderWriter f0Src = new PitchReaderWriter(sourcePtcFile);
        Labels labSrc = new Labels(sourceLabelFile);
        PitchReaderWriter f0Tgt = new PitchReaderWriter(targetPtcFile);
        Labels labTgt = new Labels(targetLabelFile);
        this.init(f0Src, labSrc, f0Tgt, labTgt, isPitchScale, isTimeScale);
    }

    public BasicProsodyModifierParams(PitchReaderWriter f0Src, Labels labSrc, PitchReaderWriter f0Tgt, Labels labTgt, boolean isPitchScale, boolean isTimeScale) {
        this.init(f0Src, labSrc, f0Tgt, labTgt, isPitchScale, isTimeScale);
    }

    public void init(PitchReaderWriter f0Src, Labels labSrc, PitchReaderWriter f0Tgt, Labels labTgt, boolean isPitchScale, boolean isTimeScale) {
        float tStartTgt;
        float tStartSrc;
        int numLabels = 0;
        if (labSrc != null && labTgt != null && labSrc.items != null && labTgt.items != null) {
            numLabels = Math.min(labSrc.items.length, labTgt.items.length);
        }
        if (isTimeScale && numLabels > 0) {
            this.tScales = new float[numLabels];
            this.tScalesTimes = new float[numLabels];
            tStartSrc = 0.0f;
            tStartTgt = 0.0f;
            int i = 0;
            while (i < numLabels) {
                this.tScales[i] = (float)((labTgt.items[i].time - (double)tStartTgt) / (labSrc.items[i].time - (double)tStartSrc));
                this.tScalesTimes[i] = (float)(0.5 * ((double)tStartSrc + labSrc.items[i].time));
                tStartTgt = (float)labTgt.items[i].time;
                tStartSrc = (float)labSrc.items[i].time;
                ++i;
            }
        } else {
            this.setTScales(1.0f);
            this.setTScalesTimes(null);
        }
        if (isPitchScale) {
            this.pScales = new float[f0Src.header.numfrm];
            this.pScalesTimes = new float[f0Src.header.numfrm];
            tStartSrc = 0.0f;
            tStartTgt = 0.0f;
            int i = 0;
            while (i < f0Src.header.numfrm) {
                int tgtF0Ind;
                double sourceTime = (double)i * f0Src.header.skipSizeInSeconds + 0.5 * f0Src.header.windowSizeInSeconds;
                if (labSrc != null && labTgt != null && labSrc.items != null && labTgt.items != null) {
                    int labInd = SignalProcUtils.frameIndex2LabelIndex(i, labSrc, f0Src.header.windowSizeInSeconds, f0Src.header.skipSizeInSeconds);
                    if (labInd > 1) {
                        tStartTgt = (float)labTgt.items[labInd - 1].time;
                        tStartSrc = (float)labSrc.items[labInd - 1].time;
                    } else {
                        tStartSrc = 0.0f;
                        tStartTgt = 0.0f;
                    }
                    double targetTime = MathUtils.linearMap(sourceTime, (double)tStartSrc, labSrc.items[labInd].time, (double)tStartTgt, labTgt.items[labInd].time);
                    tgtF0Ind = SignalProcUtils.time2frameIndex(targetTime, f0Tgt.header.windowSizeInSeconds, f0Tgt.header.skipSizeInSeconds);
                } else {
                    tgtF0Ind = MathUtils.linearMap(i, 0, f0Src.contour.length - 1, 0, f0Tgt.contour.length - 1);
                }
                this.pScales[i] = f0Src.contour[i] > 10.0 && f0Tgt.contour[tgtF0Ind] > 10.0 ? (float)(f0Tgt.contour[tgtF0Ind] / f0Src.contour[i]) : 1.0f;
                this.pScalesTimes[i] = (float)sourceTime;
                ++i;
            }
        } else {
            this.setPScales(1.0f);
            this.setPScalesTimes(null);
        }
    }

    public void setTScales(float x) {
        this.tScales = new float[1];
        this.tScales[0] = x;
    }

    public void setTScales(float[] x) {
        this.tScales = ArrayUtils.copy(x);
    }

    public void setTScalesTimes(float x) {
        this.tScalesTimes = new float[1];
        this.tScalesTimes[0] = x;
    }

    public void setTScalesTimes(float[] x) {
        this.tScalesTimes = ArrayUtils.copy(x);
    }

    public void setPScales(float x) {
        this.pScales = new float[1];
        this.pScales[0] = x;
    }

    public void setPScales(float[] x) {
        this.pScales = ArrayUtils.copy(x);
    }

    public void setPScalesTimes(float x) {
        this.pScalesTimes = new float[1];
        this.pScalesTimes[0] = x;
    }

    public void setPScalesTimes(float[] x) {
        this.pScalesTimes = ArrayUtils.copy(x);
    }

    public boolean willProsodyBeModified() {
        int i;
        if (this.pScales != null) {
            i = 0;
            while (i < this.pScales.length) {
                if (this.pScales[i] != 1.0f) {
                    return true;
                }
                ++i;
            }
        }
        if (this.tScales != null) {
            i = 0;
            while (i < this.tScales.length) {
                if (this.tScales[i] != 1.0f) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void writeObject(String fileName) throws IOException {
        new File(fileName);
        FileOutputStream fos = new FileOutputStream(fileName);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this);
        oos.close();
    }

    public static BasicProsodyModifierParams readObject(String fileName) throws IOException, ClassNotFoundException {
        try {
            File file = new File(fileName);
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            BasicProsodyModifierParams bpmp = (BasicProsodyModifierParams)ois.readObject();
            ois.close();
            return bpmp;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
    }
}

