/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart.impose;

import java.util.Arrays;
import marytts.cart.impose.FeatureComparator;
import marytts.cart.impose.FeatureFileIndexingResult;
import marytts.cart.impose.MaryNode;
import marytts.cart.impose.UnitIndexComparator;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;

public class FeatureArrayIndexer {
    private MaryNode tree = null;
    private int[] featureSequence = null;
    private FeatureComparator c = new FeatureComparator(-1, null);
    private UnitIndexComparator cui = new UnitIndexComparator();
    private FeatureVector[] featureVectors;
    private FeatureDefinition featureDefinition;
    private long numberOfLeaves = 0L;
    public static final int MAXDEPTH = 0;
    public static final int MAXLEVEL = 1;
    public static final int MINUNITS = 2;

    public FeatureArrayIndexer(FeatureVector[] featureVectors, FeatureDefinition featureDefinition, int[] setFeatureSequence) {
        this(featureVectors, featureDefinition);
        this.deepSort(setFeatureSequence);
    }

    public FeatureArrayIndexer(FeatureVector[] featureVectors, FeatureDefinition featureDefinition, String[] setFeatureSequence) {
        this(featureVectors, featureDefinition);
        this.deepSort(setFeatureSequence);
    }

    public FeatureArrayIndexer(FeatureVector[] featureVectors, FeatureDefinition featureDefinition) {
        this.featureVectors = featureVectors;
        this.featureDefinition = featureDefinition;
    }

    private void sortNode(int currentFeatureIdx, MaryNode currentNode) {
        if (currentFeatureIdx == this.featureSequence.length) {
            Arrays.sort(this.featureVectors, currentNode.from, currentNode.to, this.cui);
            ++this.numberOfLeaves;
            return;
        }
        int currentFeature = this.featureSequence[currentFeatureIdx];
        FeatureVector.FeatureType featureType = this.featureVectors[0].getFeatureType(currentFeature);
        currentNode.setFeatureIndex(currentFeature);
        this.c.setFeatureIdx(currentFeature, featureType);
        Arrays.sort(this.featureVectors, currentNode.from, currentNode.to, this.c);
        int nVal = this.featureDefinition.getNumberOfValues(currentFeature);
        currentNode.split(nVal);
        int nextFrom = currentNode.from;
        int nextTo = currentNode.from;
        int i = 0;
        while (i < nVal) {
            nextFrom = nextTo;
            while (nextTo < currentNode.to && this.featureVectors[nextTo].getFeatureAsInt(currentFeature) == i) {
                ++nextTo;
            }
            if (nextTo - nextFrom != 0) {
                MaryNode nod = new MaryNode(nextFrom, nextTo);
                currentNode.setChild(i, nod);
                this.sortNode(currentFeatureIdx + 1, nod);
            } else {
                currentNode.setChild(i, null);
            }
            ++i;
        }
    }

    public void deepSort(int[] setFeatureSequence) {
        this.featureSequence = setFeatureSequence;
        this.numberOfLeaves = 0L;
        this.tree = new MaryNode(0, this.featureVectors.length);
        this.sortNode(0, this.tree);
    }

    public void deepSort(String[] setFeatureSequence) {
        this.featureSequence = this.featureDefinition.getFeatureIndexArray(setFeatureSequence);
        this.numberOfLeaves = 0L;
        this.tree = new MaryNode(0, this.featureVectors.length);
        this.sortNode(0, this.tree);
    }

    private void fillNode(MaryNode currentNode) {
        if (currentNode.isLeaf()) {
            Arrays.sort(this.featureVectors, currentNode.from, currentNode.to, this.cui);
            ++this.numberOfLeaves;
            return;
        }
        int currentFeature = currentNode.featureIndex;
        FeatureVector.FeatureType featureType = this.featureVectors[0].getFeatureType(currentFeature);
        this.c.setFeatureIdx(currentFeature, featureType);
        Arrays.sort(this.featureVectors, currentNode.from, currentNode.to, this.c);
        int nVal = this.featureDefinition.getNumberOfValues(currentFeature);
        int nextFrom = currentNode.from;
        int nextTo = currentNode.from;
        int i = 0;
        while (i < nVal) {
            nextFrom = nextTo;
            while (nextTo < currentNode.to && this.featureVectors[nextTo].getFeatureAsInt(currentFeature) == i) {
                ++nextTo;
            }
            if (nextTo - nextFrom != 0) {
                MaryNode nod = currentNode.getChild(i);
                if (nod != null) {
                    nod.from = nextFrom;
                    nod.to = nextTo;
                    this.fillNode(nod);
                }
            } else {
                currentNode.setChild(i, null);
            }
            ++i;
        }
    }

    public void deepFill(MaryNode specTree) {
        this.tree = specTree;
        this.numberOfLeaves = 0L;
        this.sortNode(0, this.tree);
    }

    public FeatureFileIndexingResult retrieve(FeatureVector v) {
        int level = 0;
        if (this.tree == null) {
            throw new RuntimeException("Can't retrieve candidate units if a tree has not been built. (Run this.deepSort(int[]) or this.deepFill(MaryNode) first.)");
        }
        MaryNode n = this.tree;
        MaryNode next = null;
        while (!n.isLeaf()) {
            next = n.getChild(v.getFeatureAsInt(n.getFeatureIndex()));
            if (next == null) break;
            n = next;
            ++level;
        }
        FeatureFileIndexingResult qr = new FeatureFileIndexingResult(this.getFeatureVectors(n.from, n.to), level);
        return qr;
    }

    public FeatureFileIndexingResult retrieve(FeatureVector v, int condition, int parameter) {
        int level = 0;
        if (this.tree == null) {
            throw new RuntimeException("Can't retrieve candidate units if a tree has not been built. (Run this.deepSort(int[]) or this.deepFill(MaryNode) first.)");
        }
        MaryNode n = this.tree;
        MaryNode next = null;
        while (!n.isLeaf()) {
            next = n.getChild(v.getFeatureAsInt(n.getFeatureIndex()));
            if (condition == 2 && next.to - next.from < parameter || next == null) break;
            n = next;
            if (condition == 1 && ++level == parameter) break;
        }
        FeatureFileIndexingResult qr = new FeatureFileIndexingResult(this.getFeatureVectors(n.from, n.to), level);
        return qr;
    }

    public int[] getFeatureSequence() {
        return this.featureSequence;
    }

    public MaryNode getTree() {
        return this.tree;
    }

    public FeatureVector[] getFeatureVectors(int from, int to) {
        FeatureVector[] vectors = new FeatureVector[to - from];
        int i = from;
        while (i < to) {
            vectors[i - from] = this.featureVectors[i];
            ++i;
        }
        return vectors;
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.featureDefinition;
    }

    public long getNumberOfLeaves() {
        if (this.tree == null) {
            return -1L;
        }
        return this.numberOfLeaves;
    }

    public long getTheoreticalNumberOfLeaves(int[] feaSeq) {
        long ret = 1L;
        int i = 0;
        while (i < feaSeq.length) {
            if ((ret *= (long)this.featureDefinition.getNumberOfValues(feaSeq[i])) < 0L) {
                return -1L;
            }
            ++i;
        }
        return ret;
    }
}

