/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.data.sample;

import java.util.ArrayList;
import org.neuroph.core.data.DataSet;
import org.neuroph.util.data.sample.Sampling;

public class SubSampling
implements Sampling {
    private int numSubSets;
    private double[] subSetSizes;

    public SubSampling(int numSubSets) {
        this.numSubSets = numSubSets;
        this.subSetSizes = null;
    }

    public SubSampling(double ... subSetSizes) {
        double sum = 0.0;
        for (int i = 0; i < subSetSizes.length; ++i) {
            sum += subSetSizes[i];
        }
        if (sum > 1.0) {
            throw new IllegalArgumentException("Sum of sub set sizes cannot be greater then 1");
        }
        this.subSetSizes = subSetSizes;
        this.numSubSets = subSetSizes.length;
    }

    @Override
    public DataSet[] sample(DataSet dataSet) {
        if (this.subSetSizes == null) {
            double singleSubSetSize = 1.0 / (double)this.numSubSets;
            this.subSetSizes = new double[this.numSubSets];
            for (int i = 0; i < this.numSubSets; ++i) {
                this.subSetSizes[i] = singleSubSetSize;
            }
        }
        ArrayList<DataSet> subSets = new ArrayList<DataSet>();
        dataSet.shuffle();
        int idxCounter = 0;
        for (int subSetIdx = 0; subSetIdx < this.numSubSets; ++subSetIdx) {
            DataSet newSubSet = new DataSet(dataSet.getInputSize(), dataSet.getOutputSize());
            newSubSet.setColumnNames(dataSet.getColumnNames());
            long subSetSize = Math.round(this.subSetSizes[subSetIdx] * (double)dataSet.size());
            int i = 0;
            while ((long)i < subSetSize && idxCounter < dataSet.size()) {
                newSubSet.add(dataSet.getRowAt(idxCounter));
                ++idxCounter;
                ++i;
            }
            subSets.add(newSubSet);
        }
        return subSets.toArray(new DataSet[this.numSubSets]);
    }
}

