/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.data.norm;

import java.io.Serializable;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.util.data.norm.Normalizer;

public class MaxNormalizer
implements Normalizer,
Serializable {
    private double[] maxIn;
    private double[] maxOut;

    public MaxNormalizer(DataSet dataSet) {
        this.init(dataSet);
    }

    @Override
    public void normalize(DataSet dataSet) {
        for (DataSetRow row : dataSet.getRows()) {
            this.normalizeVector(row.getInput(), this.maxIn);
            if (!dataSet.isSupervised()) continue;
            this.normalizeVector(row.getDesiredOutput(), this.maxOut);
        }
    }

    private void init(DataSet dataSet) {
        int i;
        int inputSize = dataSet.getInputSize();
        int outputSize = dataSet.getOutputSize();
        this.maxIn = new double[inputSize];
        for (i = 0; i < inputSize; ++i) {
            this.maxIn[i] = Double.MIN_VALUE;
        }
        this.maxOut = new double[outputSize];
        for (i = 0; i < outputSize; ++i) {
            this.maxOut[i] = Double.MIN_VALUE;
        }
        for (DataSetRow dataSetRow : dataSet.getRows()) {
            double[] input = dataSetRow.getInput();
            for (int i2 = 0; i2 < inputSize; ++i2) {
                if (!(Math.abs(input[i2]) > this.maxIn[i2])) continue;
                this.maxIn[i2] = Math.abs(input[i2]);
            }
            double[] output = dataSetRow.getDesiredOutput();
            for (int i3 = 0; i3 < outputSize; ++i3) {
                if (!(Math.abs(output[i3]) > this.maxOut[i3])) continue;
                this.maxOut[i3] = Math.abs(output[i3]);
            }
        }
    }

    private void normalizeVector(double[] vector, double[] max) {
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = vector[i] / max[i];
        }
    }
}

