/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.data.norm;

import java.io.Serializable;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.util.data.norm.Normalizer;

public class DecimalScaleNormalizer
implements Normalizer,
Serializable {
    private double[] maxIn;
    private double[] maxOut;
    private double[] scaleFactorIn;
    private double[] scaleFactorOut;

    public DecimalScaleNormalizer(DataSet dataSet) {
        this.findMaxVectors(dataSet);
        this.findScaleVectors();
    }

    @Override
    public void normalize(DataSet dataSet) {
        for (DataSetRow dataSetRow : dataSet.getRows()) {
            double[] normalizedInput = this.normalizeScale(dataSetRow.getInput(), this.scaleFactorIn);
            dataSetRow.setInput(normalizedInput);
            if (!dataSet.isSupervised()) continue;
            double[] normalizedOutput = this.normalizeScale(dataSetRow.getDesiredOutput(), this.scaleFactorOut);
            dataSetRow.setDesiredOutput(normalizedOutput);
        }
    }

    private void findMaxVectors(DataSet dataSet) {
        int i;
        int inputSize = dataSet.getInputSize();
        int outputSize = dataSet.getOutputSize();
        this.maxIn = new double[inputSize];
        for (i = 0; i < inputSize; ++i) {
            this.maxIn[i] = Double.MIN_VALUE;
        }
        this.maxOut = new double[outputSize];
        for (i = 0; i < outputSize; ++i) {
            this.maxOut[i] = Double.MIN_VALUE;
        }
        for (DataSetRow dataSetRow : dataSet.getRows()) {
            double[] input = dataSetRow.getInput();
            for (int i2 = 0; i2 < inputSize; ++i2) {
                if (!(input[i2] > this.maxIn[i2])) continue;
                this.maxIn[i2] = input[i2];
            }
            double[] output = dataSetRow.getDesiredOutput();
            for (int i3 = 0; i3 < outputSize; ++i3) {
                if (!(output[i3] > this.maxOut[i3])) continue;
                this.maxOut[i3] = output[i3];
            }
        }
    }

    private void findScaleVectors() {
        int i;
        this.scaleFactorIn = new double[this.maxIn.length];
        for (i = 0; i < this.scaleFactorIn.length; ++i) {
            this.scaleFactorIn[i] = 1.0;
        }
        for (i = 0; i < this.maxIn.length; ++i) {
            while (this.maxIn[i] > 1.0) {
                this.maxIn[i] = this.maxIn[i] / 10.0;
                this.scaleFactorIn[i] = this.scaleFactorIn[i] * 10.0;
            }
        }
        this.scaleFactorOut = new double[this.maxOut.length];
        for (i = 0; i < this.scaleFactorOut.length; ++i) {
            this.scaleFactorOut[i] = 1.0;
        }
        for (i = 0; i < this.maxOut.length; ++i) {
            while (this.maxOut[i] > 1.0) {
                this.maxOut[i] = this.maxOut[i] / 10.0;
                this.scaleFactorOut[i] = this.scaleFactorOut[i] * 10.0;
            }
        }
    }

    private double[] normalizeScale(double[] vector, double[] scaleFactor) {
        double[] normalizedVector = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            normalizedVector[i] = vector[i] / scaleFactor[i];
        }
        return normalizedVector;
    }

    public double[] getMaxIn() {
        return this.maxIn;
    }

    public double[] getMaxOut() {
        return this.maxOut;
    }

    public double[] getScaleFactorIn() {
        return this.scaleFactorIn;
    }

    public double[] getScaleFactorOut() {
        return this.scaleFactorOut;
    }
}

