/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp.layer;

import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.core.input.WeightedSum;
import org.neuroph.core.transfer.Tanh;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.nnet.comp.Dimension2D;
import org.neuroph.nnet.comp.Kernel;
import org.neuroph.nnet.comp.layer.FeatureMapLayer;
import org.neuroph.nnet.comp.layer.FeatureMapsLayer;
import org.neuroph.nnet.comp.neuron.BiasNeuron;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.NeuronProperties;

public class ConvolutionalLayer
extends FeatureMapsLayer {
    private static final long serialVersionUID = -4619196904153707871L;
    public static final NeuronProperties DEFAULT_NEURON_PROP = new NeuronProperties();

    public ConvolutionalLayer(FeatureMapsLayer fromLayer, Dimension2D kernelDimension, int numberOfMaps) {
        Dimension2D fromDimension = fromLayer.getMapDimensions();
        int mapWidth = fromDimension.getWidth() - kernelDimension.getWidth() + 1;
        int mapHeight = fromDimension.getHeight() - kernelDimension.getHeight() + 1;
        this.mapDimensions = new Dimension2D(mapWidth, mapHeight);
        this.createFeatureMaps(numberOfMaps, this.mapDimensions, kernelDimension, DEFAULT_NEURON_PROP);
    }

    public ConvolutionalLayer(FeatureMapsLayer fromLayer, Dimension2D kernelDimension, int numberOfMaps, Class<? extends TransferFunction> transferFunction) {
        Dimension2D fromDimension = fromLayer.getMapDimensions();
        int mapWidth = fromDimension.getWidth() - kernelDimension.getWidth() + 1;
        int mapHeight = fromDimension.getHeight() - kernelDimension.getHeight() + 1;
        this.mapDimensions = new Dimension2D(mapWidth, mapHeight);
        NeuronProperties neuronProp = new NeuronProperties(Neuron.class, transferFunction);
        this.createFeatureMaps(numberOfMaps, this.mapDimensions, kernelDimension, neuronProp);
    }

    public ConvolutionalLayer(FeatureMapsLayer fromLayer, Dimension2D kernelDimension, int numberOfMaps, NeuronProperties neuronProp) {
        Dimension2D fromDimension = fromLayer.getMapDimensions();
        int mapWidth = fromDimension.getWidth() - kernelDimension.getWidth() + 1;
        int mapHeight = fromDimension.getHeight() - kernelDimension.getHeight() + 1;
        this.mapDimensions = new Dimension2D(mapWidth, mapHeight);
        this.createFeatureMaps(numberOfMaps, this.mapDimensions, kernelDimension, neuronProp);
    }

    @Override
    public void connectMaps(FeatureMapLayer fromMap, FeatureMapLayer toMap) {
        Kernel kernel = toMap.getKernel();
        kernel.initWeights(-0.15, 0.15);
        BiasNeuron biasNeuron = new BiasNeuron();
        fromMap.addNeuron(biasNeuron);
        for (int y = 0; y < toMap.getHeight(); ++y) {
            for (int x = 0; x < toMap.getWidth(); ++x) {
                Neuron toNeuron = toMap.getNeuronAt(x, y);
                for (int ky = 0; ky < kernel.getHeight(); ++ky) {
                    for (int kx = 0; kx < kernel.getWidth(); ++kx) {
                        int fromX = x + kx;
                        int fromY = y + ky;
                        Weight[][] concreteKernel = kernel.getWeights();
                        Neuron fromNeuron = fromMap.getNeuronAt(fromX, fromY);
                        ConnectionFactory.createConnection(fromNeuron, toNeuron, concreteKernel[kx][ky]);
                        ConnectionFactory.createConnection((Neuron)biasNeuron, toNeuron);
                    }
                }
            }
        }
    }

    private double getWeightCoeficient(FeatureMapLayer toMap) {
        int numberOfInputConnections = toMap.getNeuronAt(0, 0).getInputConnections().size();
        double coefficient = 1.0 / Math.sqrt(numberOfInputConnections);
        coefficient = !Double.isInfinite(coefficient) || !Double.isNaN(coefficient) || coefficient == 0.0 ? 1.0 : coefficient;
        return coefficient;
    }

    static {
        DEFAULT_NEURON_PROP.setProperty("inputFunction", WeightedSum.class);
        DEFAULT_NEURON_PROP.setProperty("transferFunction", Tanh.class);
        DEFAULT_NEURON_PROP.setProperty("useBias", true);
    }
}

