/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.learning.error;

import java.io.Serializable;
import org.neuroph.core.learning.error.ErrorFunction;

public final class MeanAbsoluteError
implements ErrorFunction,
Serializable {
    private transient double totalError;
    private transient int patternCount;

    public MeanAbsoluteError() {
        this.reset();
    }

    @Override
    public double[] addPatternError(double[] predictedOutput, double[] targetOutput) {
        double[] patternError = new double[targetOutput.length];
        for (int i = 0; i < predictedOutput.length; ++i) {
            patternError[i] = predictedOutput[i] - targetOutput[i];
            this.totalError += Math.abs(patternError[i]);
        }
        ++this.patternCount;
        return patternError;
    }

    @Override
    public void reset() {
        this.totalError = 0.0;
        this.patternCount = 0;
    }

    @Override
    public double getTotalError() {
        return this.totalError / (double)this.patternCount;
    }
}

