/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;

public class BufferedDataSet
extends DataSet
implements Iterator<DataSetRow> {
    private int bufferSize = 1000;
    private File file;
    private long fileLinesNumber;
    private long currentFileLineNumber;
    private int rowsLoaded;
    private String delimiter;
    FileReader fileReader = null;
    BufferedReader bufferedReader;
    List<DataSetRow> bufferedRows;
    Iterator<DataSetRow> bufferIterator;

    public BufferedDataSet(File file, int inputSize, String delimiter) {
        super(inputSize);
    }

    public BufferedDataSet(File file, int inputSize, int outputSize, String delimiter) throws FileNotFoundException {
        super(inputSize, outputSize);
        this.delimiter = delimiter;
        this.file = file;
        this.fileReader = new FileReader(file);
        this.bufferedReader = new BufferedReader(this.fileReader);
        this.fileLinesNumber = this.countFileLines();
        this.loadNextBuffer();
    }

    private long countFileLines() throws FileNotFoundException {
        LineNumberReader lnr = new LineNumberReader(new FileReader(this.file));
        try {
            while (lnr.skip(Long.MAX_VALUE) > 0L) {
            }
        }
        catch (IOException ex) {
            Logger.getLogger(BufferedDataSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        return lnr.getLineNumber() + 1;
    }

    @Override
    public Iterator<DataSetRow> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.currentFileLineNumber < this.fileLinesNumber;
    }

    @Override
    public DataSetRow next() {
        if (!this.bufferIterator.hasNext()) {
            this.loadNextBuffer();
        }
        ++this.currentFileLineNumber;
        return this.bufferIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void loadNextBuffer() {
        try {
            String line = "";
            this.clear();
            this.rowsLoaded = 0;
            while (this.rowsLoaded < this.bufferSize && (line = this.bufferedReader.readLine()) != null) {
                int i;
                ++this.rowsLoaded;
                double[] inputs = new double[this.getInputSize()];
                double[] outputs = new double[this.getOutputSize()];
                String[] values = line.split(this.delimiter);
                if (values[0].equals("")) continue;
                for (i = 0; i < this.getInputSize(); ++i) {
                    inputs[i] = Double.parseDouble(values[i]);
                }
                for (i = 0; i < this.getOutputSize(); ++i) {
                    outputs[i] = Double.parseDouble(values[this.getInputSize() + i]);
                }
                if (this.getOutputSize() > 0) {
                    this.add(new DataSetRow(inputs, outputs));
                    continue;
                }
                this.add(new DataSetRow(inputs));
            }
            this.bufferedRows = this.getRows();
            this.bufferIterator = this.bufferedRows.iterator();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            if (this.fileReader != null) {
                try {
                    this.fileReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ex.printStackTrace();
        }
        catch (NumberFormatException ex) {
            if (this.fileReader != null) {
                try {
                    this.fileReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ex.printStackTrace();
            throw ex;
        }
    }
}

