/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.pdf.create.page.item;

import com.lowagie.text.pdf.PdfContentByte;
import de.mn77.base.error.Err;
import de.mn77.ext.pdf.create.page.PDF_Page;
import de.mn77.ext.pdf.create.page.item.I_PDF_Item;
import java.awt.Color;

public class PDF_ItemLine
implements I_PDF_Item {
    private final float x1;
    private final float x2;
    private final float y1;
    private final float y2;
    private float thickness;
    private int[] colorRGB;

    public PDF_ItemLine(float x1, float y1, float x2, float y2) {
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.thickness = 1.0f;
        this.colorRGB = new int[3];
    }

    @Override
    public void draw(PDF_Page page, PdfContentByte cb) {
        cb.setColorStroke(new Color(this.colorRGB[0], this.colorRGB[1], this.colorRGB[2]));
        cb.setLineWidth(this.thickness);
        cb.moveTo(this.x1, page.getHeight() - this.y1);
        cb.lineTo(this.x2, page.getHeight() - this.y2);
        cb.stroke();
    }

    public PDF_ItemLine setColor(int r, int g, int b) {
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{r});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{g});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{b});
        this.colorRGB = new int[]{r, g, b};
        return this;
    }

    public PDF_ItemLine setThickness(double thickness) {
        Err.ifOutOfBounds((double)0.0, (double)50.0, (double[])new double[]{thickness});
        this.thickness = (float)thickness;
        return this;
    }
}

