/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.pdf.create.page.item;

import com.lowagie.text.pdf.PdfContentByte;
import de.mn77.base.error.Err;
import de.mn77.ext.pdf.create.page.PDF_Page;
import de.mn77.ext.pdf.create.page.item.I_PDF_Item;
import java.awt.Color;

public class PDF_ItemCircle
implements I_PDF_Item {
    private final float x;
    private final float y;
    private final float r;
    private float thickness;
    private int[] colorFill;
    private int[] colorBorder;
    private boolean isFilled;
    private boolean hasBorder;

    public PDF_ItemCircle(float x, float y, float r) {
        this.x = x;
        this.y = y;
        this.r = r;
        this.thickness = 1.0f;
        this.colorBorder = new int[3];
        this.colorFill = new int[3];
        this.isFilled = false;
        this.hasBorder = true;
    }

    @Override
    public void draw(PDF_Page page, PdfContentByte cb) {
        if (this.isFilled) {
            cb.setColorFill(new Color(this.colorFill[0], this.colorFill[1], this.colorFill[2]));
            cb.circle(this.x, page.getHeight() - this.y, this.r);
            cb.fill();
            cb.stroke();
        }
        if (this.hasBorder) {
            cb.setColorStroke(new Color(this.colorBorder[0], this.colorBorder[1], this.colorBorder[2]));
            cb.setLineWidth(this.thickness);
            cb.circle(this.x, page.getHeight() - this.y, this.r);
            cb.stroke();
        }
    }

    public PDF_ItemCircle setBorderColor(int r, int g, int b) {
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{r});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{g});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{b});
        this.colorBorder = new int[]{r, g, b};
        return this;
    }

    public PDF_ItemCircle setFillColor(int r, int g, int b) {
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{r});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{g});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{b});
        this.colorFill = new int[]{r, g, b};
        return this;
    }

    public PDF_ItemCircle setLineThickness(float staerke) {
        Err.ifOutOfBounds((double)0.0, (double)50.0, (double[])new double[]{staerke});
        this.thickness = staerke;
        return this;
    }

    public PDF_ItemCircle setStyle(boolean isFilled, boolean hasBorder) {
        if (!isFilled && !hasBorder) {
            Err.invalid((Object[])new Object[]{"A rectangle without fillig and border could not be drawed!"});
        }
        this.isFilled = isFilled;
        this.hasBorder = hasBorder;
        return this;
    }
}

