/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.pdf.create.page;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.error.Err;
import de.mn77.ext.pdf.create.constant.PDF_FONT;
import de.mn77.ext.pdf.create.constant.PDF_PAGEFORMAT;
import de.mn77.ext.pdf.create.page.item.I_PDF_Item;
import de.mn77.ext.pdf.create.page.item.PDF_ItemCircle;
import de.mn77.ext.pdf.create.page.item.PDF_ItemImage;
import de.mn77.ext.pdf.create.page.item.PDF_ItemLine;
import de.mn77.ext.pdf.create.page.item.PDF_ItemRectangle;
import de.mn77.ext.pdf.create.page.item.PDF_ItemText;
import de.mn77.lib.graphic.I_Image;
import java.util.ArrayList;

public class PDF_Page {
    private boolean isLandscape = false;
    private PDF_PAGEFORMAT format;
    private final ArrayList<I_PDF_Item> items = new ArrayList();
    private float lineThickness = 1.0f;
    private int[] colorBackground;
    private int[] colorLine;
    private int[] colorFont;
    private int[] colorFill;
    private int fontsize = 12;
    private PDF_FONT font;
    private POSITION_H fontAlignment;

    public PDF_Page() {
        this.format = PDF_PAGEFORMAT.A4;
        this.colorBackground = new int[]{255, 255, 255};
        this.colorLine = new int[3];
        this.colorFont = new int[3];
        this.colorFill = new int[3];
        this.font = PDF_FONT.HELVETICA;
        this.fontAlignment = POSITION_H.LEFT;
    }

    public void draw(PdfContentByte cb) {
        Rectangle rect = this.format.getRectangle();
        if (this.isLandscape) {
            rect = rect.rotate();
        }
        for (I_PDF_Item e : this.items) {
            e.draw(this, cb);
        }
    }

    public int[] getBackground() {
        return this.colorBackground;
    }

    public PDF_PAGEFORMAT getFormat() {
        return this.format;
    }

    public float getHeight() {
        Rectangle format = this.format.getRectangle();
        if (this.isLandscape) {
            format = format.rotate();
        }
        return format.getHeight();
    }

    public float getWidth() {
        Rectangle rect = this.format.getRectangle();
        if (this.isLandscape) {
            rect = rect.rotate();
        }
        return rect.getWidth();
    }

    public boolean isLandscape() {
        return this.isLandscape;
    }

    public PDF_ItemCircle newCircle(float x, float y, float r) {
        PDF_ItemCircle result = new PDF_ItemCircle(x, y, r);
        result.setLineThickness(this.lineThickness);
        result.setBorderColor(this.colorLine[0], this.colorLine[1], this.colorLine[2]);
        result.setFillColor(this.colorFill[0], this.colorFill[1], this.colorFill[2]);
        this.items.add(result);
        return result;
    }

    public PDF_ItemImage newImage(I_Image image, float x, float y) {
        PDF_ItemImage result = new PDF_ItemImage(image, x, y, image.getWidth(), image.getHeight());
        this.items.add(result);
        return result;
    }

    public PDF_ItemImage newImage(I_Image image, float x, float y, int dx, int dy) {
        PDF_ItemImage result = new PDF_ItemImage(image, x, y, dx, dy);
        this.items.add(result);
        return result;
    }

    public PDF_ItemLine newLine(float x1, float y1, float x2, float y2) {
        PDF_ItemLine result = new PDF_ItemLine(x1, y1, x2, y2);
        result.setThickness(this.lineThickness);
        result.setColor(this.colorLine[0], this.colorLine[1], this.colorLine[2]);
        this.items.add(result);
        return result;
    }

    public PDF_ItemRectangle newRectangle(float x, float y, float dx, float dy) {
        PDF_ItemRectangle result = new PDF_ItemRectangle(x, y, dx, dy);
        result.setThickness(this.lineThickness);
        result.setBorderColor(this.colorLine[0], this.colorLine[1], this.colorLine[2]);
        result.setFillColor(this.colorFill[0], this.colorFill[1], this.colorFill[2]);
        this.items.add(result);
        return result;
    }

    public PDF_ItemText newText(float x, float y, String text) {
        PDF_ItemText result = new PDF_ItemText(x, y, text);
        result.setColor(this.colorFont[0], this.colorFont[1], this.colorFont[2]);
        result.setFont(this.font);
        result.setFontsize(this.fontsize);
        result.setAlignment(this.fontAlignment);
        this.items.add(result);
        return result;
    }

    public PDF_Page setBackground(int ... rgb) {
        Err.ifNot((Object)3, (Object)rgb.length);
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[0]});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[1]});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[2]});
        this.colorBackground = rgb;
        return this;
    }

    public PDF_Page setFillColor(int ... rgb) {
        Err.ifNot((Object)3, (Object)rgb.length);
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[0]});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[1]});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[2]});
        this.colorFill = rgb;
        return this;
    }

    public PDF_Page setFont(PDF_FONT schrift) {
        Err.ifNull((Object)((Object)schrift));
        this.font = schrift;
        return this;
    }

    public PDF_Page setFontAlignment(POSITION_H align) {
        this.fontAlignment = align;
        return this;
    }

    public PDF_Page setFontColor(int ... rgb) {
        Err.ifNot((Object)3, (Object)rgb.length);
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[0]});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[1]});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[2]});
        this.colorFont = rgb;
        return this;
    }

    public PDF_Page setFontSize(int size) {
        Err.ifOutOfBounds((int)4, (int)100, (int[])new int[]{size});
        this.fontsize = size;
        return this;
    }

    public PDF_Page setFormat(PDF_PAGEFORMAT format) {
        Err.ifNull((Object)((Object)format));
        this.format = format;
        return this;
    }

    public PDF_Page setLineColor(int ... rgb) {
        Err.ifNot((Object)3, (Object)rgb.length);
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[0]});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[1]});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[2]});
        this.colorLine = rgb;
        return this;
    }

    public PDF_Page setOrientation(boolean isLandscape) {
        this.isLandscape = isLandscape;
        return this;
    }

    public PDF_Page setThickness(float thickness) {
        Err.ifOutOfBounds((double)0.1, (double)20.0, (double[])new double[]{thickness});
        this.lineThickness = thickness;
        return this;
    }
}

