/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.db.sql;

import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.data.struct.table.ArrayTitleTable;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_DataBase;
import de.mn77.ext.db.login.I_JDBC_Login;
import de.mn77.ext.db.sql.I_SqlDB;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public abstract class A_SqlDB
implements I_SqlDB {
    private Statement sqlStatement;
    private Connection sqlConnection;
    private boolean connected = false;

    @Override
    public void autoCommit(boolean b) {
        this.iCheckConnection();
        try {
            this.sqlConnection.setAutoCommit(b);
        }
        catch (SQLException e) {
            Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public void close() {
        if (this.connected) {
            try {
                this.sqlStatement.close();
                this.sqlConnection.close();
                this.connected = false;
            }
            catch (SQLException e) {
                Err.wrap((SQLException)e, (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void commit() {
        this.iCheckConnection();
        try {
            this.sqlConnection.commit();
        }
        catch (SQLException e) {
            Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public void connect(I_JDBC_Login login) throws Exception {
        this.connect(login, false);
    }

    @Override
    public void connect(I_JDBC_Login login, boolean createDatabase) throws Exception {
        if (this.connected) {
            throw new RuntimeException("Database already connected!");
        }
        if (createDatabase) {
            this.createDB(login);
        }
        try {
            this.sqlConnection = DriverManager.getConnection(this.jdbc(login), login.getUser(), login.getPass());
            this.sqlStatement = this.sqlConnection.createStatement();
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(e.getMessage()) + " '" + login.toString() + "'");
        }
        this.connected = true;
    }

    public I_Table<String> convertRSetToTable(ResultSet rset, boolean withTitles) throws SQLException {
        ArrayTitleTable result = null;
        int width = rset.getMetaData().getColumnCount();
        result = withTitles ? new ArrayTitleTable(width) : new ArrayTable(width);
        while (rset.next()) {
            String[] row = (String[])Array.newInstance(String.class, width);
            int i = 1;
            while (i <= width) {
                String t;
                Object o = rset.getObject(i);
                row[i - 1] = t = this.iObjectToString(o);
                ++i;
            }
            result.add((Object)row);
        }
        if (withTitles && this.canTitles()) {
            ArrayList<String> titles = new ArrayList<String>(width);
            int column = 1;
            while (column <= width) {
                String name = rset.getMetaData().getColumnName(column);
                titles.add(name);
                ++column;
            }
            result.setTitles(titles.toArray(new String[titles.size()]));
        }
        rset.close();
        return result;
    }

    @Override
    public boolean exec(String sql) throws Err_DataBase {
        this.iCheckConnection();
        try {
            return this.sqlStatement.execute(sql);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public Connection getConnection() {
        return this.sqlConnection;
    }

    public ResultSet getResultSet() {
        try {
            return this.sqlStatement.getResultSet();
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    public int getUpdateCount() {
        try {
            return this.sqlStatement.getUpdateCount();
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public ResultSet query(String sql) {
        return this.iGetResultSet(sql, true);
    }

    @Override
    public boolean query_boolean(String sql) throws Err_DataBase {
        try {
            return this.iGetResultSet(sql, false).getBoolean(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public double query_double(String sql) throws Err_DataBase {
        try {
            return this.iGetResultSet(sql, false).getDouble(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public float query_float(String sql) throws Err_DataBase {
        try {
            return this.iGetResultSet(sql, false).getFloat(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public int query_int(String sql) throws Err_DataBase {
        try {
            return this.iGetResultSet(sql, false).getInt(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public long query_long(String sql) throws Err_DataBase {
        try {
            return this.iGetResultSet(sql, false).getLong(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> queryColumn(String sql) {
        this.iCheckConnection();
        ArrayList<String> result = new ArrayList<String>();
        try {
            ResultSet rset = this.sqlStatement.executeQuery(sql);
            int breite = rset.getMetaData().getColumnCount();
            if (breite == 0) {
                return result;
            }
            while (true) {
                if (!rset.next()) {
                    return result;
                }
                Object o = rset.getObject(1);
                result.add(this.iObjectToString(o));
            }
        }
        catch (SQLException e) {
            Err.wrap((SQLException)e, (Object[])new Object[]{sql});
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Integer> queryColumnInteger(String sql) {
        this.iCheckConnection();
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            ResultSet rset = this.sqlStatement.executeQuery(sql);
            int breite = rset.getMetaData().getColumnCount();
            if (breite == 0) {
                return result;
            }
            while (true) {
                if (!rset.next()) {
                    return result;
                }
                Object o = rset.getObject(1);
                result.add(this.iObjectToInteger(o));
            }
        }
        catch (SQLException e) {
            Err.wrap((SQLException)e, (Object[])new Object[]{sql});
        }
        return result;
    }

    @Override
    public boolean queryEmpty(String sql) throws Err_DataBase {
        return this.queryObject(sql) == null;
    }

    @Override
    public Integer queryInteger(String sql) throws Err_DataBase {
        try {
            ResultSet rs = this.iGetResultSet(sql, true);
            return rs == null || rs.getObject(1) == null ? null : Integer.valueOf(rs.getInt(1));
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public Object queryObject(String sql) {
        try {
            ResultSet rs = this.iGetResultSet(sql, true);
            return rs == null ? null : rs.getObject(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[]{sql});
        }
    }

    @Override
    public List<String> queryRow(String sql) {
        this.iCheckConnection();
        ArrayList<String> result = new ArrayList<String>();
        try {
            ResultSet rset = this.sqlStatement.executeQuery(sql);
            if (rset.next()) {
                int i = 1;
                while (i <= rset.getMetaData().getColumnCount()) {
                    Object o = rset.getObject(i);
                    result.add(this.iObjectToString(o));
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            Err.wrap((SQLException)e, (Object[])new Object[]{sql});
        }
        return result;
    }

    @Override
    public String queryString(String sql) throws Err_DataBase {
        try {
            ResultSet rs = this.iGetResultSet(sql, true);
            return rs == null || rs.getObject(1) == null ? null : rs.getString(1);
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public ArrayTable<String> queryTable(String sql) {
        try {
            return (ArrayTable)this.iQueryToTable(sql, false);
        }
        catch (SQLException e) {
            Err.show((Throwable)e, (String)"SQL-Error");
            return null;
        }
    }

    public ArrayTitleTable<String> queryTitleTable(String sql) {
        try {
            return (ArrayTitleTable)this.iQueryToTable(sql, true);
        }
        catch (SQLException e) {
            Err.show((Throwable)e, (String)"SQL-Error");
            return null;
        }
    }

    @Override
    public void rollback() {
        this.iCheckConnection();
        try {
            this.sqlConnection.rollback();
        }
        catch (SQLException e) {
            Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    @Override
    public int update(String sql) throws Err_DataBase {
        this.iCheckConnection();
        try {
            boolean hasResults = this.sqlStatement.execute(sql);
            return hasResults ? 0 : this.sqlStatement.getUpdateCount();
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[0]);
        }
    }

    protected abstract boolean canTitles();

    protected void createDB(I_JDBC_Login login) throws Exception {
        Err.invalid((Object[])new Object[0]);
    }

    @Deprecated
    protected void finalize() throws Throwable {
        this.close();
        this.connected = false;
        super.finalize();
    }

    protected abstract String jdbc(I_JDBC_Login var1);

    private void iCheckConnection() {
        if (!this.connected) {
            throw new RuntimeException("Database not connected!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultSet iGetResultSet(String sql, boolean nullAllowed) {
        this.iCheckConnection();
        ResultSet result = null;
        try {
            result = this.sqlStatement.executeQuery(sql);
            Err.ifTooSmall((double)1.0, (double)result.getMetaData().getColumnCount());
            if (result.next()) {
                if (nullAllowed) return result;
                if (result.getObject(1) != null) return result;
                throw new Err_DataBase("An empty value cannot be converted", new Object[]{sql, result});
            }
            if (nullAllowed) {
                return null;
            }
            throw new Err_DataBase("ResultSet contains no data", new Object[]{sql, result});
        }
        catch (SQLException e) {
            throw Err.wrap((SQLException)e, (Object[])new Object[]{sql});
        }
    }

    private Integer iObjectToInteger(Object o) {
        return o == null ? null : Integer.valueOf(Integer.parseInt(o.toString()));
    }

    private String iObjectToString(Object o) {
        String t;
        String string = t = o == null ? null : o.toString();
        if (t != null && o.getClass() == Timestamp.class) {
            t = t.substring(0, 19);
        }
        return t;
    }

    private I_Table<String> iQueryToTable(String sql, boolean withTitles) throws SQLException {
        this.iCheckConnection();
        ResultSet rset = this.sqlStatement.executeQuery(sql);
        return this.convertRSetToTable(rset, withTitles);
    }
}

