/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.db.container;

import de.mn77.base.data.container.I_Box;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.error.Err;
import de.mn77.ext.db.container.A_DB_BoxStack;
import java.util.Map;

public final class DBBox<T>
implements I_Box<T> {
    public final Class<T> type;
    public final Integer size;
    public final boolean primaryKey;
    public final boolean notNull;
    public final boolean autoCounter;
    public final T defaultValue;
    private final A_DB_BoxStack stack;
    private final boolean update;
    private String name = null;
    private boolean empty = true;
    private T value = null;

    public static DBBox<Boolean> newBool(A_DB_BoxStack box, boolean notnull) {
        return new DBBox<Object>(box, Boolean.class, null, null, notnull, false, false, false);
    }

    public static DBBox<Boolean> newBool(A_DB_BoxStack box, boolean notnull, boolean standard) {
        return new DBBox<Boolean>(box, Boolean.class, standard, null, notnull, false, false, false);
    }

    public static DBBox<I_Date> newDatum(A_DB_BoxStack box, boolean notnull) {
        return new DBBox<Object>(box, I_Date.class, null, null, notnull, false, false, false);
    }

    public static DBBox<Integer> newInteger(A_DB_BoxStack box, boolean notnull) {
        return new DBBox<Object>(box, Integer.class, null, null, notnull, false, false, false);
    }

    public static DBBox<Integer> newInteger(A_DB_BoxStack box, boolean notnull, int standard) {
        return new DBBox<Integer>(box, Integer.class, standard, null, notnull, false, false, false);
    }

    public static DBBox<Long> newLong(A_DB_BoxStack box, boolean notnull) {
        return new DBBox<Object>(box, Long.class, null, null, notnull, false, false, false);
    }

    public static DBBox<Long> newLong(A_DB_BoxStack box, boolean notnull, long standard) {
        return new DBBox<Long>(box, Long.class, standard, null, notnull, false, false, false);
    }

    public static DBBox<Integer> newPrimaryKey(A_DB_BoxStack box, boolean autoincrement) {
        return new DBBox<Object>(box, Integer.class, null, null, true, true, autoincrement, false);
    }

    public static DBBox<Long> newPrimaryKeyLong(A_DB_BoxStack box, boolean autoincrement) {
        return new DBBox<Object>(box, Long.class, null, null, true, true, autoincrement, false);
    }

    public static DBBox<String> newString(A_DB_BoxStack box, int size, boolean notnull) {
        return new DBBox<Object>(box, String.class, null, size, notnull, false, false, false);
    }

    public static DBBox<String> newString(A_DB_BoxStack box, int size, boolean notnull, String standard) {
        return new DBBox<String>(box, String.class, standard, size, notnull, false, false, false);
    }

    public static DBBox<String> newStringFlex(A_DB_BoxStack box, boolean notnull) {
        return new DBBox<Object>(box, String.class, null, null, notnull, false, false, false);
    }

    public static DBBox<I_DateTime> newZeitpunkt(A_DB_BoxStack box, boolean notnull) {
        return new DBBox<Object>(box, I_DateTime.class, null, null, notnull, false, false, false);
    }

    public static <T> DBBox<T> update(A_DB_BoxStack box, Class<T> typ, Integer size, boolean notnull, T init) {
        DBBox<T> result = new DBBox<T>(box, typ, init, size, notnull, false, false, true);
        result.set(init);
        return result;
    }

    public static <T1> DBBox<T1> update(A_DB_BoxStack box, Class<T1> typ, Integer size, boolean notnull) {
        return new DBBox<Object>(box, typ, null, size, notnull, false, false, true);
    }

    public static DBBox<Boolean> updateBool(A_DB_BoxStack box, boolean notnull) {
        return new DBBox<Object>(box, Boolean.class, null, null, notnull, false, false, true);
    }

    public static DBBox<Boolean> updateBool(A_DB_BoxStack box, boolean notnull, boolean standard) {
        return new DBBox<Boolean>(box, Boolean.class, standard, null, notnull, false, false, true);
    }

    public static DBBox<I_Date> updateDatum(A_DB_BoxStack box, boolean notnull) {
        return new DBBox<Object>(box, I_Date.class, null, null, notnull, false, false, true);
    }

    public static DBBox<Integer> updateInteger(A_DB_BoxStack box, boolean notnull) {
        return new DBBox<Object>(box, Integer.class, null, null, notnull, false, false, true);
    }

    public static DBBox<Integer> updateInteger(A_DB_BoxStack box, boolean notnull, Integer standard) {
        return new DBBox<Integer>(box, Integer.class, standard, null, notnull, false, false, true);
    }

    public static DBBox<Integer> updatePrimaryKey(A_DB_BoxStack box, boolean autoincrement) {
        return new DBBox<Object>(box, Integer.class, null, null, true, true, autoincrement, true);
    }

    public static DBBox<String> updateString(A_DB_BoxStack box, int size, boolean notnull) {
        return new DBBox<Object>(box, String.class, null, size, notnull, false, false, true);
    }

    public static DBBox<String> updateStringFlex(A_DB_BoxStack box, boolean notnull) {
        return new DBBox<Object>(box, String.class, null, null, notnull, false, false, true);
    }

    public static DBBox<I_DateTime> updateZeitpunkt(A_DB_BoxStack box, boolean notnull) {
        return new DBBox<Object>(box, I_DateTime.class, null, null, notnull, false, false, true);
    }

    private DBBox(A_DB_BoxStack stack, Class<T> typ, T defaultValue, Integer size, boolean notNull, boolean primaryKey, boolean autoCounter, boolean update) {
        this.stack = stack;
        this.type = typ;
        this.size = size;
        this.notNull = notNull;
        this.primaryKey = primaryKey;
        this.autoCounter = autoCounter;
        this.defaultValue = defaultValue;
        this.update = update;
    }

    public DBBox<T> copy() {
        DBBox<T> copy = new DBBox<T>(this.stack, this.type, this.defaultValue, this.size, this.notNull, this.primaryKey, this.autoCounter, this.update);
        copy.name = this.name;
        copy.empty = this.empty;
        copy.value = this.value;
        return copy;
    }

    public T get() {
        return this.value;
    }

    public Group2<Boolean, T> getCopy() {
        return new Group2((Object)this.empty, this.value);
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getError() {
        if (!this.primaryKey && this.notNull && this.value == null) {
            return "Pflichtfeld ist NULL";
        }
        if (this.type == String.class && ("" + this.value).length() > this.size) {
            return "Text ist zu lang";
        }
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        for (Map.Entry e : this.stack.getBoxes().entrySet()) {
            if (!((I_Box)e.getValue()).equals(this)) continue;
            return ((String)e.getKey()).toLowerCase();
        }
        throw Err.invalid((Object[])new Object[]{this});
    }

    public Integer getSize() {
        return this.size;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isAutoCounter() {
        return this.autoCounter;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isRequired() {
        return this.notNull;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public boolean isValid() {
        return this.getError() == null;
    }

    public void set(T value) {
        if (this.notNull && value == null) {
            Err.forbidden((Object[])new Object[]{"A required field can not be NULL!", this.getName()});
        }
        this.value = value;
        this.empty = false;
    }

    public void setCopy(Group2<Boolean, T> g) {
        this.empty = (Boolean)g.o1;
        this.value = g.o2;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.get() + ")";
    }
}

