/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci;

import java.io.InputStream;
import java.net.URL;
import org.apache.commons.jci.listeners.ReloadNotificationListener;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.ResourceStoreClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReloadingClassLoader
extends ClassLoader
implements ReloadNotificationListener {
    private final Log log = LogFactory.getLog(ReloadingClassLoader.class);
    private final ClassLoader parent;
    private ResourceStore[] stores = new ResourceStore[0];
    private ClassLoader delegate;

    public ReloadingClassLoader(ClassLoader pParent) {
        super(pParent);
        this.parent = pParent;
        this.delegate = new ResourceStoreClassLoader(this.parent, this.stores);
    }

    public boolean addResourceStore(ResourceStore pStore) {
        try {
            int n = this.stores.length;
            ResourceStore[] newStores = new ResourceStore[n + 1];
            System.arraycopy(this.stores, 0, newStores, 1, n);
            newStores[0] = pStore;
            this.stores = newStores;
            this.delegate = new ResourceStoreClassLoader(this.parent, this.stores);
            return true;
        }
        catch (RuntimeException e) {
            this.log.error((Object)("could not add resource store " + pStore));
            return false;
        }
    }

    public boolean removeResourceStore(ResourceStore pStore) {
        int i;
        int n = this.stores.length;
        for (i = 0; i < n && this.stores[i] != pStore; ++i) {
        }
        if (i == n) {
            return false;
        }
        ResourceStore[] newStores = new ResourceStore[n - 1];
        if (i > 0) {
            System.arraycopy(this.stores, 0, newStores, 0, i);
        }
        if (i < n - 1) {
            System.arraycopy(this.stores, i + 1, newStores, i, n - i - 1);
        }
        this.stores = newStores;
        this.delegate = new ResourceStoreClassLoader(this.parent, this.stores);
        return true;
    }

    @Override
    public void handleNotification() {
        this.log.debug((Object)"reloading");
        this.delegate = new ResourceStoreClassLoader(this.parent, this.stores);
    }

    @Override
    public void clearAssertionStatus() {
        this.delegate.clearAssertionStatus();
    }

    @Override
    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.delegate.getResourceAsStream(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.delegate.loadClass(name);
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        this.delegate.setClassAssertionStatus(className, enabled);
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        this.delegate.setDefaultAssertionStatus(enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.delegate.setPackageAssertionStatus(packageName, enabled);
    }
}

