/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.group.Group3;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.I_Decimal;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class Lib_NumberStyle {
    public static String style(CallRuntime cr, A_Number number, String format) {
        Group3<Integer, Boolean, String> formatDotIndex = Lib_NumberStyle.iFormatDotIndex(format);
        boolean useDot = formatDotIndex != null && ((Boolean)formatDotIndex.o2 != false || number instanceof I_Decimal);
        String nums = useDot ? "" + Lib_Convert.getDoubleValue(cr, number) : "" + Lib_Convert.getIntValue(cr, number);
        int numberDotIndex = Lib_NumberStyle.iNumberDotIndex(nums);
        String numberLeft = numberDotIndex == -1 ? nums : nums.substring(0, numberDotIndex);
        String numberRight = numberDotIndex == -1 ? "" : nums.substring(numberDotIndex + 1);
        String formatLeft = formatDotIndex == null ? format : format.substring(0, (Integer)formatDotIndex.o1);
        String formatRight = formatDotIndex == null ? "" : format.substring((Integer)formatDotIndex.o1 + 1);
        String dot = useDot ? (String)formatDotIndex.o3 : "";
        String left = "";
        int nPos = numberLeft.length() - 1;
        int fPos = formatLeft.length() - 1;
        while (fPos >= 0) {
            char f = formatLeft.charAt(fPos);
            if (fPos > 0 && formatLeft.charAt(fPos - 1) == '~') {
                left = String.valueOf(f) + left;
                --fPos;
            } else {
                switch (f) {
                    case '0': {
                        left = nPos >= 0 ? String.valueOf(numberLeft.charAt(nPos)) + left : "0" + left;
                        --nPos;
                        break;
                    }
                    case '#': {
                        left = nPos >= 0 ? String.valueOf(numberLeft.charAt(nPos)) + left : " " + left;
                        --nPos;
                        break;
                    }
                    case '?': {
                        if (nPos >= 0) {
                            left = String.valueOf(numberLeft.charAt(nPos)) + left;
                        }
                        --nPos;
                        break;
                    }
                    case '_': {
                        if (nPos < 0) break;
                        left = " " + left;
                        break;
                    }
                    case '*': {
                        if (nPos < 0) break;
                        left = "." + left;
                        break;
                    }
                    default: {
                        left = String.valueOf(f) + left;
                    }
                }
            }
            --fPos;
        }
        if (nPos >= 0) {
            left = String.valueOf(numberLeft.substring(0, nPos + 1)) + left;
        }
        boolean jump = false;
        StringBuilder right = new StringBuilder();
        nPos = 0;
        boolean hasLeftNum = false;
        int nLen = numberRight.length();
        int fPos2 = 0;
        while (fPos2 < formatRight.length()) {
            char f = formatRight.charAt(fPos2);
            if (jump) {
                right = right.append(f);
                jump = false;
            } else if (f == '~') {
                jump = true;
            } else {
                switch (f) {
                    case '0': {
                        right = nPos < nLen ? right.append(numberRight.charAt(nPos)) : right.append('0');
                        hasLeftNum = true;
                        ++nPos;
                        break;
                    }
                    case '#': {
                        if (nPos < nLen) {
                            right = right.append(numberRight.charAt(nPos));
                            hasLeftNum = true;
                        } else {
                            right = right.append(' ');
                        }
                        ++nPos;
                        break;
                    }
                    case '?': {
                        if (nPos < nLen) {
                            right = right.append(numberRight.charAt(nPos));
                            hasLeftNum = true;
                        }
                        ++nPos;
                        break;
                    }
                    case '_': {
                        if (!hasLeftNum) break;
                        right = right.append(' ');
                        break;
                    }
                    case '*': {
                        if (!hasLeftNum) break;
                        right = right.append('.');
                        break;
                    }
                    default: {
                        right = right.append(f);
                    }
                }
            }
            ++fPos2;
        }
        return String.valueOf(left) + dot + right.toString();
    }

    private static Group3<Integer, Boolean, String> iFormatDotIndex(String s) {
        boolean jump = false;
        int i = 0;
        while (i < s.length()) {
            if (jump) {
                jump = false;
            } else {
                switch (s.charAt(i)) {
                    case '~': {
                        jump = true;
                        break;
                    }
                    case '.': {
                        return new Group3<Integer, Boolean, String>(i, true, ".");
                    }
                    case ',': {
                        return new Group3<Integer, Boolean, String>(i, true, ",");
                    }
                    case ':': {
                        return new Group3<Integer, Boolean, String>(i, false, ".");
                    }
                    case ';': {
                        return new Group3<Integer, Boolean, String>(i, false, ",");
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private static int iNumberDotIndex(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '.') {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

