/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.runtime;

import de.mn77.base.data.convert.ConvertSequence;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.I_Series;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ErrorBase;
import org.jaymo_lang.error.JayMoError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.error.RuntimeWarning;
import org.jaymo_lang.model.App;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.FunctionPar;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.StrictManager;
import org.jaymo_lang.model.Type;
import org.jaymo_lang.object.I_HasConstructor;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.I_ObjectReplace;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.immute.JMo_Enum;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.magic.I_MagicReplace;
import org.jaymo_lang.object.passthrough.I_Mem;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.object.pseudo.A_MemLet;
import org.jaymo_lang.object.pseudo.FuncLet;
import org.jaymo_lang.object.pseudo.MultiCall;
import org.jaymo_lang.object.pseudo.NonAtomic;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.pseudo.VarLet;
import org.jaymo_lang.object.struct.A_Sequence;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.parser.I_DebugInfoSource;
import org.jaymo_lang.runtime.Instance;
import org.jaymo_lang.runtime.NEW_VCE;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.runtime.VarConstEnv;
import org.jaymo_lang.util.Lib_Arguments;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_MagicVar;
import org.jaymo_lang.util.Lib_Prio;

public class CallRuntime
implements I_DebugInfoSource {
    public final CallRuntime parent;
    public final Instance instance;
    public final Call call;
    public final VarConstEnv vce;
    public final CallRuntime funcOutside;
    private I_Object[] args_result = null;
    private I_Object curObject = null;

    public CallRuntime(CallRuntime parent, Instance instance, Call call) {
        this(parent, instance, call, null, NEW_VCE.NEW_LEVEL, null);
    }

    public CallRuntime(CallRuntime parent, Instance instance, Call call, VarConstEnv parentVCE) {
        this(parent, instance, call, parentVCE, NEW_VCE.NEW_LEVEL, null);
    }

    private CallRuntime(CallRuntime parent, Instance instance, Call call, VarConstEnv parentVCE, NEW_VCE varEnvNew, CallRuntime funcOutside) {
        this.parent = parent;
        this.instance = instance;
        this.call = call;
        this.funcOutside = funcOutside;
        this.vce = varEnvNew == NEW_VCE.KEEP_PARENT ? parentVCE : (varEnvNew == NEW_VCE.WRAP_PARENT ? new VarConstEnv(parentVCE.vars, parentVCE.cons, parentVCE) : new VarConstEnv(parentVCE));
    }

    public int argCount() {
        return this.call.getArgCount();
    }

    public I_Object argEach(I_Object itStream, int argIdx, I_Object itEach, Class<?> type) {
        return Lib_Arguments.checkArgEach(this, itStream, argIdx, itEach, type);
    }

    public JMo_Enum argEnum(I_Object itStream) {
        JMo_Enum e = (JMo_Enum)Lib_Arguments.checkArgs(this, itStream, new Class[]{JMo_Enum.class})[0];
        if (!e.getOriginTypeName().equals(itStream.getTypeName())) {
            throw new CodeError(this, "Invalid enum", "Enum from current type is needed, but got enum from type: " + e.getOriginTypeName());
        }
        return e;
    }

    public I_Object[] args(I_Object itStream, Class<?> ... types) {
        return Lib_Arguments.checkArgs(this, itStream, types);
    }

    public I_Object argsEach(I_Object itStream, int offset, I_Object[] itEach, Class<?> type) {
        return Lib_Arguments.checkArgsEach(this, itStream, offset, itEach, type);
    }

    public I_Object[] argsExt(I_Object itStream, Class<?>[] ... types) {
        return Lib_Arguments.checkArgsExt(this, itStream, types);
    }

    public I_Object[] argsFlex(I_Object itStream, int arg_min, int arg_max) {
        return Lib_Arguments.checkArgsFlex(this, itStream, arg_min, arg_max);
    }

    public void argsNone() {
        if (this.call.getArgCount() > 0) {
            throw new CodeError(this, "Invalid number of arguments", "No arguments allowed");
        }
    }

    public I_Object argsOneAdvance(I_Object itStream, int argIdx, Class<? extends I_Object> type) {
        return Lib_Arguments.checkArgAdvance(this, itStream, argIdx, null, type, false);
    }

    public I_Object argsOneAdvanceExt(I_Object itStream, int argIdx, Class<?> ... types) {
        return Lib_Arguments.checkArgAdvanceExt(this, itStream, argIdx, null, types, false);
    }

    public I_Object[] argsVar(I_Object itStream, int arg_min, int varArgsOffset) {
        I_Object[] args = Lib_Arguments.checkArgsFlex(this, itStream, arg_min, null);
        if (args.length == varArgsOffset + 1 && args[varArgsOffset] instanceof A_MemLet) {
            A_MemLet vl = (A_MemLet)args[varArgsOffset];
            A_Sequence list = (A_Sequence)this.argType(vl.getMem().get(this), A_Sequence.class);
            I_Series<? extends I_Object> al = list.getInternalCollection();
            I_Object[] result = new I_Object[varArgsOffset + al.size()];
            Lib_Error.ifArgs(result.length, arg_min, null, this, itStream);
            if (varArgsOffset > 0) {
                System.arraycopy(args, 0, result, 0, varArgsOffset);
            }
            int i = 0;
            while (i < al.size()) {
                result[varArgsOffset + i] = (I_Object)al.get(i);
                ++i;
            }
            return result;
        }
        int i = 0;
        while (i < args.length) {
            args[i] = Lib_Convert.getValue(this, args[i]);
            ++i;
        }
        return args;
    }

    public I_Object argType(I_Object arg, Class<?> type) {
        return Lib_Arguments.checkArg(this, arg, type, null, null, false);
    }

    public I_Object argTypeExt(I_Object arg, Class<?> ... types) {
        return Lib_Arguments.checkArgExt(this, arg, types, null, null, false);
    }

    public <T extends I_Mem> T argTypeMem(I_Object arg, Class<T> type) {
        Lib_Arguments.checkArgMem(this, arg, type, null, null, false);
        return (T)((I_Mem)arg);
    }

    public void blockForbidden() {
        Lib_Arguments.checkBlockForbidden(this);
    }

    public void blockNecessary() {
        Lib_Arguments.checkBlockNecessary(this);
    }

    public CallRuntime copyBlockItem(Call call) {
        return new CallRuntime(this, this.instance, call, this.vce, NEW_VCE.KEEP_PARENT, this.funcOutside);
    }

    public CallRuntime copyCall(Call call, boolean newVarEnvLevel) {
        return new CallRuntime(this, this.instance, call, this.vce, newVarEnvLevel ? NEW_VCE.NEW_LEVEL : NEW_VCE.KEEP_PARENT, this.funcOutside);
    }

    public CallRuntime copyEach(String method) {
        Call call = new Call(this.getSurrBlock(), null, method, this.call.argCalls, this.getDebugInfo());
        return new CallRuntime(this, this.instance, call, this.vce, NEW_VCE.KEEP_PARENT, this.funcOutside);
    }

    public CallRuntime copyEventHandler(Call call) {
        VarConstEnv copy = this.vce;
        return new CallRuntime(this, this.instance, call, copy, NEW_VCE.KEEP_PARENT, this.funcOutside);
    }

    public CallRuntime copyFunction(CallRuntime outside) {
        return new CallRuntime(this, this.instance, this.call, this.instance.getMainEnv(), NEW_VCE.NEW_LEVEL, outside);
    }

    public CallRuntime copyFunctional(Call c, Call[] args, DebugInfo debug) {
        Block emptyBlock = new Block(null, null, null);
        Call callCopy = new Call(emptyBlock, c.object, c.method, args, debug);
        if (c.hasStream()) {
            callCopy.setStream(c.getStream());
        }
        Instance newInstance = new Instance(this, this.instance.getApp(), this.instance.getType(), null);
        newInstance.setAlreadyInit();
        return new CallRuntime(this, newInstance, callCopy, null, NEW_VCE.NEW_LEVEL, null);
    }

    public CallRuntime copyLoop(LoopHandle handle) {
        CallRuntime result = new CallRuntime(this, this.instance, this.call, this.vce, NEW_VCE.WRAP_PARENT, this.funcOutside);
        result.vce.loopSet(handle);
        return result;
    }

    public CallRuntime copyNull() {
        Call c = new Call(this, null);
        return new CallRuntime(this, this.instance, c, this.vce, NEW_VCE.KEEP_PARENT, this.funcOutside);
    }

    public CallRuntime copyPass() {
        return new CallRuntime(this, this.instance, this.call, this.vce, NEW_VCE.NEW_LEVEL, this.funcOutside);
    }

    public CallRuntime copyVCE(Instance newInstance, VarConstEnv base_vce, boolean varEnvNew) {
        return new CallRuntime(this, newInstance, this.call, base_vce, varEnvNew ? NEW_VCE.NEW_LEVEL : NEW_VCE.KEEP_PARENT, this.funcOutside);
    }

    public I_Object exec(I_Object streamIt, boolean isArgument) {
        return (I_Object)this.exec((I_Object)streamIt, null, (byte)-1, (boolean)isArgument).o1;
    }

    public I_Object execEachInit(Call call, I_Object streamIt, I_Object eachIt) {
        Err.ifNull(call, streamIt, eachIt);
        CallRuntime cpInit = new CallRuntime(this, this.instance, call, this.vce, NEW_VCE.KEEP_PARENT, this.funcOutside);
        Group2<I_Object, Call> g = cpInit.exec(streamIt, eachIt, (byte)0, false);
        if (g.o2 != null) {
            Err.invalid(g.o2);
        }
        return (I_Object)g.o1;
    }

    public I_Object execInit(Call call, I_Object streamIt) {
        Err.ifNull(call, streamIt);
        CallRuntime cpInit = new CallRuntime(this, this.instance, call, this.vce, NEW_VCE.KEEP_PARENT, this.funcOutside);
        return cpInit.exec(streamIt, false);
    }

    /*
     * Unable to fully structure code
     */
    public Group2<I_Object, Call> execObject(I_Object with, byte leftprio, boolean isArg) {
        this.curObject = with;
        if (with instanceof I_HasConstructor && (constructorResult = ((I_HasConstructor)with).constructor(this)) != null) {
            return new Group2<Return, Object>(constructorResult, null);
        }
        if (this.call.method == null) {
            if (this.call.hasBlock()) {
                if (isArg) {
                    throw new CodeError(this, "Invalid use of block and auto-block-function.", "Don't append a block to an argument");
                }
                this2 = Lib_Convert.getValue(this, with);
                if (this2 instanceof I_AutoBlockDo) {
                    if (with instanceof I_Mem) {
                        throw new CodeError(this, "Auto-Block can't be used after a variable or constant.", "Use it with a function, for example '.pass' or '.each': " + with);
                    }
                    this.getStrict().checkAutoBlock(this);
                    ab_result = ((I_AutoBlockDo)this2).autoBlockDo(this);
                    return new Group2<I_Object, Object>(ab_result, null);
                }
                throw new CodeError(this, "This type has no auto-block-function.", "Use it with a function, for example '.pass' or '.each': " + with.getTypeName());
            }
            if (!isArg && with instanceof I_Mem && !((I_Mem)with).isInitialized(this)) {
                vc = with instanceof Var != false ? "Variable" : "Constant";
                throw new CodeError(this, String.valueOf(vc) + " without value.", "This " + vc + " has no allocated value: " + with.toString());
            }
            return new Group2<I_Object, Object>(with, null);
        }
        next = this.call.getBlock() != null ? null : this.call.getStream();
        while (next != null && Lib_Prio.streamPrio(this.call, next) && this.call.getArgCount() == 1) {
            arg = this.args(with, new Class[]{I_Object.class})[0];
            streamPrioResult = this.execStream(arg, next, leftprio == -1 ? this.call.prio : leftprio);
            this.args_result = new I_Object[]{(I_Object)streamPrioResult.o1};
            next = (Call)streamPrioResult.o2;
        }
        callResult = with.call(this);
        if (callResult.is_Attachment_Exec) {
            return new Group2<I_Object, Object>(callResult.obj, null);
        }
        method = this.call.method;
        currentresult = callResult.obj;
        if (this.call.getBlock() != null) {
            if (this.getType().getFunctions().knows(method) && (f = this.getType().getFunctions().get(this, method)).hasControl()) {
                return new Group2<I_Object, Object>(currentresult, null);
            }
            block = this.getCallBlock();
            if (block != null) {
                throw new CodeError(this, "No block allowed for this function!", "Use for example: '.pass'");
            }
        }
        if (next != null) ** GOTO lbl45
        return new Group2<I_Object, Call>(currentresult, next);
lbl-1000:
        // 1 sources

        {
            if (leftprio > -1 && next.prio < this.call.prio) {
                return new Group2<I_Object, Call>(currentresult, next);
            }
            streamResult = this.execStream(currentresult, next, leftprio);
            next = (Call)streamResult.o2;
            currentresult = (I_Object)streamResult.o1;
lbl45:
            // 2 sources

            ** while (next != null)
        }
lbl46:
        // 1 sources

        return new Group2<I_Object, Call>(currentresult, next);
    }

    public Group2<I_Object, Call> execStream(I_Object streamIt, Call next, byte leftprio) {
        if (next == null) {
            return new Group2<I_Object, Object>(streamIt, null);
        }
        switch (next.method) {
            case "&&": {
                if (streamIt != Bool.FALSE) break;
                return new Group2<I_Object, Object>(streamIt, null);
            }
            case "||": {
                if (streamIt != Bool.TRUE) break;
                return new Group2<I_Object, Object>(streamIt, null);
            }
            case "!&&": {
                if (streamIt != Bool.FALSE) break;
                return new Group2<Bool, Object>(Bool.TRUE, null);
            }
            case "!||": {
                if (streamIt != Bool.TRUE) break;
                return new Group2<Bool, Object>(Bool.FALSE, null);
            }
        }
        CallRuntime crStream = new CallRuntime(this, this.instance, next, this.vce, NEW_VCE.KEEP_PARENT, this.funcOutside);
        return crStream.exec(streamIt, null, leftprio, false);
    }

    public App getApp() {
        return this.instance.getApp();
    }

    public I_Object getArgAdvance(CallRuntime cr, I_Object streamIt, int funcArgIdx, FunctionPar[] funcPars, boolean buffer, I_Object eachItObj) {
        if (buffer && this.args_result != null) {
            return this.args_result[funcArgIdx];
        }
        I_Object o = this.call.object != null ? this.call.object : streamIt;
        int diff = funcPars.length - this.call.argCalls.length;
        int fp = funcPars.length - 1;
        while (fp > funcArgIdx) {
            if (diff > 0 && funcPars[fp].defaultValue != null) {
                --diff;
            }
            --fp;
        }
        if (diff > 0 && funcPars[funcArgIdx].defaultValue != null) {
            return cr.execInit(funcPars[funcArgIdx].defaultValue, streamIt);
        }
        Call argCall = this.call.argCalls[funcArgIdx - diff];
        return eachItObj == null ? this.execInit(argCall, o) : (I_Object)this.copyCall((Call)argCall, (boolean)false).exec((I_Object)o, (I_Object)eachItObj, (byte)-1, (boolean)true).o1;
    }

    public I_Object getArgAdvance(I_Object streamIt, int argIdx) {
        if (this.args_result != null) {
            return this.args_result[argIdx];
        }
        I_Object o = this.call.object != null ? this.call.object : streamIt;
        return this.execInit(this.call.argCalls[argIdx], o);
    }

    public I_Object getArgEach(I_Object streamIt, int argIdx, I_Object eachItObj) {
        I_Object o = this.call.object != null ? this.call.object : streamIt;
        Lib_Error.ifArgs(argIdx + 1, 1, (Integer)this.call.argCalls.length, this, o);
        I_Object argTemp = Nil.NIL;
        Call ac = this.call.argCalls[argIdx];
        argTemp = (I_Object)this.copyCall((Call)ac, (boolean)false).exec((I_Object)o, (I_Object)eachItObj, (byte)-1, (boolean)true).o1;
        this.args_result = null;
        return argTemp;
    }

    public I_Object[] getArgs(I_Object streamIt) {
        return this.getArgs(streamIt, true);
    }

    public I_Object[] getArgs(I_Object streamIt, boolean buffer) {
        if (buffer && this.args_result != null) {
            return this.args_result;
        }
        int len = this.call.argCalls == null ? 0 : this.call.argCalls.length;
        I_Object[] argsTemp = new I_Object[len];
        if (len > 0) {
            I_Object o = this.call.object == null || this.call.object instanceof I_ObjectReplace ? streamIt : this.call.object;
            int pp = 0;
            while (pp < len) {
                Call arg = this.call.argCalls[pp];
                CallRuntime cpArg = new CallRuntime(this, this.instance, arg, this.vce, NEW_VCE.KEEP_PARENT, this.funcOutside);
                argsTemp[pp] = cpArg.exec(o, true);
                ++pp;
            }
        }
        this.args_result = argsTemp;
        return this.args_result;
    }

    public I_Object getArgsEach(I_Object streamIt, int offset, I_Object[] eachIt) {
        if (this.args_result != null) {
            return this.args_result[0];
        }
        Err.ifTooSmall(1.0, eachIt.length);
        I_Object eachItObj = eachIt.length == 1 ? eachIt[0] : new JMo_List(eachIt);
        int len = this.call.argCalls == null ? 0 : this.call.argCalls.length;
        I_Object o = this.call.object != null ? this.call.object : streamIt;
        Lib_Error.ifArgs(len, offset + 1, (Integer)(offset + 2), this, o);
        int fLen = len - offset;
        Err.ifOutOfBounds(1, 2, fLen);
        I_Object argTemp = Nil.NIL;
        if (fLen == 2) {
            I_Object arg1 = this.call.argCalls[offset].object;
            if (!(arg1 instanceof VarLet)) {
                throw new CodeError(this, "Invalid argument!", "Argument " + (offset + 1) + " isn't a VarLet!");
            }
            VarLet vl = (VarLet)arg1;
            vl.getMem().let(this, this, eachItObj);
            Call pc = this.call.argCalls[offset + 1];
            argTemp = (I_Object)this.copyCall((Call)pc, (boolean)false).exec((I_Object)o, (I_Object)eachItObj, (byte)-1, (boolean)true).o1;
        } else {
            Call pc = this.call.argCalls[offset];
            if (pc.object instanceof VarLet) {
                throw new CodeError(this, "Invalid use of VarLet!", "The test is missing, which belongs to the VarLet.");
            }
            if (pc.object instanceof FuncLet) {
                FuncLet fl = (FuncLet)pc.object;
                Call[] argCalls = new Call[eachIt.length];
                int i = 0;
                while (i < eachIt.length) {
                    argCalls[i] = new Call(this, eachIt[i]);
                    ++i;
                }
                Call c = new Call(this.getSurrBlock(), null, null, argCalls, this.getDebugInfo());
                CallRuntime cpFL = this.copyCall(c, true);
                argTemp = fl.exec(cpFL);
            } else {
                argTemp = (I_Object)this.copyCall((Call)pc, (boolean)false).exec((I_Object)o, (I_Object)eachItObj, (byte)-1, (boolean)true).o1;
            }
        }
        argTemp = Lib_Convert.getValue(this, argTemp);
        if (argTemp instanceof FuncLet) {
            argTemp = ((FuncLet)argTemp).eachExec(this, eachItObj);
        }
        this.args_result = new I_Object[]{argTemp};
        return argTemp;
    }

    public Block getCallBlock() {
        return this.call.getBlock();
    }

    public I_Object getCurrentObject() {
        return this.curObject;
    }

    @Override
    public DebugInfo getDebugInfo() {
        return this.call.debugInfo;
    }

    public Call getStream() {
        return this.call.getStream();
    }

    public StrictManager getStrict() {
        return this.instance.getApp().strict;
    }

    public Block getSurrBlock() {
        return this.call.surrounding;
    }

    public Type getType() {
        return this.instance.getType();
    }

    public boolean hasArguments() {
        return this.call.getArgCount() > 0;
    }

    public boolean hasBlock() {
        return this.call.hasBlock();
    }

    public boolean hasStream() {
        return this.call.hasStream();
    }

    public I_Object instanceArgType(int argIdx, I_Object arg, Class<?> type) {
        return Lib_Arguments.checkArg(this, arg, type, argIdx, null, true);
    }

    public I_Object instanceArgTypeExt(int argIdx, I_Object arg, Class<?> ... types) {
        return Lib_Arguments.checkArgExt(this, arg, types, argIdx, null, true);
    }

    public String toString() {
        String sc = this.call == null ? "null" : this.call.toString();
        return sc + " | " + this.instance.toString() + " | " + this.vce.toString();
    }

    public void warning(String message, String detail) {
        RuntimeWarning t = new RuntimeWarning(this, message, detail);
        this.getApp().warning(this, t);
    }

    private Group2<I_Object, Call> exec(I_Object streamIt, I_Object eachIt, byte leftprio, boolean isArgument) {
        Err.ifNull((Object)this.call);
        if (this.getApp().toBeTerminated()) {
            return new Group2<Nil, Object>(Nil.NIL, null);
        }
        try {
            I_Object with;
            Group2<I_Object, Call> res = null;
            I_Object objNew = this.call.object;
            I_Object i_Object = with = objNew != null ? objNew : streamIt;
            if (this.call.method == null && with instanceof A_Atomic && !this.call.hasBlock()) {
                if (this.call.hasStream()) {
                    throw Err.invalid(this.call);
                }
                return new Group2<I_Object, Object>(with, null);
            }
            if (with instanceof I_MagicReplace) {
                with = Lib_MagicVar.replace(with, this, streamIt, eachIt);
            }
            if (with == null) {
                if (this.call.object == null) {
                    throw Err.invalid("Call without Object!", this.call.toString(this, STYPE.IDENT), this.getDebugInfo());
                }
                throw new CodeError(this, "Missing Object, nothing to work with", "Invalid use of MagicConst: " + this.call.object.toString(this, STYPE.IDENT));
            }
            if (with instanceof NonAtomic) {
                with = ((NonAtomic)with).create(this);
            }
            with.initOnce(this);
            boolean multicall = this.iHasMulticall(this.call.argCalls);
            if (!multicall) {
                res = this.execObject(with, leftprio, isArgument);
            } else {
                Call[] args = this.call.argCalls;
                int aLen = args.length;
                I_Object o = this.call.object != null ? this.call.object : with;
                I_Object[] argsResult = new I_Object[aLen];
                int pp = 0;
                while (pp < args.length) {
                    Call arg = args[pp];
                    if (arg.object instanceof MultiCall) {
                        ((MultiCall)arg.object).setStream(o);
                    }
                    CallRuntime cpArg = new CallRuntime(this, this.instance, arg, this.vce, NEW_VCE.KEEP_PARENT, this.funcOutside);
                    argsResult[pp] = cpArg.exec(o, isArgument);
                    ++pp;
                }
                res = new Group2<I_Object, Object>(this.iExecMultiCall(with, 0, argsResult), null);
            }
            return res;
        }
        catch (ErrorBase t) {
            throw t;
        }
        catch (Err_Runtime t) {
            if (this.instance.getApp().isDebug()) {
                MOut.error(t);
            }
            String ste = this.stackTraceElementToString(t.getStackTrace()[1]);
            throw new RuntimeError(this, String.valueOf(t.getMessage()) + ste, ConvertSequence.toString(", ", t.getDetails()));
        }
        catch (Throwable t) {
            if (this.instance.getApp().isDebug()) {
                MOut.error(t);
            }
            String msg = null;
            try {
                StackTraceElement[] stea = t.getStackTrace();
                String ste0 = this.stackTraceElementToString(stea[0]);
                String ste1 = this.stackTraceElementToString(stea[1]);
                msg = String.valueOf(t.getClass().getSimpleName()) + " " + ste0 + ", " + ste1;
            }
            catch (Throwable tx) {
                msg = t.getClass().getSimpleName();
            }
            throw new JayMoError(t, this, msg, t.getMessage());
        }
    }

    private I_Object iExecMultiCall(I_Object with, int aPos, I_Object[] current) {
        int len = current.length;
        if (aPos == len) {
            this.args_result = current;
            Group2<I_Object, Call> gr = this.execObject(with, (byte)-1, true);
            return (I_Object)gr.o1;
        }
        I_Object[] current2 = new I_Object[len];
        System.arraycopy(current, 0, current2, 0, len);
        if (current[aPos] instanceof MultiCall) {
            I_Object result = with;
            MultiCall curMC = (MultiCall)current[aPos];
            curMC.exec(this, this.getSurrBlock(), with);
            curMC.resetPointer();
            while (curMC.hasNext()) {
                current2[aPos] = curMC.getNext();
                result = this.iExecMultiCall(with, aPos + 1, current2);
            }
            return result;
        }
        return this.iExecMultiCall(with, aPos + 1, current2);
    }

    private boolean iHasMulticall(Call[] calls) {
        if (calls != null) {
            Call[] callArray = calls;
            int n = calls.length;
            int n2 = 0;
            while (n2 < n) {
                Call c = callArray[n2];
                if (c.object instanceof MultiCall) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private String stackTraceElementToString(StackTraceElement st) {
        String ste;
        String string = ste = st.getFileName() == null ? "" : String.valueOf(st.getFileName()) + ":" + st.getLineNumber();
        if (ste.length() > 0) {
            ste = String.valueOf('(') + ste + ')';
        }
        return ste;
    }
}

