/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.runtime;

import de.mn77.base.data.convert.ConvertSequence;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import java.util.HashMap;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.JayMoError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ObjectManager;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.passthrough.Const;
import org.jaymo_lang.object.passthrough.I_Mem;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.object.sys.JMo_Java;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Java;
import org.jaymo_lang.util.Lib_Type;

public abstract class A_MemEnv {
    private final A_MemEnv parent;
    private HashMap<String, Group2<String, I_Object>> map = null;

    public A_MemEnv(A_MemEnv parent) {
        this.parent = parent;
    }

    public final void register(CallRuntime cr, I_Mem mem) {
        if (this.knows(mem, mem.getName())) {
            return;
        }
        this.map.put(mem.getName(), new Group2<Object, Object>(null, null));
    }

    public final void remove(Var v) {
        if (this.map == null) {
            return;
        }
        this.map.remove(v.getName());
    }

    public final void setType(CallRuntime cr, I_Mem vc, String type) {
        if (this.knows(vc, vc.getName())) {
            return;
        }
        if (!ObjectManager.isTypeKnown(cr, type)) {
            throw new CodeError(cr, "Unknown type name", "Got: '" + type + "'");
        }
        this.iInit();
        Group2 g = this.map.getOrDefault(vc, null);
        if (g != null) {
            Err.invalid("Type already set!");
        }
        this.map.put(vc.getName(), new Group2<String, Object>(type, null));
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        sb.append(this.map == null ? "0" : "" + this.map.size());
        sb.append(">(");
        sb.append(this.map == null ? "" : ConvertSequence.toString(",", this.map.keySet()));
        sb.append(')');
        if (this.parent != null) {
            sb.append(" --> Parent: " + this.parent);
        }
        return sb.toString();
    }

    protected I_Object get(CallRuntime cr, I_Mem vc, String name) {
        this.iInit();
        if (this.map.containsKey(name)) {
            return (I_Object)this.map.get((Object)name).o2;
        }
        if (this.parent != null && this.parent.knows(vc, name)) {
            return this.parent.get(cr, vc, name);
        }
        throw Lib_Error.memNotInitialized(cr, vc);
    }

    protected boolean isInitialized(I_Mem vc, String name) {
        this.iInit();
        Group2 g = this.map.getOrDefault(name, null);
        if (g == null) {
            return this.parent != null ? this.parent.isInitialized(vc, name) : false;
        }
        return g.o2 != null;
    }

    protected boolean knows(I_Mem vc, String name) {
        this.iInit();
        return this.map.containsKey(name) ? true : (this.parent != null ? this.parent.knows(vc, name) : false);
    }

    protected void set(CallRuntime cr, I_Mem vc, I_Object obj, boolean nilable, boolean convert, String vcName) {
        boolean isNil;
        Group2<String, I_Object> mem;
        this.iInit();
        if (obj == null) {
            throw new JayMoError(cr, "No Object to set", vcName);
        }
        if (this.parent != null && !this.map.containsKey(vcName) && this.parent.knows(vc, vcName)) {
            this.parent.set(cr, vc, obj, nilable, convert, vcName);
            return;
        }
        String objType = Lib_Type.getName(obj.getClass(), obj);
        String safedType = null;
        boolean isKnown = this.map.containsKey(vcName);
        if (isKnown) {
            safedType = (String)this.map.get((Object)vcName).o1;
        }
        obj = Lib_Convert.getValue(cr, obj);
        if (vc instanceof Const && (mem = this.map.get(vcName)) != null && mem.o2 != null) {
            throw new RuntimeError(cr, "Constant value is already set and cannot be changed.", String.valueOf(vcName) + "=" + obj.toString());
        }
        boolean bl = isNil = obj == Nil.NIL;
        if (!nilable && isNil) {
            throw new RuntimeError(cr, "Invalid value for " + vc.getMemTypeString(), "'" + vcName + " = " + obj.toString() + "' is not valid, maybe try '" + vcName + "? = " + Nil.NIL.toString() + "'");
        }
        if (obj != null) {
            if (safedType == null) {
                if (!isNil) {
                    safedType = objType;
                }
            } else {
                if (convert) {
                    obj = Lib_Convert.memConvert(cr, safedType, objType, obj);
                    objType = Lib_Type.getName(obj);
                }
                if (!isNil) {
                    obj = Lib_Type.typeCheck(cr, obj, objType, safedType, String.valueOf(vc.getMemTypeString()) + ": " + vcName);
                }
            }
        }
        if (obj instanceof JMo_Java && Lib_Java.isSimpleTypeName(safedType)) {
            safedType = ((JMo_Java)obj).getFullTypeName();
        }
        this.map.put(vcName, new Group2<String, I_Object>(safedType, obj));
    }

    private void iInit() {
        if (this.map == null) {
            this.map = new HashMap();
        }
    }
}

