/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.passthrough.Count;
import org.jaymo_lang.object.passthrough.Group;
import org.jaymo_lang.object.pseudo.NonAtomic;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Set;
import org.jaymo_lang.parser.Parser_Call;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;
import org.jaymo_lang.util.Lib_Parser;

public class ParseObj_ShortCuts
implements I_ParseObject {
    private boolean group_ok = true;
    private boolean list_ok = true;
    private boolean count_ok = true;

    @Override
    public boolean hits(char c0, Block current, String s) {
        return c0 == '(' || c0 == '[' || c0 == '{';
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        switch (s.charAt(0)) {
            case '(': {
                return this.parseGroup(parser, current, s);
            }
            case '[': {
                return this.parseList(parser, current, s);
            }
            case '{': {
                return this.parseCount(parser, current, s);
            }
        }
        throw Err.impossible(s);
    }

    public void strict(boolean group_ok, boolean list_ok, boolean count_ok) {
        this.group_ok = group_ok;
        this.list_ok = list_ok;
        this.count_ok = count_ok;
    }

    private Group2<I_Object, String> parseCount(Parser_Script parser, Block current, String s) {
        if (!this.count_ok) {
            throw new CodeError("Strict: Shortcut of For is forbidden. Use For()!", s, parser);
        }
        String part = Lib_Parser.group('{', '}', s, parser.getDebugInfo());
        String rem = s.substring(1 + part.length() + 1);
        Call[] args = Parser_Call.parseArguments(parser, current, part);
        if (args.length == 0) {
            throw new CodeError("Missing argument", s, parser);
        }
        if (args.length > 3) {
            throw new CodeError("Too many arguments", s, parser);
        }
        Call from = args[0];
        Call to = args.length >= 2 ? args[1] : null;
        Call step = args.length == 3 ? args[2] : null;
        return new Group2<I_Object, String>(new NonAtomic(Count.class, new Call[]{from, to, step}), ".each()" + rem);
    }

    private Group2<I_Object, String> parseGroup(Parser_Script parser, Block current, String s) {
        if (!this.group_ok) {
            throw new CodeError("Strict: Shortcut of group is forbidden. Use Group()!", s, parser);
        }
        String group = Lib_Parser.group('(', ')', s, parser.getDebugInfo());
        String rem = s.substring(group.length() + 2);
        if ((group = group.trim()).length() == 0) {
            throw new CodeError("Missing argument for Group", s, parser);
        }
        Call arg = Parser_Call.parseCall(parser, current, group, true);
        return new Group2<I_Object, String>(new NonAtomic(Group.class, new Call[]{arg}), ".get()" + rem);
    }

    private Group2<I_Object, String> parseList(Parser_Script parser, Block current, String s) {
        if (!this.list_ok) {
            throw new CodeError("Strict: Shortcut of list is forbidden. Use List()!", s, parser);
        }
        String list = Lib_Parser.group('[', ']', s, parser.getDebugInfo());
        String rem = s.substring(list.length() + 2);
        Call[] args = Parser_Call.parseArguments(parser, current, list);
        Class cl = JMo_List.class;
        if (rem.length() > 0) {
            char c = rem.charAt(0);
            if (c == 'l') {
                rem = rem.substring(1);
            } else if (c == 's') {
                rem = rem.substring(1);
                cl = JMo_Set.class;
            } else if (c == 'b') {
                StringBuilder sb = new StringBuilder(rem.substring(1));
                sb.append(".content(");
                sb.append(list);
                sb.append(')');
                rem = sb.toString();
                cl = JMo_ByteArray.class;
                args = new Call[]{new Call(current, new Int(args.length), parser.getDebugInfo())};
            }
        }
        return new Group2<I_Object, String>(new NonAtomic(cl, args), rem);
    }
}

