/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.obj;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.passthrough.Const;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.object.pseudo.ConstLet;
import org.jaymo_lang.object.pseudo.FuncLet;
import org.jaymo_lang.object.pseudo.VarLet;
import org.jaymo_lang.parser.Parser_Call;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;
import org.jaymo_lang.util.Lib_Comply;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Parser;

public class ParseObj_MemLet
implements I_ParseObject {
    private static final String matchingConst = "ABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789";
    private static final String matchingVar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789?";

    @Override
    public boolean hits(char c0, Block current, String s) {
        return c0 == ':';
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        if (s.length() == 1) {
            throw new CodeError("Invalid MemLet definition", "Lonely ':' found, missing Const,Var,Brackets", parser);
        }
        char c1 = s.charAt(1);
        if (c1 >= 'A' && c1 <= 'Z') {
            return this.parseConstLet(parser, current, s);
        }
        if (c1 >= 'a' && c1 <= 'z') {
            return this.parseVarLet(parser, current, s);
        }
        if (c1 == '{') {
            return this.parseFuncLet(parser, current, s);
        }
        throw new CodeError("Invalid MemLet definition", "Got: " + s, parser);
    }

    public Group2<I_Object, String> parseConstLet(Parser_Script parser, Block current, String s) {
        Err.ifNull((Object)current);
        String con = FilterString.matchingLeft(matchingConst, s.substring(1));
        if (!Lib_Comply.checkConstName(con)) {
            throw new CodeError("Invalid constant name", "This constant name can't be used: " + con, parser);
        }
        String rem = s.substring(con.length() + 1);
        Const co = (Const)current.getConstManager().use_ParseTime(parser, con, false);
        ConstLet vl = new ConstLet(co);
        return new Group2<I_Object, String>(vl, rem);
    }

    public Group2<I_Object, String> parseFuncLet(Parser_Script parser, Block current, String s) {
        Err.ifNull((Object)current);
        String func = Lib_Parser.group('{', '}', s, parser.getDebugInfo());
        String rem = s.substring(3 + func.length());
        Call[] ca = Parser_Call.parseArguments(parser, current, func);
        Lib_Error.ifArgs(ca.length, 1, (Integer)1, "FuncLet", parser.getDebugInfo());
        FuncLet fl = new FuncLet(ca[0]);
        return new Group2<I_Object, String>(fl, rem);
    }

    public Group2<I_Object, String> parseVarLet(Parser_Script parser, Block current, String s) {
        Err.ifNull((Object)current);
        String var = FilterString.matchingLeft(matchingVar, s.substring(1));
        if (!Lib_Comply.checkVarName(var)) {
            throw new CodeError("Invalid variable name", "This variable name can't be used: " + var, parser);
        }
        String rem = s.substring(var.length() + 1);
        Var vo = (Var)current.getVarManager().use_ParseTime(parser, var, false);
        VarLet vl = new VarLet(vo);
        return new Group2<I_Object, String>(vl, rem);
    }
}

