/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.filesys;

import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.Lib_FileSys;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.filesys.JMo_Path;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Dir
extends JMo_Path
implements I_Object {
    public JMo_Dir() {
        super(new File(Sys.getCurrentDir()));
    }

    public JMo_Dir(Call arg) {
        super(arg);
    }

    public JMo_Dir(File f) {
        super(f);
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        File f = this.getInternalFile();
        if (f == null) {
            return "Dir";
        }
        switch (type) {
            case REGULAR: {
                return f.getAbsolutePath().toString();
            }
            case NESTED: 
            case IDENT: {
                return "Dir";
            }
        }
        return "Dir(\"" + f.getAbsolutePath().toString() + '\"' + ")";
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        ObjectCallResult result = super.call2(cr, method);
        if (result != null) {
            return result;
        }
        switch (method) {
            case "+": 
            case "add": {
                return A_Object.stdResult(this.mAdd(cr));
            }
            case "list": {
                return A_Object.stdResult(this.mList(cr, true, true));
            }
            case "files": {
                return A_Object.stdResult(this.mList(cr, true, false));
            }
            case "dirs": {
                return A_Object.stdResult(this.mList(cr, false, true));
            }
            case "search": 
            case "listRecursive": {
                return A_Object.stdResult(this.mListRecursive(cr, true, true));
            }
            case "searchFiles": 
            case "filesRecursive": {
                return A_Object.stdResult(this.mListRecursive(cr, true, false));
            }
            case "searchDirs": 
            case "dirsRecursive": {
                return A_Object.stdResult(this.mListRecursive(cr, false, true));
            }
            case "createDir": {
                return A_Object.stdResult(this.mMakeDir(cr, false));
            }
            case "makeDir": {
                return A_Object.stdResult(this.mMakeDir(cr, true));
            }
            case "deleteDir": {
                return A_Object.stdResult(this.mDeleteSub(cr, true));
            }
            case "deleteFile": {
                return A_Object.stdResult(this.mDeleteSub(cr, false));
            }
            case "create": {
                return A_Object.stdResult(this.mCreate(cr, false));
            }
            case "make": {
                return A_Object.stdResult(this.mCreate(cr, true));
            }
            case "rename": {
                return A_Object.stdResult(this.mRename(cr));
            }
            case "move": {
                return A_Object.stdResult(this.mMove(cr));
            }
            case "delete": {
                return A_Object.stdResult(this.mDelete(cr));
            }
        }
        return null;
    }

    private JMo_List iDirList(CallRuntime cr, SimpleList<I_Object> al, File base, boolean files, boolean dirs, String filter, boolean recursive) {
        block7: {
            File[] dirContent;
            block6: {
                if (filter != null) break block6;
                File[] dirContent2 = base.listFiles();
                if (dirContent2 == null) break block7;
                File[] fileArray = dirContent2;
                int n = dirContent2.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    this.iDirListAdd(al, files, dirs, f);
                    if (recursive && f.isDirectory()) {
                        this.iDirList(cr, al, f, files, dirs, filter, recursive);
                    }
                    ++n2;
                }
                break block7;
            }
            DirectoryStream<Path> content = this.searchFiles(cr, base, filter);
            for (Path d : content) {
                this.iDirListAdd(al, files, dirs, d.toFile());
            }
            if (recursive && (dirContent = base.listFiles()) != null) {
                File[] fileArray = dirContent;
                int n = dirContent.length;
                int n3 = 0;
                while (n3 < n) {
                    File f = fileArray[n3];
                    if (f.isDirectory()) {
                        this.iDirList(cr, al, f, files, dirs, filter, recursive);
                    }
                    ++n3;
                }
            }
        }
        return new JMo_List(al);
    }

    private void iDirListAdd(SimpleList<I_Object> al, boolean files, boolean dirs, File f) {
        boolean isf = f.isFile();
        if (isf && files) {
            al.add(new JMo_File(f));
        }
        if (!isf && dirs) {
            al.add(new JMo_Dir(f));
        }
    }

    private JMo_Dir mAdd(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String argPath = Lib_Convert.getStringValue(cr, arg);
        String currentAbsolutePath = this.getInternalFile().getAbsolutePath();
        File f = new File(String.valueOf(currentAbsolutePath) + argPath);
        return new JMo_Dir(f);
    }

    private JMo_Dir mCreate(CallRuntime cr, boolean lazy) {
        File f;
        cr.argsNone();
        String path = this.getInternalFile().getAbsolutePath();
        if (!lazy && (f = new File(path)).exists()) {
            throw new ExternalError(cr, "Can't create Directory", "Directory already exists: " + path);
        }
        try {
            Lib_FileSys.createPathStructure(path);
        }
        catch (Err_FileSys e) {
            throw new ExternalError(cr, "Can't create Directory", path);
        }
        return this;
    }

    private Bool mDelete(CallRuntime cr) {
        cr.argsNone();
        File f = this.getInternalFile();
        if (f.exists()) {
            boolean deleted = f.delete();
            return Bool.getObject(deleted);
        }
        return Bool.TRUE;
    }

    private Bool mDeleteSub(CallRuntime cr, boolean dir) {
        String sep;
        Str arg = (Str)cr.args(this, Str.class)[0];
        String dirName = arg.getValue();
        if (dirName.contains(sep = Sys.getSeperatorDir())) {
            throw new ExternalError(cr, "Invalid directory name", "Name contains directory separator: " + sep);
        }
        File f = new File(String.valueOf(this.getInternalFile().getAbsolutePath()) + sep + dirName);
        if (dir && f.isFile()) {
            throw new ExternalError(cr, "Delete error", "The given name is not a directory: " + f.getAbsolutePath());
        }
        if (!dir && f.isDirectory()) {
            throw new ExternalError(cr, "Delete error", "The given name is not a file: " + f.getAbsolutePath());
        }
        if (f.exists()) {
            boolean deleted = f.delete();
            return Bool.getObject(deleted);
        }
        return Bool.TRUE;
    }

    private JMo_List mList(CallRuntime cr, boolean files, boolean dirs) {
        I_Object[] args = cr.argsVar(this, 0, 1);
        String filter = args.length == 0 ? null : ((Str)cr.argType(args[0], Str.class)).getValue();
        SimpleList<I_Object> al = new SimpleList<I_Object>();
        return this.iDirList(cr, al, this.getInternalFile(), files, dirs, filter, false);
    }

    private JMo_List mListRecursive(CallRuntime cr, boolean files, boolean dirs) {
        I_Object[] args = cr.argsVar(this, 0, 1);
        String filter = args.length == 0 ? null : ((Str)cr.argType(args[0], Str.class)).getValue();
        SimpleList<I_Object> al = new SimpleList<I_Object>();
        return this.iDirList(cr, al, this.getInternalFile(), files, dirs, filter, true);
    }

    private JMo_Dir mMakeDir(CallRuntime cr, boolean lazy) {
        File f;
        Str arg = (Str)cr.args(this, Str.class)[0];
        String newDirName = arg.getValue();
        if (newDirName.contains(Sys.getSeperatorDir())) {
            throw new ExternalError(cr, "Can't create Directory", "No target-path allowed");
        }
        String newDir = this.getInternalFile() + Sys.getSeperatorDir() + newDirName;
        if (!lazy && (f = new File(newDir)).exists()) {
            throw new ExternalError(cr, "Can't create Directory", "Directory already exists: " + newDir);
        }
        try {
            Lib_FileSys.createPathStructure(newDir);
        }
        catch (Err_FileSys e) {
            throw new ExternalError(cr, "Can't create Directory", newDirName);
        }
        return new JMo_Dir(new File(newDir));
    }

    private JMo_Path mMove(CallRuntime cr) {
        Str arg = (Str)cr.args(this, Str.class)[0];
        String newPath = Lib_Convert.getStringValue(cr, arg);
        File target = new File(newPath);
        try {
            Files.move(this.getInternalFile().toPath(), target.toPath(), new CopyOption[0]);
            this.changeFile(target);
            return this;
        }
        catch (IOException e) {
            throw new ExternalError(cr, "Directory-Move-Error", String.valueOf(this.getInternalFile().getAbsolutePath()) + " --> " + target.getAbsolutePath());
        }
    }

    private I_Object mRename(CallRuntime cr) {
        Str arg = (Str)cr.args(this, Str.class)[0];
        String newName = Lib_Convert.getStringValue(cr, arg);
        if (newName.contains(Sys.getSeperatorDir())) {
            throw new ExternalError(cr, "Directory-Rename failed", "No target-path allowed");
        }
        newName = String.valueOf(this.getInternalFile().getParent()) + Sys.getSeperatorDir() + newName;
        File newFile = new File(newName);
        boolean done = this.getInternalFile().renameTo(newFile);
        if (!done) {
            throw new ExternalError(cr, "Directory-Rename failed", String.valueOf(this.getInternalFile().getAbsolutePath()) + " --> " + newFile.getAbsolutePath());
        }
        this.changeFile(newFile);
        return this;
    }

    private DirectoryStream<Path> searchFiles(CallRuntime cr, File base, String filter) {
        try {
            return Lib_FileSys.searchFiles(base, filter);
        }
        catch (IOException e) {
            throw new ExternalError(cr, "In/Out-Error", e.getMessage());
        }
    }
}

