/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.error.Err;
import java.math.BigDecimal;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_DecNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_BigNumber;
import org.jaymo_lang.object.atom.I_Decimal;
import org.jaymo_lang.object.atom.NOP0;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomicMath;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Double
extends A_DecNumber
implements I_Decimal,
I_Atomic {
    private final double value;

    public JMo_Double(double val) {
        this.value = val;
    }

    @Override
    public ATOMIC getEnum() {
        return ATOMIC.DOUBLE;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        if (Double.isNaN(this.value)) {
            return "not_a_number";
        }
        if (this.value == Double.POSITIVE_INFINITY) {
            return "+infinity";
        }
        if (this.value == Double.NEGATIVE_INFINITY) {
            return "-infinity";
        }
        if (type == STYPE.DESCRIBE) {
            String s = "" + this.value;
            if (s.indexOf(69) < 0) {
                return String.valueOf(s) + "d";
            }
            String sVal = new BigDecimal(this.value).toPlainString();
            StringBuilder sb = new StringBuilder();
            sb.append(sVal);
            if (sVal.indexOf(46) == -1) {
                sb.append(".0");
            }
            sb.append('d');
            return sb.toString();
        }
        return type == STYPE.IDENT ? String.valueOf(this.value) + "d" : "" + this.value;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    protected A_Atomic getMaxValue(CallRuntime cr) {
        return new JMo_Double(Double.POSITIVE_INFINITY);
    }

    @Override
    protected A_Atomic getMinValue(CallRuntime cr) {
        return new JMo_Double(Double.NEGATIVE_INFINITY);
    }

    @Override
    protected A_Number numberCalc0(CallRuntime cr, NOP0 op) {
        switch (op) {
            case NEG: {
                return new JMo_Double(-this.value);
            }
            case ABS: {
                return new JMo_Double(Math.abs(this.value));
            }
            case EXP: {
                return new JMo_Double(Math.exp(this.value));
            }
            case INC: {
                return new JMo_Double(this.value + 1.0);
            }
            case DEC: {
                return new JMo_Double(this.value - 1.0);
            }
            case POW: {
                return new JMo_Double(this.value * this.value);
            }
            case ROOT: {
                return new JMo_Double(Math.sqrt(this.value));
            }
            case LOG10: {
                return new JMo_Double(Math.log10(this.value));
            }
            case LOGN: {
                return new JMo_Double(Math.log(this.value));
            }
        }
        throw Err.impossible(new Object[]{op});
    }

    @Override
    protected A_Number numberCalc1(CallRuntime cr, NOP1 op, A_Number arg) {
        if (arg instanceof I_BigNumber) {
            return Lib_AtomicMath.calcBigDec(cr, op, BigDecimal.valueOf(this.value), Lib_Convert.getBigDecimalValue(cr, arg));
        }
        return Lib_AtomicMath.calcDouble(cr, op, this.value, Lib_Convert.getDoubleValue(cr, arg));
    }

    @Override
    protected A_Number numberCalcSame(CallRuntime cr, A_Number num, boolean inc) {
        double arg = Lib_Convert.getDoubleValue(cr, num);
        return new JMo_Double(inc ? this.value + arg : this.value - arg);
    }
}

