/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object;

import de.mn77.base.data.util.Lib_Random;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.JMo_Range;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.atom.JMo_Double;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_Random
extends A_Object
implements I_Object {
    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "newInt": 
            case "int": {
                return A_Object.stdResult(this.mGetInt(cr));
            }
            case "newDec": 
            case "dec": {
                return A_Object.stdResult(this.mGetDec(cr));
            }
            case "double": 
            case "newDouble": {
                return A_Object.stdResult(this.mGetDouble(cr));
            }
            case "bool": 
            case "newBool": {
                return A_Object.stdResult(this.mGetBool(cr));
            }
            case "char": 
            case "newChar": {
                return A_Object.stdResult(this.mGetChar(cr));
            }
            case "newStr": 
            case "str": {
                return A_Object.stdResult(this.mGetStr(cr));
            }
        }
        return null;
    }

    private String iParsToOptions(CallRuntime cr, I_Object[] args, int offset) {
        String options = "";
        int i = offset;
        while (i < args.length) {
            I_Object arg = args[i];
            I_Object p = cr.argType(arg, I_Object.class);
            if (p instanceof Str) {
                options = String.valueOf(options) + ((Str)p).getValue();
            } else if (p instanceof Char) {
                options = String.valueOf(options) + ((Char)p).getValue();
            } else if (p instanceof JMo_Range) {
                options = String.valueOf(options) + ((JMo_Range)p).computeString(cr);
            } else if (p instanceof I_Integer) {
                int val = Lib_Convert.getIntValue(cr, p);
                Lib_Error.ifNotBetween(cr, 0, 9, val, "Integer-Number");
                options = String.valueOf(options) + val;
            } else {
                throw new RuntimeError(cr, "Invalid arguments", "Only <Str>, <Char>, <Range> and Integer-Values(0-9) are allowed. Got: " + arg);
            }
            ++i;
        }
        if (options.length() == 0) {
            throw new RuntimeError(cr, "Invalid arguments", "Missing argument(s) with available characters!");
        }
        return options;
    }

    private Bool mGetBool(CallRuntime cr) {
        cr.argsNone();
        boolean r = Lib_Random.getBool();
        return Bool.getObject(r);
    }

    private Char mGetChar(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 0, 0);
        String options = args.length > 0 ? this.iParsToOptions(cr, args, 0) : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        int r = Lib_Random.getInt(0, options.length() - 1);
        return new Char(options.charAt(r));
    }

    private JMo_Dec mGetDec(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 2);
        int len = args.length;
        if (len == 0) {
            double r = Lib_Random.getDouble(Double.MIN_VALUE, Double.MAX_VALUE);
            return JMo_Dec.valueOf(cr, r);
        }
        if (len == 1) {
            I_Object p1 = cr.argType(args[0], A_Number.class);
            double d1 = Lib_Convert.getDoubleValue(cr, p1);
            double r = Lib_Random.getDouble(1.0, d1);
            return JMo_Dec.valueOf(cr, r);
        }
        I_Object p1 = cr.argType(args[0], A_Number.class);
        I_Object p2 = cr.argType(args[1], A_Number.class);
        double d1 = Lib_Convert.getDoubleValue(cr, p1);
        double d2 = Lib_Convert.getDoubleValue(cr, p2);
        double r = Lib_Random.getDouble(d1, d2);
        return JMo_Dec.valueOf(cr, r);
    }

    private JMo_Double mGetDouble(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 2);
        int len = args.length;
        if (len == 0) {
            double r = Lib_Random.getDouble(Double.MIN_VALUE, Double.MAX_VALUE);
            return new JMo_Double(r);
        }
        if (len == 1) {
            I_Object p1 = cr.argType(args[0], A_Number.class);
            double d1 = Lib_Convert.getDoubleValue(cr, p1);
            double r = Lib_Random.getDouble(1.0, d1);
            return new JMo_Double(r);
        }
        I_Object p1 = cr.argType(args[0], A_Number.class);
        I_Object p2 = cr.argType(args[1], A_Number.class);
        double d1 = Lib_Convert.getDoubleValue(cr, p1);
        double d2 = Lib_Convert.getDoubleValue(cr, p2);
        double r = Lib_Random.getDouble(d1, d2);
        return new JMo_Double(r);
    }

    private Int mGetInt(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 2);
        int len = args.length;
        if (len == 0) {
            int r = Lib_Random.getInt();
            return new Int(r);
        }
        if (len == 1) {
            I_Object p1 = cr.argType(args[0], A_IntNumber.class);
            int i1 = Lib_Convert.getIntValue(cr, p1);
            int r = Lib_Random.getInt(1, i1);
            return new Int(r);
        }
        I_Object p1 = cr.argType(args[0], A_IntNumber.class);
        I_Object p2 = cr.argType(args[1], A_IntNumber.class);
        int i1 = Lib_Convert.getIntValue(cr, p1);
        int i2 = Lib_Convert.getIntValue(cr, p2);
        Lib_Error.ifTooSmall(cr, i1, i2);
        int r = Lib_Random.getInt(i1, i2);
        return new Int(r);
    }

    private Str mGetStr(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 1);
        int len = Lib_Convert.getIntValue(cr, cr.argType(args[0], A_IntNumber.class));
        String source = this.iParsToOptions(cr, args, 1);
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i <= len) {
            int r = Lib_Random.getInt(0, source.length() - 1);
            sb.append(source.charAt(r));
            ++i;
        }
        return new Str(sb.toString());
    }
}

