/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.swing;

import de.mn77.base.error.Err;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.lib.swing.A_Swing_Object;
import org.jaymo_lang.lib.swing.I_Swing_Object;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public abstract class A_Swing_Frame
extends A_Swing_Object {
    private final ArgCallBuffer par_parent;
    private final ArgCallBuffer par_dx;
    private final ArgCallBuffer par_dy;
    private final ArgCallBuffer par_title;
    protected JFrame frame = null;
    private STATE state = STATE.PREPARED;
    private ArrayList<JFrame> childs = null;

    public A_Swing_Frame(Call parent) {
        this.par_parent = parent == null ? null : new ArgCallBuffer(0, parent);
        this.par_dx = null;
        this.par_dy = null;
        this.par_title = null;
    }

    public A_Swing_Frame(Call parent, Call title) {
        this.par_parent = parent == null ? null : new ArgCallBuffer(0, parent);
        this.par_dx = null;
        this.par_dy = null;
        this.par_title = new ArgCallBuffer(1, title);
    }

    public A_Swing_Frame(Call parent, Call dx, Call dy) {
        this.par_parent = parent == null ? null : new ArgCallBuffer(0, parent);
        this.par_dx = new ArgCallBuffer(1, dx);
        this.par_dy = new ArgCallBuffer(2, dy);
        this.par_title = null;
    }

    public A_Swing_Frame(Call parent, Call dx, Call dy, Call title) {
        this.par_parent = parent == null ? null : new ArgCallBuffer(0, parent);
        this.par_dx = new ArgCallBuffer(1, dx);
        this.par_dy = new ArgCallBuffer(2, dy);
        this.par_title = new ArgCallBuffer(1, title);
    }

    @Override
    public Component getSwing() {
        return this.frame;
    }

    @Override
    public void init(final CallRuntime cr) {
        A_Swing_Frame parent;
        this.frame = new JFrame();
        if (this.par_parent != null && (parent = this.par_parent.init(cr, this, A_Swing_Frame.class)) != null) {
            parent.registerFrame(this.frame);
        }
        GridLayout l = new GridLayout(0, 1);
        this.frame.setLayout(l);
        ImageIcon img = new ImageIcon(this.getClass().getClassLoader().getResource("jar/logo/jaymo_icon_256.png"));
        this.frame.setIconImage(img.getImage());
        if (this.par_dx != null && this.par_dy != null) {
            int width = Lib_Convert.getIntValue(cr, this.par_dx.init(cr, this, A_IntNumber.class));
            int height = Lib_Convert.getIntValue(cr, this.par_dy.init(cr, this, A_IntNumber.class));
            this.frame.setSize(width, height);
        }
        if (this.par_title != null) {
            String title = Lib_Convert.getStringValue(cr, this.par_title.init(cr, this, Str.class));
            this.frame.setTitle(title);
        }
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                A_Swing_Frame.this.cleanUp(cr);
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
    }

    @Override
    protected final I_Object callMethod2(CallRuntime cr, String method) {
        if (this.state == STATE.CLOSED) {
            throw new RuntimeError(cr, "Illegal Frame-Access", "This Frame is already closed");
        }
        switch (method) {
            case "close": {
                cr.argsNone();
                this.closeFrame(cr, true);
                return Nil.NIL;
            }
            case "maximize": {
                cr.argsNone();
                this.frame.setExtendedState(this.frame.getExtendedState() | 6);
                return this;
            }
            case "add": {
                I_Object[] addObjs;
                I_Object[] i_ObjectArray = addObjs = cr.argsVar(this, 1, 0);
                int n = addObjs.length;
                int n2 = 0;
                while (n2 < n) {
                    I_Object o = i_ObjectArray[n2];
                    I_Swing_Object so = (I_Swing_Object)cr.argType(o, I_Swing_Object.class);
                    this.frame.getContentPane().add(so.getSwing());
                    ++n2;
                }
                return this;
            }
            case "setSize": {
                this.mSize(cr, SIZE.CURRENT);
                return this;
            }
            case "setSizeMin": {
                this.mSize(cr, SIZE.MIN);
                return this;
            }
            case "setTitle": {
                String title = Lib_Convert.getStringValue(cr, cr.args(this, Str.class)[0]);
                this.frame.setTitle(title);
                return this;
            }
            case "getTitle": {
                cr.argsNone();
                return new Str(this.frame.getTitle());
            }
            case "pack": {
                cr.argsNone();
                this.frame.pack();
                return this;
            }
        }
        return this.callMethod3(cr, method);
    }

    protected abstract I_Object callMethod3(CallRuntime var1, String var2);

    protected void cleanUp(CallRuntime cr) {
        if (this.childs != null) {
            for (Frame frame : this.childs) {
                frame.setVisible(false);
                frame.dispose();
            }
        }
        this.frame.dispose();
        if (this.par_parent == null) {
            cr.getApp().checkExit(true);
        }
    }

    protected void closeFrame(CallRuntime cr, boolean stateCheck) {
        if (stateCheck) {
            switch (this.state) {
                case PREPARED: {
                    throw new RuntimeError(cr, "Illegal Frame-Access", "This frame is not running.");
                }
                case CLOSED: {
                    throw new RuntimeError(cr, "Illegal Frame-Access", "This frame is already closed.");
                }
            }
        }
        this.frame.dispose();
        this.state = STATE.CLOSED;
    }

    protected boolean isRunning() {
        return this.state == STATE.RUNNING;
    }

    protected void setRunState(CallRuntime cr, boolean stateCheck) {
        if (stateCheck) {
            switch (this.state) {
                case RUNNING: {
                    throw new RuntimeError(cr, "Illegal Frame-Access", "This frame is already running.");
                }
                case CLOSED: {
                    throw new RuntimeError(cr, "Illegal Frame-Access", "This frame is closed.");
                }
            }
        }
        this.state = STATE.RUNNING;
    }

    private A_Swing_Frame mSize(CallRuntime cr, SIZE s) {
        I_Object[] args = cr.args(this, Int.class, Int.class);
        int dx = Lib_Convert.getIntValue(cr, args[0]);
        int dy = Lib_Convert.getIntValue(cr, args[1]);
        if (dx < 1 || dy < 1) {
            cr.warning("Value out of bounds", "Minimum of 1 useful, got " + dx + "/" + dy);
            dx = Math.max(dx, 1);
            dy = Math.max(dy, 1);
        }
        switch (s) {
            case CURRENT: {
                this.frame.setSize(dx, dy);
                break;
            }
            case MIN: {
                this.frame.setMinimumSize(new Dimension(dx, dy));
                break;
            }
            case MAX: {
                this.frame.setMaximumSize(new Dimension(dx, dy));
            }
        }
        return this;
    }

    private void registerFrame(JFrame frame) {
        Err.ifNull((Object)frame);
        if (this.childs == null) {
            this.childs = new ArrayList();
        }
        this.childs.add(frame);
    }

    private static enum SIZE {
        CURRENT,
        MIN,
        MAX;

    }

    protected static enum STATE {
        PREPARED,
        RUNNING,
        CLOSED;

    }
}

