/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.miniconf;

import de.mn77.base.data.struct.SimpleList;
import de.mn77.miniconf.result.MIniConfObject;
import de.mn77.miniconf.result.MIniConfResult;
import java.util.Map;
import java.util.Set;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.atom.JMo_Double;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Map;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_MIniConfResult
extends A_ObjectSimple {
    private final MIniConfResult result;

    public JMo_MIniConfResult(MIniConfResult result) {
        this.result = result;
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "asBool": 
            case "bool": {
                return this.mAsBool(cr);
            }
            case "int": 
            case "asInt": {
                return this.mAsInt(cr);
            }
            case "dec": 
            case "asDec": {
                return this.mAsDec(cr);
            }
            case "asDouble": 
            case "double": {
                return this.mAsDouble(cr);
            }
            case "str": 
            case "asStr": {
                return this.mAsStr(cr);
            }
            case "asList": 
            case "list": {
                return this.mAsList(cr);
            }
            case "asObject": 
            case "object": {
                return this.mAsObject(cr);
            }
            case "keys": {
                return this.mKeys(cr);
            }
            case "toMap": {
                return this.mToMap(cr);
            }
        }
        return null;
    }

    private I_Object mAsBool(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        if (args.length == 1) {
            Boolean b = this.result.getBoolean(key);
            return b == null ? Nil.NIL : Bool.getObject(b);
        }
        I_Object arg1 = cr.argType(args[1], Bool.class);
        boolean def = Lib_Convert.getBoolValue(cr, arg1);
        return Bool.getObject(this.result.getBoolean(key, def));
    }

    private I_Object mAsDec(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        if (args.length == 1) {
            Double d = this.result.getDouble(key);
            return d == null ? Nil.NIL : JMo_Dec.valueOf(cr, d);
        }
        I_Object arg1 = cr.argType(args[1], JMo_Dec.class);
        double def = Lib_Convert.getDoubleValue(cr, arg1);
        return JMo_Dec.valueOf(cr, this.result.getDouble(key, def));
    }

    private I_Object mAsDouble(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        if (args.length == 1) {
            Double d = this.result.getDouble(key);
            return d == null ? Nil.NIL : new JMo_Double(d);
        }
        I_Object arg1 = cr.argType(args[1], JMo_Double.class);
        double def = Lib_Convert.getDoubleValue(cr, arg1);
        return new JMo_Double(this.result.getDouble(key, def));
    }

    private I_Object mAsInt(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        if (args.length == 1) {
            Integer i = this.result.getInteger(key);
            return i == null ? Nil.NIL : new Int(i);
        }
        I_Object arg1 = cr.argType(args[1], Int.class);
        int def = Lib_Convert.getIntValue(cr, arg1);
        return new Int(this.result.getInteger(key, def));
    }

    private I_Object mAsList(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        String[] sa = this.result.getList(key);
        if (sa == null) {
            return args.length == 1 ? Nil.NIL : cr.argType(args[1], JMo_List.class);
        }
        SimpleList<I_Object> al = new SimpleList<I_Object>(sa.length);
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            al.add(new Str(s));
            ++n2;
        }
        return new JMo_List(al);
    }

    private I_Object mAsObject(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 3);
        Lib_Error.ifIs(cr, 2, args.length, "amount of arguments");
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        MIniConfObject mo = this.result.getObject(key);
        if (mo == null) {
            if (args.length == 1) {
                return Nil.NIL;
            }
            I_Object arg1 = cr.argType(args[1], Str.class);
            JMo_List arg2 = (JMo_List)cr.argType(args[1], JMo_List.class);
            String arg1s = Lib_Convert.getStringValue(cr, arg1);
            SimpleList<I_Object> al = new SimpleList<I_Object>();
            al.add(new Str(arg1s));
            al.add(arg2);
            return new JMo_List(al);
        }
        SimpleList<I_Object> al1 = new SimpleList<I_Object>();
        al1.add(new Str(mo.type));
        SimpleList<I_Object> al2 = new SimpleList<I_Object>(mo.args.length);
        String[] stringArray = mo.args;
        int n = mo.args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            al2.add(new Str(s));
            ++n2;
        }
        al1.add(new JMo_List(al2));
        return new JMo_List(al1);
    }

    private I_Object mAsStr(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg0 = cr.argType(args[0], Str.class);
        String key = Lib_Convert.getStringValue(cr, arg0);
        if (args.length == 1) {
            String s = this.result.getString(key);
            return s == null ? Nil.NIL : new Str(s);
        }
        I_Object arg1 = cr.argType(args[1], Str.class);
        String def = Lib_Convert.getStringValue(cr, arg1);
        return new Str(this.result.getString(key, def));
    }

    private JMo_List mKeys(CallRuntime cr) {
        cr.argsNone();
        Set<String> keys = this.result.getKeys();
        SimpleList<I_Object> al = new SimpleList<I_Object>(keys.size());
        for (String s : keys) {
            al.add(new Str(s));
        }
        return new JMo_List(al);
    }

    private I_Object mToMap(CallRuntime cr) {
        cr.argsNone();
        int size = this.result.getItems().size();
        SimpleList<I_Object> keys = new SimpleList<I_Object>(size);
        SimpleList<I_Object> objects = new SimpleList<I_Object>(size);
        for (Map.Entry<String, String> e : this.result.getItems()) {
            keys.add(new Str(e.getKey()));
            objects.add(new Str(e.getValue()));
        }
        return new JMo_Map(keys, objects);
    }
}

