/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit;

import de.mn77.base.data.util.Lib_Array;
import de.mn77.base.data.util.Lib_Random;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import de.mn77.base.version.Lib_Version;
import de.mn77.base.version.data.VersionData_ABC;
import de.mn77.lib.swing.DIALOG_TYPE;
import de.mn77.lib.swing.Lib_SwingDialog;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jaymo_lang.JayMo;
import org.jaymo_lang.edit.action.EVENTS;
import org.jaymo_lang.edit.action.JayMo_Actions;
import org.jaymo_lang.edit.defs.FileEditor;
import org.jaymo_lang.edit.defs.ToolbarPanel;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.atom.JMo_Double;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.sys.JMo_Input;
import org.jaymo_lang.parser.Parser_App;

public class Main_JayMo_Edit {
    public static final VersionData_ABC VERSION = new VersionData_ABC(0, 6, 0);
    public static final int DEFAULT_WIDTH = 970;
    public static final int DEFAULT_HEIGHT = 600;
    public static final String NAME = "JayMo-Edit";
    public static final String FONT_FILE = "/jar/font/liberation2/LiberationMono-Regular.ttf";
    public static final float FONT_SIZE = 15.0f;
    public static final int FONT_WIDTH = 9;
    public static final int FONT_HEIGHT = 18;
    public static final String BORDER_FONT_FILE = "/jar/font/dejavu/DejaVuSansMono.ttf";
    private final JFrame frame;
    private final ToolbarPanel panel;
    private final JayMo_Actions actions;

    public static void main(String[] args) {
        String[] args2 = Main_JayMo_Edit.args(args);
        MOut.setJavaErrors(false);
        try {
            Lib_Version.init(VERSION, false);
        }
        catch (Err_FileSys e) {
            Err.show(e);
        }
        System.setProperty("awt.useSystemAAFontSettings", "lcd");
        if (args2 != null) {
            File initFile = args2.length == 1 ? new File(args2[0]) : null;
            SwingUtilities.invokeLater(() -> new Main_JayMo_Edit(initFile).createAndShowGUI());
        }
    }

    private static String[] args(String[] args) {
        block9: {
            int i = 0;
            if (i >= args.length) break block9;
            String s = args[i].trim();
            if (!s.startsWith("-")) {
                String[] args2 = Lib_Array.cutFrom(args, i);
                if (args2.length > 1) {
                    throw new Err_Runtime("Invalid amount of arguments", new Object[0]);
                }
                return args2;
            }
            switch (s) {
                case "--version": {
                    StringBuilder sb = new StringBuilder();
                    sb.append(NAME);
                    sb.append(" ");
                    sb.append(VERSION.toStringShort());
                    sb.append("  /  ");
                    sb.append("JayMo");
                    sb.append(" ");
                    sb.append(new Parser_App().getVersionString(JayMo.STAGE.isDevelopment(), false));
                    MOut.print(sb.toString());
                    return null;
                }
            }
            throw new Err_Runtime("Unknown argument for JayMo-Edit", s);
        }
        return new String[0];
    }

    public Main_JayMo_Edit(File initFile) {
        this.styleUI();
        this.frame = new JFrame();
        this.actions = new JayMo_Actions(this, this.frame);
        this.panel = new ToolbarPanel(this.actions);
        this.initInputSource();
        this.updateTitle(null);
        if (initFile != null) {
            this.actions.open(initFile);
        }
    }

    public void dispose() {
        this.frame.dispose();
    }

    public void setStatus(String s) {
        this.panel.setStatus(s);
    }

    public void updateTitle(FileEditor editor) {
        String title = NAME;
        if (editor != null) {
            if (editor.getCurrentFile() != null) {
                title = String.valueOf(title) + " - " + editor.getCurrentFile().getAbsolutePath();
            }
            if (editor.hasUnsavedChanges()) {
                title = String.valueOf(title) + " *";
            }
        }
        this.frame.setTitle(title);
    }

    private void addKeyEvents(JayMo_Actions actions) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            if (402 != e.getID()) {
                return false;
            }
            int key = e.getKeyCode();
            int mod = e.getModifiersEx();
            int CTRL = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
            int ALT = 512;
            int SHIFT = 64;
            if (key == 81 && mod == CTRL) {
                actions.perform(EVENTS.EXIT);
            } else if (key == 79 && mod == CTRL) {
                actions.perform(EVENTS.OPEN);
            } else if (key == 83 && mod == CTRL) {
                actions.perform(EVENTS.SAVE);
            } else if (key == 83 && mod == CTRL + 64) {
                actions.perform(EVENTS.SAVE_AS);
            } else if (key == 10 && mod == CTRL || key == 153 && mod == CTRL) {
                actions.perform(EVENTS.EXEC);
            } else if (key == 112 && mod == 0) {
                actions.perform(EVENTS.INFO);
            } else if (key == 113 && mod == 0) {
                actions.perform(EVENTS.SAVE);
            } else if (key == 115 && mod == 0) {
                actions.perform(EVENTS.SLIDER);
            } else if (key == 120 && mod == 0) {
                actions.perform(EVENTS.EXEC);
            } else if (key == 121 && mod == 0) {
                actions.perform(EVENTS.STOP);
            } else if (key == 122 && mod == 0 || key == 10 && mod == 512) {
                boolean isMax = this.frame.getExtendedState() == 6;
                this.frame.setExtendedState(isMax ? 0 : 6);
            } else if (key == 123 && mod == 0) {
                actions.perform(EVENTS.WEB);
            } else if (key == 70 && mod == CTRL) {
                actions.perform(EVENTS.FIND);
            } else if (e.getKeyCode() == 72 && mod == CTRL) {
                Lib_SwingDialog.okay(this.frame, DIALOG_TYPE.INFO, "Find & Replace", "Replace-Feature is comming soon.");
            } else if (key == 65 && mod == CTRL + 64) {
                actions.perform(EVENTS.SELECT_NONE);
            } else {
                return false;
            }
            return true;
        });
    }

    private void createAndShowGUI() {
        this.frame.setDefaultCloseOperation(3);
        this.frame.add(this.panel);
        this.frame.pack();
        this.frame.setSize(970, 600);
        this.frame.setVisible(true);
        ImageIcon img = new ImageIcon(this.getClass().getClassLoader().getResource("jar/logo/jaymo_icon_256.png"));
        this.frame.setIconImage(img.getImage());
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                Main_JayMo_Edit.this.actions.actionPerformed(new ActionEvent(this, Lib_Random.getInt(), EVENTS.EXIT.name()));
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.addKeyEvents(this.actions);
        this.panel.setFocus();
    }

    private void initInputSource() {
        JMo_Input.setSource(type -> {
            String message = "Please input";
            if (type == Str.class) {
                message = String.valueOf(message) + " a string";
            } else if (type == Int.class) {
                message = String.valueOf(message) + " a integer";
            } else if (type == JMo_Dec.class || type == JMo_Double.class) {
                message = String.valueOf(message) + " a decimal number";
            } else if (type == Bool.class) {
                message = String.valueOf(message) + " true or false";
            }
            return Lib_SwingDialog.input(this.frame, "Input", message, null);
        });
    }

    private void styleUI() {
    }
}

