/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.json;

import de.mn77.base.error.Err_Runtime;
import de.mn77.lib.json.JsonObject;
import java.util.Collection;
import java.util.Map;

public class Lib_JsonSerialize {
    public static String encode(Object obj) {
        StringBuilder sb = new StringBuilder();
        Lib_JsonSerialize.encode(sb, obj);
        return sb.toString();
    }

    public static void encode(StringBuilder sb, Object obj) {
        if (obj == null) {
            sb.append("null");
        } else if (obj instanceof JsonObject) {
            Lib_JsonSerialize.objectToJson(sb, (JsonObject)obj);
        } else if (obj instanceof Collection) {
            Lib_JsonSerialize.listToJson(sb, (Collection)obj);
        } else if (obj instanceof Map) {
            Lib_JsonSerialize.mapToJson(sb, (Map)obj);
        } else if (obj instanceof String) {
            Lib_JsonSerialize.stringToJson(sb, (String)obj);
        } else if (obj instanceof Double) {
            Lib_JsonSerialize.doubleToJson(sb, (Double)obj);
        } else if (obj instanceof Float) {
            Lib_JsonSerialize.floatToJson(sb, (Float)obj);
        } else if (obj instanceof Number) {
            Lib_JsonSerialize.longToJson(sb, ((Number)obj).longValue());
        } else if (obj instanceof Boolean) {
            Lib_JsonSerialize.booleanToJson(sb, (Boolean)obj);
        } else {
            throw new Err_Runtime("Invalid class for JSON: " + obj.getClass().getName(), new Object[0]);
        }
    }

    public static void listToJson(StringBuilder sb, Collection<?> obj) {
        boolean first = true;
        sb.append('[');
        for (Object element : obj) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Lib_JsonSerialize.encode(sb, element);
        }
        sb.append(']');
    }

    public static void objectToJson(StringBuilder sb, JsonObject obj) {
        Lib_JsonSerialize.mapToJson(sb, obj.getElements());
    }

    private static void booleanToJson(StringBuilder sb, boolean obj) {
        String s = obj ? "true" : "false";
        sb.append(s);
    }

    private static void doubleToJson(StringBuilder sb, Double obj) {
        if (obj.isInfinite() || obj.isNaN()) {
            sb.append("null");
        } else {
            sb.append("" + obj);
        }
    }

    private static void floatToJson(StringBuilder sb, Float obj) {
        if (obj.isInfinite() || obj.isNaN()) {
            sb.append("null");
        } else {
            sb.append("" + obj);
        }
    }

    private static void keyToJson(StringBuilder sb, String key) {
        Lib_JsonSerialize.stringToJson(sb, key);
        sb.append(':');
    }

    private static void longToJson(StringBuilder sb, long obj) {
        sb.append("" + obj);
    }

    private static void mapToJson(StringBuilder sb, Map<?, ?> obj) {
        boolean first = true;
        sb.append('{');
        for (Map.Entry<?, ?> entry : obj.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Lib_JsonSerialize.keyToJson(sb, entry.getKey().toString());
            Lib_JsonSerialize.encode(sb, entry.getValue());
        }
        sb.append('}');
    }

    private static void stringToJson(StringBuilder sb, String obj) {
        sb.append('\"');
        char[] cArray = obj.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '/': {
                    sb.append("\\/");
                    break;
                }
                default: {
                    if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff') {
                        String characterHexCode = Integer.toHexString(c);
                        sb.append("\\u");
                        int k = 0;
                        while (k < 4 - characterHexCode.length()) {
                            sb.append("0");
                            ++k;
                        }
                        sb.append(characterHexCode.toUpperCase());
                        break;
                    }
                    sb.append(c);
                }
            }
            ++n2;
        }
        sb.append('\"');
    }
}

