/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.counter;

import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;

public class IntCounter {
    private int[] data;

    public IntCounter(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    public int amount() {
        int result = 0;
        int[] nArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            result += element;
            ++n2;
        }
        return result;
    }

    public int average() {
        int result = 0;
        int[] nArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            result += element;
            ++n2;
        }
        return result;
    }

    public void count(int value) {
        Err.ifTooSmall(0.0, value);
        if (this.data.length < value + 1) {
            int[] temp = new int[value + 1];
            System.arraycopy(this.data, 0, temp, 0, this.data.length);
            this.data = temp;
        }
        int n = value;
        this.data[n] = this.data[n] + 1;
    }

    public void plot(int width) {
        int max = 0;
        int[] nArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (element > max) {
                max = element;
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        int widthNr = ("" + this.data.length).length();
        int i = 0;
        while (i < this.data.length) {
            sb.append(FormNumber.right(widthNr, i));
            sb.append(" : ");
            int value = (int)Math.ceil((double)width / (double)max * (double)this.data[i]);
            sb.append(Lib_String.sequence('*', (long)value));
            sb.append('\n');
            ++i;
        }
        sb.setLength(sb.length() - 1);
        MOut.print(sb.toString());
    }
}

