/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.version.data;

import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.version.DEVSTAGE;
import de.mn77.base.version.VersionFormatter;
import de.mn77.base.version.data.A_VersionData;
import java.util.List;

public class VersionData_ABCD
extends A_VersionData {
    private int main;
    private int minor;
    private int bugfix;
    private int dev;

    public VersionData_ABCD(I_DateTime time, Long build, String[] sa) {
        super(time, build, sa);
    }

    public VersionData_ABCD(int main, int minor, int bugfix) {
        super(DEVSTAGE.RELEASE);
        this.main = main;
        this.minor = minor;
        this.bugfix = bugfix;
        this.dev = 0;
    }

    public VersionData_ABCD(int main, int minor, int bugfix, int dev) {
        super(DEVSTAGE.RELEASE);
        this.main = main;
        this.minor = minor;
        this.bugfix = bugfix;
        this.dev = 0;
    }

    @Override
    public String format(String format) {
        VersionFormatter form = new VersionFormatter(format);
        form.replace("%1", this.main);
        form.replace("%2", this.minor);
        form.replace("%3", this.bugfix);
        form.replace("%D", this.dev > 0 ? "-dev" + this.dev : "");
        return form.compute(this);
    }

    @Override
    public char getDataToken() {
        return 'b';
    }

    @Override
    public void toFileData(List<Object> list) {
        list.add(this.main);
        list.add(this.minor);
        list.add(this.bugfix);
        list.add(this.dev);
    }

    @Override
    public String toString() {
        return this.iToString(true);
    }

    @Override
    public String toStringShort() {
        return this.iToString(false);
    }

    @Override
    protected DEVSTAGE parse(String[] sa) {
        this.main = Integer.parseInt(sa[0]);
        this.minor = Integer.parseInt(sa[1]);
        this.bugfix = Integer.parseInt(sa[2]);
        this.dev = Integer.parseInt(sa[3]);
        return DEVSTAGE.RELEASE;
    }

    private String iToString(boolean withBuild) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.main);
        sb.append('.');
        sb.append(this.minor);
        if (this.bugfix != 0) {
            sb.append(".");
            sb.append(this.bugfix);
        }
        if (this.dev != 0) {
            sb.append("dev");
            sb.append(this.dev);
        }
        if (withBuild) {
            sb.append(" (Build: ");
            sb.append(this.getBuild());
            sb.append(" - ");
            sb.append(this.getDateTime().toStringShort());
            sb.append(")");
        }
        return sb.toString();
    }
}

