/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.version;

import de.mn77.base.data.type.datetime.format.FORM_DATE;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.version.DEVSTAGE;
import de.mn77.base.version.data.A_VersionData;

public class VersionFormatter {
    private String format;

    public VersionFormatter(String format) {
        this.format = format;
    }

    public String compute(A_VersionData data) {
        boolean isRelease = data.getStage() == DEVSTAGE.RELEASE;
        String tz = isRelease ? "" : ("" + data.getStage().token).toLowerCase();
        this.format = this.format.replaceAll("%t", "" + data.getStage().token);
        this.format = this.format.replaceAll("%\\?t", tz);
        if (data.isLoaded()) {
            this.format = this.format.replaceAll("%DD.MM.YYYY", data.getDateTime().getDate().toString(FORM_DATE.GROUP_DE));
            this.format = this.format.replaceAll("%YYYY-MM-DD", data.getDateTime().getDate().toString(FORM_DATE.GROUP_ISO));
            this.format = this.format.replaceAll("%b", "" + data.getBuild());
        } else {
            this.format = this.format.replaceAll("%DD.MM.YYYY", "");
            this.format = this.format.replaceAll("%YYYY-MM-DD", "");
            this.format = this.format.replaceAll("%b", "");
        }
        return this.format;
    }

    public void replace(String search, Object value) {
        this.format = Lib_String.replace(this.format, search, "" + value);
    }
}

