/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.version;

import de.mn77.base.MN;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.version.BuildFile;
import de.mn77.base.version.DEVSTAGE;
import de.mn77.base.version.VersionDataFactory;
import de.mn77.base.version.data.I_VersionData;

public class Lib_Version {
    private static final boolean online = MN.isProductive();

    public static Group2<Long, I_DateTime> fileDataToBuildTime(String[] sa) {
        MDateTime time = new MDateTime(String.valueOf(sa[0]) + " " + sa[1]);
        Long build = Long.parseLong(sa[2]);
        return new Group2<Long, I_DateTime>(build, time);
    }

    public static I_VersionData init(I_VersionData info, boolean create) throws Err_FileSys {
        return Lib_Version.init(info, create, true);
    }

    public static I_VersionData init(I_VersionData info, boolean create, boolean write) throws Err_FileSys {
        if (online || !write) {
            Lib_Version.iLoadData(info);
        } else {
            Lib_Version.iIncrementData(info, create);
        }
        return info;
    }

    public static I_VersionData initKeep(I_VersionData info) throws Err_FileSys {
        Lib_Version.iLoadData(info);
        return info;
    }

    private static String iComputeFilePath(DEVSTAGE stage) {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        String className = null;
        StackTraceElement[] stackTraceElementArray = trace;
        int n = trace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (!e.getClassName().equals(Lib_Version.class.getName())) {
                className = e.getClassName();
                break;
            }
            ++n2;
        }
        Err.ifNull(className);
        int t = 47;
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        sb.append(className.replace('.', '/'));
        sb.append(".build");
        if (stage != null && stage != DEVSTAGE.RELEASE) {
            sb.append('_');
            sb.append(stage.text.toLowerCase());
        }
        return sb.toString();
    }

    private static void iIncrementData(I_VersionData data, boolean create) throws Err_FileSys {
        if (online) {
            return;
        }
        String filepath = Lib_Version.iComputeFilePath(data.getStage());
        BuildFile buildFile = new BuildFile(filepath);
        String[] sa = buildFile.read();
        I_VersionData info2 = sa == null ? null : VersionDataFactory.createInstance(sa);
        boolean write = true;
        if (create && info2 != null) {
            throw Err.direct("Build-file already exist. Set 'create' to false!", new Object[0]);
        }
        if (!create && info2 == null) {
            MOut.dev("Build-Nr +1 aborted, cause of no init-data!");
            write = false;
        }
        long build = info2 == null ? 0L : info2.getBuild();
        MDateTime timestamp = new MDateTime();
        SimpleList<Object> items = new SimpleList<Object>();
        items.add(timestamp.toStringShort());
        items.add(Long.valueOf(++build));
        items.add(Character.valueOf(data.getDataToken()));
        data.toFileData(items);
        if (write) {
            buildFile.write(items);
        }
        data.setBuildTime(build, timestamp);
    }

    private static void iLoadData(I_VersionData data) throws Err_FileSys {
        String filepath = Lib_Version.iComputeFilePath(data.getStage());
        String[] sa = new BuildFile(filepath).read();
        if (sa != null) {
            Group2<Long, I_DateTime> g = Lib_Version.fileDataToBuildTime(sa);
            data.setBuildTime((Long)g.o1, (I_DateTime)g.o2);
        }
    }
}

