/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.version;

import de.mn77.base.data.convert.ConvertSequence;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.stream.Lib_Stream;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.sys.file.Lib_Jar;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.base.sys.file.SysDir;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class BuildFile {
    private final String path;

    public BuildFile(String path) {
        this.path = path;
    }

    public String[] read() throws Err_FileSys {
        InputStream stream = null;
        try {
            stream = Lib_Jar.getStream(this.path);
        }
        catch (Err_FileSys err_FileSys) {
            // empty catch block
        }
        if (stream == null) {
            MOut.dev("Stream-Error");
            return null;
        }
        String s = Lib_Stream.readASCII(stream);
        if (s == null || s.length() == 0) {
            MOut.dev("Nothing to read!");
            return null;
        }
        return s.trim().split(" ");
    }

    public void write(List<Object> data) {
        I_Directory current = SysDir.current();
        String dataline = ConvertSequence.toString(" ", data);
        try {
            if (current.knowsDir("src")) {
                current = current.dirMust("src");
            }
            String filepath = String.valueOf(current.getPathAbsolute()) + this.path;
            Lib_TextFile.set(new File(filepath), dataline);
        }
        catch (Err_FileSys e) {
            MOut.warning("Build file write error: " + e.getMessage());
        }
    }
}

