/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.data.A_Comparable;
import de.mn77.base.data.type.Lib_Compare;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.sys.file.I_FileSys_Item;
import java.io.File;

public abstract class A_FileSys_Item<TA extends A_FileSys_Item<TA>>
extends A_Comparable<TA>
implements I_FileSys_Item<TA> {
    protected File file;

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getModified() {
        return this.file.lastModified();
    }

    @Override
    public MDateTime getModifiedDateTime() {
        long modified = this.file.lastModified();
        return modified == 0L ? null : new MDateTime(modified);
    }

    @Override
    public String getPathAbsolute() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean isEqual(TA to) {
        String path1 = this.getPathAbsolute();
        String path2 = ((A_FileSys_Item)to).getPathAbsolute();
        return path1.equals(path2);
    }

    @Override
    public boolean isGreater(TA than) {
        String path1 = this.getPathAbsolute();
        String path2 = ((A_FileSys_Item)than).getPathAbsolute();
        return Lib_Compare.isGreaterString(path1, path2);
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public String toString() {
        return this.file.toString();
    }
}

