/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.type.datetime;

import de.mn77.base.data.A_Comparable;
import de.mn77.base.data.convert.ConvertString;
import de.mn77.base.data.form.FormDateTime;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.Lib_DateTime;
import de.mn77.base.data.type.datetime.format.FORM_TIME;
import de.mn77.base.error.Err;
import java.sql.Time;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class MTime
extends A_Comparable<I_Time>
implements I_Time {
    private final int value;

    public MTime() {
        GregorianCalendar greg = new GregorianCalendar();
        greg.setTimeZone(TimeZone.getDefault());
        this.value = this.iEncode(greg.get(11), greg.get(12), greg.get(13), greg.get(14));
    }

    public MTime(Calendar c) {
        Err.ifNull((Object)c);
        this.value = this.iEncode(c.get(11), c.get(12), c.get(13), c.get(14));
    }

    public MTime(int milliSecDay) {
        this.value = this.iNormalize(milliSecDay);
    }

    public MTime(int hour, int min, int sec) {
        this(hour, min, sec, 0);
    }

    public MTime(int hour, int min, int sec, int millisec) {
        this.value = this.iEncode(this.iCheck24(hour), this.iCheck60(min), this.iCheck60(sec), this.iCheck1000(millisec));
    }

    public MTime(long epochUtcMilliSec) {
        GregorianCalendar greg = new GregorianCalendar();
        greg.setTimeZone(TimeZone.getDefault());
        greg.setTimeInMillis(epochUtcMilliSec);
        this.value = this.iEncode(greg.get(11), greg.get(12), greg.get(13), greg.get(14));
    }

    public MTime(String s) {
        Err.ifNull((Object)s);
        if (s.length() == 0) {
            Err.invalid("Empty string");
        }
        String hh = "0";
        String mm = "0";
        String ss = "0";
        String ms = "0";
        int indexDot = s.indexOf(46);
        if (indexDot > -1) {
            ms = s.substring(indexDot + 1);
            s = s.substring(0, indexDot);
        }
        List<String> parts = ConvertString.toList(":", s);
        if (indexDot > -1 && parts.size() != 3) {
            throw Err.invalid("Use HH:MM:SS.xxx");
        }
        switch (parts.size()) {
            case 3: {
                ss = parts.get(2);
            }
            case 2: {
                mm = parts.get(1);
            }
            case 1: {
                hh = parts.get(0);
                break;
            }
            default: {
                throw Err.invalid("Only 0-2 double dots are allowed!");
            }
        }
        this.value = this.iEncode(this.iCheck24(this.iParseNumber(hh)), this.iCheck60(this.iParseNumber(mm)), this.iCheck60(this.iParseNumber(ss)), this.iCheck1000(this.iParseNumber(ms)));
    }

    public MTime(Time time) {
        Err.ifNull((Object)time);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(time.getTime());
        this.value = this.iEncode(gc.get(11), gc.get(12), gc.get(13), gc.get(14));
    }

    @Override
    public int diffHours(I_Time other) {
        return this.diffSeconds(other) / 60 / 60;
    }

    @Override
    public int diffMilliSeconds(I_Time other) {
        return (int)other.getValueMilliSeconds() - this.value;
    }

    @Override
    public int diffMinutes(I_Time other) {
        return this.diffSeconds(other) / 60;
    }

    @Override
    public int diffSeconds(I_Time other) {
        return this.diffMilliSeconds(other) / 1000;
    }

    @Override
    public I_Time getAddHours(int amount) {
        Err.ifOutOfBounds(572.0, amount);
        int sum = this.value + amount * 60 * 60 * 1000;
        return new MTime(this.iNormalize(sum));
    }

    @Override
    public I_Time getAddMilliSeconds(int amount) {
        Err.ifOutOfBounds(2.061083647E9, amount);
        int sum = this.value + amount;
        return new MTime(this.iNormalize(sum));
    }

    @Override
    public I_Time getAddMinutes(int amount) {
        Err.ifOutOfBounds(34351.0, amount);
        int sum = this.value + amount * 60 * 1000;
        return new MTime(this.iNormalize(sum));
    }

    @Override
    public I_Time getAddSeconds(int amount) {
        Err.ifOutOfBounds(2061083.0, amount);
        int sum = this.value + amount * 1000;
        return new MTime(this.iNormalize(sum));
    }

    @Override
    public int getHours() {
        return this.value / 1000 / 60 / 60;
    }

    @Override
    public int getMilliSeconds() {
        return this.iDecode(this.value)[3];
    }

    @Override
    public int getMinutes() {
        return this.iDecode(this.value)[1];
    }

    @Override
    public int getSeconds() {
        return this.iDecode(this.value)[2];
    }

    @Override
    public I_Time getSetHour(int newHour) {
        int[] current = this.iDecode(this.value);
        return new MTime(newHour, current[1], current[2], current[3]);
    }

    @Override
    public I_Time getSetMilliSecond(int milliseconds) {
        int[] current = this.iDecode(this.value);
        return new MTime(current[0], current[1], current[2], milliseconds);
    }

    @Override
    public I_Time getSetMinute(int newMinute) {
        int[] current = this.iDecode(this.value);
        return new MTime(current[0], newMinute, current[2], current[3]);
    }

    @Override
    public I_Time getSetSecond(int newSecond) {
        int[] current = this.iDecode(this.value);
        return new MTime(current[0], current[1], newSecond, current[3]);
    }

    @Override
    public long getValueMilliSeconds() {
        return this.value;
    }

    @Override
    public int getValueSeconds() {
        return this.value / 1000;
    }

    @Override
    public boolean isEqual(I_Time t) {
        return t.getHours() == this.getHours() && t.getMinutes() == this.getMinutes() && t.getSeconds() == this.getSeconds();
    }

    @Override
    public boolean isGreater(I_Time than) {
        long other = Lib_DateTime.toMilliSec(than.getHours(), than.getMinutes(), than.getSeconds(), 0);
        long current = Lib_DateTime.toMilliSec(this.getHours(), this.getMinutes(), this.getSeconds(), 0);
        return current > other;
    }

    @Override
    public I_Time toRoundedHHMM() {
        int rounded = (int)Math.round((double)this.value / 60000.0) * 60000;
        return new MTime(rounded);
    }

    @Override
    public String toString() {
        return FormDateTime.compose(this, FORM_TIME.GROUP_HHMMSS_DDD);
    }

    @Override
    public String toString(Object ... form) {
        return FormDateTime.compose(this, form);
    }

    @Override
    public String toStringDE() {
        return FormDateTime.compose(this, FORM_TIME.GROUP_HHMMSS);
    }

    @Override
    public String toStringFileSysSlim() {
        return FormDateTime.compose(this, FORM_TIME.GROUP_HHMMSS_SLIM);
    }

    @Override
    public String toStringFileSysWide() {
        return FormDateTime.compose(this, FORM_TIME.GROUP_HH_MM_SS);
    }

    @Override
    public String toStringShort() {
        return FormDateTime.compose(this, FORM_TIME.GROUP_HHMMSS);
    }

    public String toStringSlim() {
        return FormDateTime.compose(this, FORM_TIME.GROUP_HHMMSS_DDD_SLIM);
    }

    @Override
    public boolean usesMilliSeconds() {
        return Lib_DateTime.usesMilliSeconds(this.value);
    }

    private int iCheck1000(int value) {
        Err.ifOutOfBounds(0, 999, value);
        return value;
    }

    private int iCheck24(int hour) {
        Err.ifOutOfBounds(0, 23, hour);
        return hour;
    }

    private int iCheck60(int value) {
        Err.ifOutOfBounds(0, 59, value);
        return value;
    }

    private int[] iDecode(int v) {
        int[] result;
        result = new int[]{v / 1000 / 60 / 60, (v -= result[0] * 1000 * 60 * 60) / 1000 / 60, (v -= result[1] * 1000 * 60) / 1000, v -= result[2] * 1000};
        return result;
    }

    private int iEncode(int hh, int mm, int ss, int ms) {
        return hh * 1000 * 60 * 60 + mm * 1000 * 60 + ss * 1000 + ms;
    }

    private int iNormalize(int sum) {
        int day = 86400000;
        while (sum < 0) {
            sum += 86400000;
        }
        while (sum > 86400000) {
            sum -= 86400000;
        }
        return sum;
    }

    private int iParseNumber(String s) {
        int len = s.length();
        if (s == null || len == 0) {
            return 0;
        }
        Err.ifOutOfBounds(1, 3, len);
        try {
            return Integer.valueOf(s);
        }
        catch (Exception e) {
            throw Err.invalid(s);
        }
    }
}

