/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.type.datetime;

import de.mn77.base.data.A_Comparable;
import de.mn77.base.data.constant.LANGUAGE;
import de.mn77.base.data.form.FormDateTime;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.Lib_DateTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class MDate
extends A_Comparable<I_Date>
implements I_Date {
    private final int year;
    private final int month;
    private final int day;

    public MDate() {
        this(new GregorianCalendar());
    }

    public MDate(Calendar gc) {
        Err.ifNull((Object)gc);
        this.year = gc.get(1);
        this.month = gc.get(2) + 1;
        this.day = gc.get(5);
    }

    public MDate(Date date) {
        Err.ifNull((Object)date);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(date.getTime());
        this.year = gc.get(1);
        this.month = gc.get(2) + 1;
        this.day = gc.get(5);
    }

    public MDate(int year, int month, int day) {
        this.iCheck(year, month, day);
        this.day = day;
        this.month = month;
        this.year = year;
    }

    public MDate(long ms) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(ms);
        this.year = gc.get(1);
        this.month = gc.get(2) + 1;
        this.day = gc.get(5);
    }

    public MDate(String date) {
        block9: {
            Err.ifNull((Object)date);
            int laenge = date.length();
            try {
                if (date.length() >= 11 && date.charAt(10) == 'T') {
                    date = date.substring(0, 10);
                }
                if (date.matches("[1-2][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]")) {
                    this.year = this.iParse(4, date.substring(0, 4));
                    this.month = this.iParse(2, date.substring(5, 7));
                    this.day = this.iParse(2, date.substring(8, 10));
                    break block9;
                }
                if (date.matches("[0-3][0-9].[0-1][0-9].[1-2][0-9][0-9][0-9]")) {
                    this.year = this.iParse(4, date.substring(6, 10));
                    this.month = this.iParse(2, date.substring(3, 5));
                    this.day = this.iParse(2, date.substring(0, 2));
                    break block9;
                }
                if (date.matches("[0-3][0-9].[0-1][0-9].[0-9][0-9]")) {
                    this.year = Lib_DateTime.yearShortToLong(date.substring(6, 8));
                    this.month = this.iParse(2, date.substring(3, 5));
                    this.day = this.iParse(2, date.substring(0, 2));
                    break block9;
                }
                if (laenge >= 6 && laenge <= 10 && date.matches("^[0-3]?[0-9]\\.[01]?[0-9]\\.[12]?[0-9]{1,3}$")) {
                    String regex = "^([0-9]+)\\.([0-9]+)\\.([0-9]+)$";
                    String tjahr = date.replaceFirst("^([0-9]+)\\.([0-9]+)\\.([0-9]+)$", "$3");
                    if (tjahr.length() == 1 || tjahr.length() == 3) {
                        throw Err.invalid(date);
                    }
                    this.day = Integer.parseInt(date.replaceFirst("^([0-9]+)\\.([0-9]+)\\.([0-9]+)$", "$1"));
                    this.month = Integer.parseInt(date.replaceFirst("^([0-9]+)\\.([0-9]+)\\.([0-9]+)$", "$2"));
                    this.year = tjahr.length() == 2 ? Lib_DateTime.yearShortToLong(tjahr) : Integer.parseInt(tjahr);
                    break block9;
                }
                if (laenge >= 8 && laenge <= 10 && date.matches("^[12]?[0-9]{1,3}-[01]?[0-9]-[0-3]?[0-9]$")) {
                    String regex = "^([0-9]+)-([0-9]+)-([0-9]+)$";
                    this.day = Integer.parseInt(date.replaceFirst("^([0-9]+)-([0-9]+)-([0-9]+)$", "$3"));
                    this.month = Integer.parseInt(date.replaceFirst("^([0-9]+)-([0-9]+)-([0-9]+)$", "$2"));
                    this.year = Integer.parseInt(date.replaceFirst("^([0-9]+)-([0-9]+)-([0-9]+)$", "$1"));
                    break block9;
                }
                throw Err.invalid(date);
            }
            catch (Err_Runtime f) {
                throw Err.wrap(f, "Invalid String!", date);
            }
        }
    }

    @Override
    public int diffDays(I_Date d) {
        long current = Lib_DateTime.toMilliSec(this.year, this.month, this.day);
        long target = Lib_DateTime.toMilliSec(d.getYear(), d.getMonth(), d.getDay());
        double diff_ms = target - current;
        double diffdays = diff_ms / 1000.0 / 60.0 / 60.0 / 24.0;
        int days = (int)diffdays;
        if (Math.abs(diffdays - (double)((int)diffdays)) > 0.9) {
            days += diffdays > 0.0 ? 1 : -1;
        }
        return days;
    }

    @Override
    public int diffMonths(I_Date d) {
        boolean dig = d.isGreater(this);
        I_Date small = dig ? this : d;
        I_Date big = dig ? d : this;
        int result = small.diffYears(big) * 12;
        int k1 = big.getMonth() - small.getMonth();
        if (k1 < 0 || k1 == 0 && big.getDay() < small.getDay()) {
            k1 += 12;
        }
        result += k1;
        if (big.getDay() < small.getDay()) {
            --result;
        }
        if (!dig) {
            result = -result;
        }
        return result;
    }

    @Override
    public int diffYears(I_Date d) {
        boolean dig = d.isGreater(this);
        I_Date small = dig ? this : d;
        I_Date big = dig ? d : this;
        int result = big.getYear() - small.getYear();
        if (big.getMonth() < small.getMonth() || big.getMonth() == small.getMonth() && big.getDay() < small.getDay()) {
            --result;
        }
        if (!dig) {
            result = -result;
        }
        return result;
    }

    @Override
    public I_Date getAddDays(int amount) {
        long added = Lib_DateTime.addDays(this.getYear(), this.getMonth(), this.getDay(), amount);
        return new MDate(added);
    }

    @Override
    public I_Date getAddMonths(int amount) {
        GregorianCalendar gc = this.iGetGregorian();
        gc.add(2, amount);
        return new MDate(gc);
    }

    @Override
    public I_Date getAddYears(int amount) {
        GregorianCalendar gc = this.iGetGregorian();
        gc.add(1, amount);
        return new MDate(gc);
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public int getDayOfWeek() {
        GregorianCalendar gc = this.iGetGregorian();
        return gc.get(7) - 1;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public I_Date getSetDay(int newDay) {
        return new MDate(this.year, this.month, newDay);
    }

    @Override
    public I_Date getSetMonth(int newMonth) {
        return new MDate(this.year, newMonth, this.day);
    }

    @Override
    public I_Date getSetYear(int newYear) {
        return new MDate(newYear, this.month, this.day);
    }

    @Override
    public long getValueMilliSeconds() {
        return Lib_DateTime.toMilliSec(this.getYear(), this.getMonth(), this.getDay());
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public boolean isEqual(I_Date date) {
        Err.ifNull((Object)date);
        return date.getYear() == this.getYear() && date.getMonth() == this.getMonth() && date.getDay() == this.getDay();
    }

    @Override
    public boolean isGreater(I_Date date) {
        long target = Lib_DateTime.toMilliSec(date.getYear(), date.getMonth(), date.getDay());
        long current = Lib_DateTime.toMilliSec(this.getYear(), this.getMonth(), this.getDay());
        return current > target;
    }

    @Override
    public String toString() {
        return FormDateTime.composeISO(this);
    }

    @Override
    public String toString(Object ... format) {
        return format.length == 0 ? this.toString() : FormDateTime.compose((I_Date)this, LANGUAGE.EN, format);
    }

    @Override
    public String toStringDE() {
        return FormDateTime.composeDE(this);
    }

    @Override
    public String toStringFileSysSlim() {
        return FormDateTime.composeSlim(this);
    }

    @Override
    public String toStringFileSysWide() {
        return FormDateTime.composeISO(this);
    }

    private void iCheck(int year, int month, int day) {
        Err.ifOutOfBounds(1600, 2999, year);
        Err.ifOutOfBounds(1, 12, month);
        Err.ifOutOfBounds(1, Lib_DateTime.daysOfMonth(year, month), day);
    }

    private GregorianCalendar iGetGregorian() {
        long current = Lib_DateTime.toMilliSec(this.getYear(), this.getMonth(), this.getDay());
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(current);
        return gc;
    }

    private int iParse(int length, String s) {
        Err.ifNot(length, s.length(), "Length of string not as expected");
        String result = s;
        if (s.length() == 0) {
            Err.invalid(s);
        }
        if (!result.equals(result.trim())) {
            Err.invalid(s);
        }
        try {
            return Integer.valueOf(result);
        }
        catch (Exception e) {
            throw Err.invalid(s);
        }
    }
}

