/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.table;

import de.mn77.base.data.struct.I_List;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.sort.Sort;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.Lib_Table;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrayTable<T>
implements I_Table<T> {
    private static final String ERR_ADD_WIDTH = "The amount of items doesn't fit to the width of the table!";
    private final ArrayList<T[]> table;
    private final int width;

    public ArrayTable(int width) {
        Err.ifTooSmall(1.0, width);
        this.width = width;
        this.table = new ArrayList();
    }

    public ArrayTable(int width, int capacity) {
        Err.ifTooSmall(1.0, width);
        this.width = width;
        this.table = new ArrayList(capacity);
    }

    @Override
    public void add(Collection<T> row) {
        Err.ifNot(row.size(), this.width, ERR_ADD_WIDTH);
        Object[] rowArray = new Object[this.width];
        int i = 0;
        for (T t : row) {
            rowArray[i] = t;
            ++i;
        }
        this.table.add(rowArray);
    }

    @Override
    public void add(int index, T[] e) {
        Err.ifNot(e.length, this.width, ERR_ADD_WIDTH);
        this.table.add(index, e);
    }

    @Override
    public boolean add(T[] e) {
        Err.ifNot(e.length, this.width, ERR_ADD_WIDTH);
        this.table.add(e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T[]> c) {
        for (T[] TArray : c) {
            this.add(TArray);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T[]> c) {
        throw Err.todo(c);
    }

    @Override
    public boolean addRow(T ... row) {
        Err.ifNot(row.length, this.width, ERR_ADD_WIDTH);
        this.table.add(row);
        return true;
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public boolean contains(Object o) {
        Iterator<T[]> iterator = this.table.iterator();
        while (iterator.hasNext()) {
            T[] row;
            T[] TArray = row = iterator.next();
            int n = row.length;
            int n2 = 0;
            while (n2 < n) {
                T cell = TArray[n2];
                if (cell.equals(o)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw Err.todo(c);
    }

    @Override
    public ArrayTable<T> copy() {
        ArrayTable<T> result = new ArrayTable<T>(this.width);
        result.addAll(this);
        return result;
    }

    @Override
    public void exchange(int indexA, int indexB) {
        Err.ifOutOfBounds(0, this.table.size(), indexA);
        Err.ifOutOfBounds(0, this.table.size(), indexB);
        if (indexA == indexB) {
            MOut.warning("Change of " + indexA + " and " + indexB + " not necessary!");
            return;
        }
        T[] buffer = this.table.get(indexA);
        this.table.set(indexA, this.table.get(indexB));
        this.table.set(indexB, buffer);
    }

    @Override
    public T[] get(int index) {
        return this.getRow(index);
    }

    @Override
    public T get(int col, int row) {
        return this.table.get(row)[col];
    }

    @Override
    public I_List<T> getColumn(int index) {
        Err.ifOutOfBounds(0, this.width - 1, index);
        SimpleList<T> result = new SimpleList<T>(this.table.size());
        for (T[] row : this.table) {
            result.add(row[index]);
        }
        return result;
    }

    @Override
    public T[] getRow(int index) {
        return this.table.get(index);
    }

    @Override
    public int indexOf(Object o) {
        throw Err.todo(o);
    }

    @Override
    public void insertRow(int index, T ... row) {
        Err.ifOutOfBounds(0, this.size() - 1, index);
        Err.ifNot(row.length, this.width, ERR_ADD_WIDTH);
        this.table.add(index, row);
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @Override
    public Iterator<T[]> iterator() {
        return this.table.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw Err.todo(o);
    }

    @Override
    public ListIterator<T[]> listIterator() {
        return this.table.listIterator();
    }

    @Override
    public ListIterator<T[]> listIterator(int index) {
        return this.table.listIterator(index);
    }

    @Override
    public T[] remove(int index) {
        return this.table.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        throw Err.todo(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw Err.todo(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw Err.todo(c);
    }

    @Override
    public void reverse() {
        T[] buffer = null;
        int left = 0;
        int right = this.table.size() - 1;
        while (left < right) {
            buffer = this.table.get(left);
            this.table.set(left, this.table.get(right));
            this.table.set(right, buffer);
            ++left;
            --right;
        }
    }

    @Override
    public void set(int col, int row, T o) {
        this.table.get((int)row)[col] = o;
    }

    @Override
    public T[] set(int index, T[] element) {
        throw Err.todo(index, element);
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public void sort() {
        Sort.table(this, null);
    }

    @Override
    public void sort(int ... columnOrder) {
        Sort.table(this, columnOrder);
    }

    @Override
    public void sortLike(int[] newIndexes) {
        int size = this.table.size();
        Err.ifNot(size, newIndexes.length, "Table and order indexes have different length");
        Object[][] buffer = new Object[size][];
        int i = 0;
        while (i < size) {
            buffer[i] = this.table.get(newIndexes[i]);
            ++i;
        }
        i = 0;
        while (i < buffer.length) {
            this.table.set(i, buffer[i]);
            ++i;
        }
    }

    @Override
    public void sortRandom() {
        Sort.sortableRandom(this);
    }

    @Override
    public List<T[]> subList(int fromIndex, int toIndex) {
        return this.table.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.table.toArray();
    }

    @Override
    public <TA> TA[] toArray(TA[] a) {
        return this.table.toArray(a);
    }

    @Override
    public String toDescribe() {
        return this.toString();
    }

    @Override
    public String toIdent() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('<');
        sb.append(this.size());
        sb.append('>');
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] titles) {
        return Lib_Table.toString(this, titles);
    }

    @Override
    public int width() {
        return this.width;
    }
}

