/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct;

import java.util.LinkedList;

public class HistoryList<T> {
    private final LinkedList<T> list = new LinkedList();
    private int pointer = 0;

    public void add(T t) {
        this.pointer = 0;
        if (t == null || !this.list.isEmpty() && t.equals(this.list.getLast())) {
            return;
        }
        this.list.addLast(t);
    }

    public T back() {
        if (this.list.size() == 0) {
            return null;
        }
        --this.pointer;
        if (Math.abs(this.pointer) > this.list.size()) {
            this.pointer = 0 - this.list.size();
        }
        return this.list.get(this.list.size() + this.pointer);
    }

    public T forward() {
        ++this.pointer;
        if (this.pointer > 0) {
            this.pointer = 0;
        }
        if (this.pointer == 0) {
            return null;
        }
        return this.list.get(this.list.size() + this.pointer);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }
}

