/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.convert;

import de.mn77.base.data.convert.ConvertObject;
import de.mn77.base.data.struct.atomic.IntList;
import de.mn77.base.data.util.Lib_Array;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConvertSequence {
    public static <T> String linesToString(Iterable<String> data, boolean nlBefore, boolean nlAfter) {
        StringBuilder sb = new StringBuilder();
        boolean hasLines = false;
        for (String s : data) {
            if (!hasLines) {
                hasLines = true;
            } else {
                sb.append('\n');
            }
            sb.append(s);
        }
        if (hasLines) {
            if (nlBefore) {
                sb.insert(0, '\n');
            }
            if (nlAfter) {
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static <T> T[] toArray(Class<T> type, Collection<T> list) {
        Err.ifNull(list);
        Object[] result = null;
        result = type == null ? new Object[list.size()] : Lib_Array.newArray(type, list.size());
        int i = 0;
        for (T t : list) {
            result[i] = t;
            ++i;
        }
        return result;
    }

    public static <T> T[] toArray(List<T> list) {
        return ConvertSequence.toArray(list.size() == 0 || list.get(0) == null ? null : list.get(0).getClass(), list);
    }

    public static <T> String toIdent(String delimiter, Iterable<T> list) {
        String result = "";
        boolean first = true;
        for (T t : list) {
            result = String.valueOf(result) + (first ? "" : delimiter) + ConvertObject.toStringIdent(t);
            first = false;
        }
        return result;
    }

    public static int[] toIntArray(Iterable<Integer> numbers) {
        IntList result = new IntList();
        for (Integer num : numbers) {
            result.add(num);
        }
        return result.toArray();
    }

    public static int[] toIntArray(List<Integer> numbers) {
        int[] result = new int[numbers.size()];
        int i = 0;
        while (i < numbers.size()) {
            result[i] = numbers.get(i);
            ++i;
        }
        return result;
    }

    public static ArrayList<Integer> toListInt(Iterable<String> numbers) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String s : numbers) {
            result.add(Integer.parseInt(s));
        }
        return result;
    }

    public static <T> String toString(char delimiter, Iterable<String> list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String t : list) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(t);
        }
        return sb.toString();
    }

    public static <T> String toString(String delimiter, Iterable<T> list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T t : list) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(t.toString());
        }
        return sb.toString();
    }
}

