/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.bigcalc;

import de.mn77.base.data.bigcalc.BigExpCalculator;
import de.mn77.base.data.util.Lib_BigMath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Lib_BigCalc {
    private static final BigDecimal DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final int EXPECTED_INITIAL_PRECISION = 15;
    private static volatile BigDecimal log10Cache;
    private static final Object log10CacheLock;
    private static volatile BigDecimal log2Cache;
    private static final Object log2CacheLock;
    private static volatile BigDecimal log3Cache;
    private static final Object log3CacheLock;

    static {
        log10CacheLock = new Object();
        log2CacheLock = new Object();
        log3CacheLock = new Object();
    }

    public static BigDecimal exp(BigDecimal x, MathContext mathContext) {
        Lib_BigMath.checkMathContextNoUnlimited(mathContext);
        if (x.signum() == 0) {
            return BigDecimal.ONE;
        }
        return Lib_BigCalc.expIntegralFractional(x, mathContext);
    }

    public static int exponent(BigDecimal value) {
        return value.precision() - value.scale() - 1;
    }

    public static BigDecimal fractionalPart(BigDecimal value) {
        return value.subtract(Lib_BigCalc.integralPart(value));
    }

    public static BigDecimal integralPart(BigDecimal value) {
        return value.setScale(0, RoundingMode.DOWN);
    }

    public static boolean isDoubleValue(BigDecimal value) {
        return value.compareTo(DOUBLE_MAX_VALUE) <= 0 && value.compareTo(DOUBLE_MAX_VALUE.negate()) >= 0;
    }

    public static BigDecimal log(BigDecimal x, MathContext mathContext) {
        BigDecimal result;
        Lib_BigMath.checkMathContextNoUnlimited(mathContext);
        if (x.signum() <= 0) {
            throw new ArithmeticException("Illegal log(x) for x <= 0: x = " + x);
        }
        if (x.compareTo(BigDecimal.ONE) == 0) {
            return BigDecimal.ZERO;
        }
        switch (x.compareTo(BigDecimal.TEN)) {
            case 0: {
                result = Lib_BigCalc.logTen(mathContext);
                break;
            }
            case 1: {
                result = Lib_BigCalc.logUsingExponent(x, mathContext);
                break;
            }
            default: {
                result = Lib_BigCalc.logUsingTwoThree(x, mathContext);
            }
        }
        return Lib_BigMath.round(result, mathContext);
    }

    public static BigDecimal mantissa(BigDecimal value) {
        int exponent = Lib_BigCalc.exponent(value);
        if (exponent == 0) {
            return value;
        }
        return value.movePointLeft(exponent);
    }

    public static BigDecimal pow(BigDecimal x, BigDecimal y, MathContext mathContext) {
        Lib_BigMath.checkMathContextNoUnlimited(mathContext);
        if (x.signum() == 0) {
            switch (y.signum()) {
                case 0: {
                    return Lib_BigMath.round(BigDecimal.ONE, mathContext);
                }
                case 1: {
                    return Lib_BigMath.round(BigDecimal.ZERO, mathContext);
                }
            }
        }
        try {
            long longValue = y.longValueExact();
            return Lib_BigCalc.pow(x, longValue, mathContext);
        }
        catch (ArithmeticException longValue) {
            if (Lib_BigCalc.fractionalPart(y).signum() == 0) {
                return Lib_BigCalc.powInteger(x, y, mathContext);
            }
            MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
            BigDecimal result = Lib_BigCalc.exp(y.multiply(Lib_BigCalc.log(x, mc), mc), mc);
            return Lib_BigMath.round(result, mathContext);
        }
    }

    public static BigDecimal pow(BigDecimal x, long y, MathContext mathContext) {
        MathContext mc;
        MathContext mathContext2 = mc = mathContext.getPrecision() == 0 ? mathContext : new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        if (y < 0L) {
            BigDecimal value = Lib_BigCalc.reciprocal(Lib_BigCalc.pow(x, -y, mc), mc);
            return Lib_BigMath.round(value, mathContext);
        }
        BigDecimal result = BigDecimal.ONE;
        while (y > 0L) {
            if ((y & 1L) == 1L) {
                result = result.multiply(x, mc);
                --y;
            }
            if (y > 0L) {
                x = x.multiply(x, mc);
            }
            y >>= 1;
        }
        return Lib_BigMath.round(result, mathContext);
    }

    public static BigDecimal reciprocal(BigDecimal x, MathContext mathContext) {
        return BigDecimal.ONE.divide(x, mathContext);
    }

    private static BigDecimal expIntegralFractional(BigDecimal x, MathContext mathContext) {
        BigDecimal integralPart = Lib_BigCalc.integralPart(x);
        if (integralPart.signum() == 0) {
            return Lib_BigCalc.expTaylor(x, mathContext);
        }
        BigDecimal fractionalPart = x.subtract(integralPart);
        MathContext mc = new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        BigDecimal z = BigDecimal.ONE.add(fractionalPart.divide(integralPart, mc));
        BigDecimal t = Lib_BigCalc.expTaylor(z, mc);
        BigDecimal result = Lib_BigCalc.pow(t, integralPart.intValueExact(), mc);
        return Lib_BigMath.round(result, mathContext);
    }

    private static BigDecimal expTaylor(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        x = x.divide(BigDecimal.valueOf(256L), mc);
        BigDecimal result = BigExpCalculator.INSTANCE.calculate(x, mc);
        result = Lib_BigCalc.pow(result, 256L, mc);
        return Lib_BigMath.round(result, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logTen(MathContext mathContext) {
        BigDecimal result = null;
        Object object = log10CacheLock;
        synchronized (object) {
            if (log10Cache == null || mathContext.getPrecision() > log10Cache.precision()) {
                log10Cache = Lib_BigCalc.logUsingNewton(BigDecimal.TEN, mathContext);
                return log10Cache;
            }
            result = log10Cache;
        }
        return Lib_BigMath.round(result, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logThree(MathContext mathContext) {
        BigDecimal result = null;
        Object object = log3CacheLock;
        synchronized (object) {
            if (log3Cache == null || mathContext.getPrecision() > log3Cache.precision()) {
                log3Cache = Lib_BigCalc.logUsingNewton(Lib_BigMath.THREE, mathContext);
                return log3Cache;
            }
            result = log3Cache;
        }
        return Lib_BigMath.round(result, mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logTwo(MathContext mathContext) {
        BigDecimal result = null;
        Object object = log2CacheLock;
        synchronized (object) {
            if (log2Cache == null || mathContext.getPrecision() > log2Cache.precision()) {
                log2Cache = Lib_BigCalc.logUsingNewton(Lib_BigMath.TWO, mathContext);
                return log2Cache;
            }
            result = log2Cache;
        }
        return Lib_BigMath.round(result, mathContext);
    }

    private static BigDecimal logUsingExponent(BigDecimal x, MathContext mathContext) {
        MathContext mcDouble = new MathContext(mathContext.getPrecision() << 1, mathContext.getRoundingMode());
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        int exponent = Lib_BigCalc.exponent(x);
        BigDecimal mantissa = Lib_BigCalc.mantissa(x);
        BigDecimal result = Lib_BigCalc.logUsingTwoThree(mantissa, mc);
        if (exponent != 0) {
            result = result.add(BigDecimal.valueOf(exponent).multiply(Lib_BigCalc.logTen(mcDouble), mc));
        }
        return result;
    }

    private static BigDecimal logUsingNewton(BigDecimal x, MathContext mathContext) {
        BigDecimal step;
        int adaptivePrecision;
        BigDecimal result;
        int maxPrecision = mathContext.getPrecision() + 20;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        double doubleX = x.doubleValue();
        if (doubleX > 0.0 && Lib_BigCalc.isDoubleValue(x)) {
            result = BigDecimal.valueOf(Math.log(doubleX));
            adaptivePrecision = 15;
        } else {
            result = x.divide(Lib_BigMath.TWO, mathContext);
            adaptivePrecision = 1;
        }
        do {
            if ((adaptivePrecision *= 3) > maxPrecision) {
                adaptivePrecision = maxPrecision;
            }
            MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
            BigDecimal expY = Lib_BigCalc.exp(result, mc);
            step = Lib_BigMath.TWO.multiply(x.subtract(expY)).divide(x.add(expY), mc);
            result = result.add(step);
        } while (adaptivePrecision < maxPrecision || step.abs().compareTo(acceptableError) > 0);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static BigDecimal logUsingTwoThree(BigDecimal x, MathContext mathContext) {
        block9: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                block12: {
                                                    block11: {
                                                        block10: {
                                                            mcDouble = new MathContext(mathContext.getPrecision() << 1, mathContext.getRoundingMode());
                                                            mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
                                                            factorOfTwo = 0;
                                                            powerOfTwo = 1;
                                                            factorOfThree = 0;
                                                            powerOfThree = 1;
                                                            value = x.doubleValue();
                                                            if (value < 0.01) break block9;
                                                            if (!(value < 0.1)) break block10;
                                                            while (value < 0.6) {
                                                                value *= 2.0;
                                                                --factorOfTwo;
                                                                powerOfTwo <<= 1;
                                                            }
                                                            break block9;
                                                        }
                                                        if (!(value < 0.115)) break block11;
                                                        factorOfThree = -2;
                                                        powerOfThree = 9;
                                                        break block9;
                                                    }
                                                    if (!(value < 0.14)) break block12;
                                                    factorOfTwo = -3;
                                                    powerOfTwo = 8;
                                                    break block9;
                                                }
                                                if (!(value < 0.2)) break block13;
                                                factorOfTwo = -1;
                                                powerOfTwo = 2;
                                                factorOfThree = -1;
                                                powerOfThree = 3;
                                                break block9;
                                            }
                                            if (!(value < 0.3)) break block14;
                                            factorOfTwo = -2;
                                            powerOfTwo = 4;
                                            break block9;
                                        }
                                        if (!(value < 0.42)) break block15;
                                        factorOfThree = -1;
                                        powerOfThree = 3;
                                        break block9;
                                    }
                                    if (!(value < 0.7)) break block16;
                                    factorOfTwo = -1;
                                    powerOfTwo = 2;
                                    break block9;
                                }
                                if (value < 1.4) break block9;
                                if (!(value < 2.5)) break block17;
                                factorOfTwo = 1;
                                powerOfTwo = 2;
                                break block9;
                            }
                            if (!(value < 3.5)) break block18;
                            factorOfThree = 1;
                            powerOfThree = 3;
                            break block9;
                        }
                        if (!(value < 5.0)) break block19;
                        factorOfTwo = 2;
                        powerOfTwo = 4;
                        break block9;
                    }
                    if (!(value < 7.0)) break block20;
                    factorOfThree = 1;
                    powerOfThree = 3;
                    factorOfTwo = 1;
                    powerOfTwo = 2;
                    break block9;
                }
                if (!(value < 8.5)) break block21;
                factorOfTwo = 3;
                powerOfTwo = 8;
                break block9;
            }
            if (!(value < 10.0)) ** GOTO lbl84
            factorOfThree = 2;
            powerOfThree = 9;
            break block9;
lbl-1000:
            // 1 sources

            {
                value /= 2.0;
                ++factorOfTwo;
                powerOfTwo <<= 1;
lbl84:
                // 2 sources

                ** while (value > 1.4)
            }
        }
        correctedX = x;
        result = BigDecimal.ZERO;
        if (factorOfTwo > 0) {
            correctedX = correctedX.divide(BigDecimal.valueOf(powerOfTwo), mc);
            result = result.add(Lib_BigCalc.logTwo(mcDouble).multiply(BigDecimal.valueOf(factorOfTwo), mc));
        } else if (factorOfTwo < 0) {
            correctedX = correctedX.multiply(BigDecimal.valueOf(powerOfTwo), mc);
            result = result.subtract(Lib_BigCalc.logTwo(mcDouble).multiply(BigDecimal.valueOf(-factorOfTwo), mc));
        }
        if (factorOfThree > 0) {
            correctedX = correctedX.divide(BigDecimal.valueOf(powerOfThree), mc);
            result = result.add(Lib_BigCalc.logThree(mcDouble).multiply(BigDecimal.valueOf(factorOfThree), mc));
        } else if (factorOfThree < 0) {
            correctedX = correctedX.multiply(BigDecimal.valueOf(powerOfThree), mc);
            result = result.subtract(Lib_BigCalc.logThree(mcDouble).multiply(BigDecimal.valueOf(-factorOfThree), mc));
        }
        if (x == correctedX && result == BigDecimal.ZERO) {
            return Lib_BigCalc.logUsingNewton(x, mathContext);
        }
        return result.add(Lib_BigCalc.logUsingNewton(correctedX, mc), mc);
    }

    private static BigDecimal powInteger(BigDecimal x, BigDecimal integerY, MathContext mathContext) {
        if (Lib_BigCalc.fractionalPart(integerY).signum() != 0) {
            throw new IllegalArgumentException("Not integer value: " + integerY);
        }
        if (integerY.signum() < 0) {
            return BigDecimal.ONE.divide(Lib_BigCalc.powInteger(x, integerY.negate(), mathContext), mathContext);
        }
        MathContext mc = new MathContext(Math.max(mathContext.getPrecision(), -integerY.scale()) + 30, mathContext.getRoundingMode());
        BigDecimal result = BigDecimal.ONE;
        while (integerY.signum() > 0) {
            BigDecimal halfY = integerY.divide(Lib_BigMath.TWO, mc);
            if (Lib_BigCalc.fractionalPart(halfY).signum() != 0) {
                result = result.multiply(x, mc);
                integerY = integerY.subtract(BigDecimal.ONE);
                halfY = integerY.divide(Lib_BigMath.TWO, mc);
            }
            if (halfY.signum() > 0) {
                x = x.multiply(x, mc);
            }
            integerY = halfY;
        }
        return Lib_BigMath.round(result, mathContext);
    }
}

