/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.convert.ConvertSequence;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.util.Lib_Math;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_DataBase;
import de.mn77.base.error.Err_Exception;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Network;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.error.I_ErrorDetails;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ErrorBaseDebug;
import org.jaymo_lang.error.JayMoError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.Type;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.I_BigNumber;
import org.jaymo_lang.object.passthrough.I_Mem;
import org.jaymo_lang.object.pseudo.JMo_Error;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ErrorComposer;
import org.jaymo_lang.util.Lib_Output;

public class Lib_Error {
    public static String collectMessages(Throwable t) {
        StringBuffer sb = new StringBuffer();
        String message = t.getMessage();
        if (message == null) {
            message = t.getClass().getSimpleName();
        }
        sb.append(message);
        while (t.getCause() != null) {
            t = t.getCause();
            sb.append(" | ");
            sb.append(t.getMessage());
        }
        return sb.toString();
    }

    public static String errorTypeString(Throwable ex) {
        if (ex instanceof ErrorBaseDebug) {
            return ((ErrorBaseDebug)ex).getErrorTypeInfo();
        }
        if (ex instanceof Err_FileSys || ex instanceof Err_DataBase || ex instanceof Err_Network) {
            return "External error";
        }
        return "Internal JayMo error";
    }

    public static void handleThreadErrorEnd(CallRuntime cr, Throwable t) {
        try {
            if (cr.getApp().eventHasHandler(cr, "@error")) {
                cr.getApp().eventRunRaw(cr, "@error", new JMo_Error(t));
            } else {
                String s = t instanceof ErrorBaseDebug ? ((ErrorBaseDebug)t).toInfo() : (t instanceof I_Object ? ((I_Object)((Object)t)).toString(cr, STYPE.DESCRIBE) : Lib_Error.iWrap(t));
                Lib_Output.err(cr, s, true);
            }
        }
        catch (Throwable t2) {
            try {
                String s = Lib_Error.iWrap(t);
                Lib_Output.err(cr, s, true);
            }
            catch (Throwable t3) {
                System.err.println(t);
                System.err.println(t2);
                System.err.println(t3);
            }
        }
    }

    public static void ifArgs(int got, int min, Integer max, CallRuntime cr, I_Object obj) {
        String want = null;
        if (max == null) {
            if (got < min) {
                want = "at least " + min;
            }
        } else if (!Lib_Math.isBetween(got, min, max)) {
            want = min + (min != max ? " to " + max : "");
        }
        if (want != null) {
            Group2<String, Boolean> g = Lib_Output.toObjectWithFunction(cr, obj, cr.call.method, true);
            throw new CodeError(cr, "Invalid amount of arguments", "Need " + want + ", but got " + got + " for: " + (String)g.o1);
        }
    }

    public static void ifArgs(int got, int min, Integer max, String subject, DebugInfo debug) {
        String want = null;
        if (max == null) {
            if (got < min) {
                want = "" + min;
            }
        } else if (!Lib_Math.isBetween(got, min, max)) {
            String string = want = min != max ? String.valueOf(min) + " to " + max : "" + min;
        }
        if (want != null) {
            throw new CodeError("Invalid amount of arguments", "Need " + want + ", but got " + got + " for: " + subject, debug);
        }
    }

    public static void ifBigNumber(CallRuntime cr, I_Object obj) {
        if (obj instanceof I_BigNumber) {
            throw new RuntimeError(cr, "Invalid type", "This function is currently not available for big numbers. Got " + obj.getTypeName() + ", maybe try Int, Dec or Double.");
        }
    }

    public static void ifEmpty(CallRuntime cr, int size, String type) {
        if (size == 0) {
            throw new RuntimeError(cr, "Can't access position", String.valueOf(type) + " is empty");
        }
    }

    public static void ifEmpty(CallRuntime cr, String value, String type) {
        if (value == null || value.length() == 0) {
            throw new RuntimeError(cr, "Got empty string", String.valueOf(type) + " is empty");
        }
    }

    public static void ifIs(CallRuntime cr, int shouldNotBe, int value, String title) {
        if (value == shouldNotBe) {
            throw new RuntimeError(cr, "Invalid " + title, "Value is not allowed: " + shouldNotBe);
        }
    }

    public static void ifNot(CallRuntime cr, int shouldBe, int value, String title) {
        if (value != shouldBe) {
            throw new RuntimeError(cr, "Invalid " + title, "Value should be " + shouldBe + ", but got: " + value);
        }
    }

    public static void ifNotBetween(CallRuntime cr, double min, double max, BigDecimal value, String title) {
        double doubleValue = value.doubleValue();
        if (min == max && doubleValue != min) {
            throw new RuntimeError(cr, "Value out of bounds, invalid " + title, String.valueOf(title) + " is not: " + value);
        }
        if (min > max) {
            Err.forbidden(min, max, value);
        }
        if (doubleValue < min || doubleValue > max) {
            String range = min < max ? String.valueOf(min) + " to " + max : "" + min;
            throw new RuntimeError(cr, "Value out of bounds, invalid " + title, "Allowed are " + range + ", but got: " + value);
        }
    }

    public static void ifNotBetween(CallRuntime cr, double min, double max, double value, String title) {
        if (min == max && value != min) {
            throw new RuntimeError(cr, "Value out of bounds, invalid " + title, String.valueOf(title) + " is not: " + value);
        }
        if (min > max) {
            Err.forbidden(min, max, value);
        }
        if (value < min || value > max) {
            String range = min < max ? String.valueOf(min) + " to " + max : "" + min;
            throw new RuntimeError(cr, "Value out of bounds, invalid " + title, "Allowed are " + range + ", but got: " + value);
        }
    }

    public static void ifNotBetween(CallRuntime cr, double abs, double value, String title) {
        Err.ifTooSmall(0.0, abs);
        if (value > abs || value < -abs) {
            throw new RuntimeError(cr, "Value out of bounds, invalid " + title, String.valueOf(title) + " must be between -" + abs + " and " + abs + ", but got: " + value);
        }
    }

    public static void ifNotBetween(CallRuntime cr, int min, int max, int value, String title) {
        if (min == max && value != min) {
            throw new RuntimeError(cr, "Value out of bounds, invalid " + title, String.valueOf(title) + " must be " + min + ", but got: " + value);
        }
        if (min > max) {
            Err.forbidden(min, max, value);
        }
        if (value < min || value > max) {
            String range = min < max ? String.valueOf(min) + " to " + max : "" + min;
            throw new RuntimeError(cr, "Value out of bounds, invalid " + title, "Allowed are " + range + ", but got: " + value);
        }
    }

    public static void ifNotBetween(CallRuntime cr, int abs, int value, String title) {
        Err.ifTooSmall(0.0, abs);
        if (value > abs || value < -abs) {
            throw new RuntimeError(cr, "Value out of bounds, invalid " + title, String.valueOf(title) + " must be between -" + abs + " and " + abs + ", but got: " + value);
        }
    }

    public static void ifNotBetween(CallRuntime cr, long min, long max, BigInteger value, String title) {
        long longValue;
        try {
            longValue = value.longValueExact();
        }
        catch (ArithmeticException e) {
            String range = min < max ? String.valueOf(min) + " to " + max : "" + min;
            throw new RuntimeError(cr, "Value out of bounds, invalid " + title, "Allowed are " + range + ", but got: " + value);
        }
        if (min == max && longValue != min) {
            throw new RuntimeError(cr, "Value out of bounds, invalid " + title, String.valueOf(title) + " must be " + min + ", but got: " + value);
        }
        if (min > max) {
            Err.forbidden(min, max, value);
        }
        if (longValue < min || longValue > max) {
            String range = min < max ? String.valueOf(min) + " to " + max : "" + min;
            throw new RuntimeError(cr, "Value out of bounds, invalid " + title, "Allowed are " + range + ", but got: " + value);
        }
    }

    public static void ifNotBetween(int min, int max, int value, String title, DebugInfo debug) {
        if (min == max && value != min) {
            throw new CodeError("Value out of bounds, invalid " + title, String.valueOf(title) + " is not: " + value, debug);
        }
        if (min > max) {
            Err.forbidden(min, max, value);
        }
        if (value < min || value > max) {
            String range = min < max ? String.valueOf(min) + " to " + max : "" + min;
            throw new CodeError("Value out of bounds, invalid " + title, "Allowed are " + range + ", but got: " + value, debug);
        }
    }

    public static void ifNotControl(CallRuntime cr, Type type) {
        if (!type.isControl()) {
            throw new RuntimeError(cr, "This type has no control functionality!", "Maybe '!!' is missing at the end of the type definition.");
        }
    }

    public static void ifTooHigh(CallRuntime cr, int max, int value) {
        if (value > max) {
            throw new RuntimeError(cr, "Value too big", "Maximum is " + max + ", but got: " + value);
        }
    }

    public static void ifTooSmall(CallRuntime cr, long min, long value) {
        if (value < min) {
            throw new RuntimeError(cr, "Value too small", "Minimum is " + min + ", but got: " + value);
        }
    }

    public static CodeError memNotInitialized(CallRuntime cr, I_Mem vc) {
        String type = vc.getMemTypeString();
        type = Lib_String.capitalize(type, true);
        throw new CodeError(cr, String.valueOf(type) + " not initialized", "No value assigned to: " + vc.getName());
    }

    public static CodeError notAllowed(CallRuntime cr) {
        throw new CodeError(cr, "Not allowed!", "You can't run this function!");
    }

    public static void notImplementedYet(CallRuntime cr, String detail) {
        throw new JayMoError(cr, "Not implemented yet", detail);
    }

    public static Throwable wrap(Throwable t) {
        if (t instanceof ErrorBaseDebug) {
            return t;
        }
        if (t instanceof Err_Exception || t instanceof Err_Runtime) {
            return new JayMoError(t, Lib_Error.collectMessages(t), ConvertSequence.toString(", ", ((I_ErrorDetails)((Object)t)).getDetails()), null);
        }
        return new JayMoError(t, t.getClass().getSimpleName(), Lib_Error.collectMessages(t), null);
    }

    private static String iWrap(Throwable t) {
        try {
            return new ErrorComposer(t, null).compose();
        }
        catch (Throwable x) {
            return t.toString();
        }
    }
}

