/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.base.version.Lib_Version;
import java.io.File;
import org.jaymo_lang.JayMo;
import org.jaymo_lang.model.App;
import org.jaymo_lang.parser.Parser_Script;

public class Parser_App {
    private final boolean isVersionInit;
    private boolean terminalModeRaw = false;
    private boolean debug = false;

    public Parser_App() {
        this(false);
    }

    public Parser_App(boolean versionUpdate) {
        if (versionUpdate) {
            this.versionInit(versionUpdate);
        }
        this.isVersionInit = versionUpdate;
    }

    public String getVersionString(boolean withBuild, boolean withDate) {
        StringBuilder format = new StringBuilder();
        boolean isDev = false;
        switch (JayMo.STAGE) {
            case RELEASE: {
                format.append("%1.%2.%3");
                break;
            }
            case BETA: {
                format.append("BETA_%YYYY-MM-DD");
                isDev = true;
                break;
            }
            default: {
                format.append("SID_%YYYY-MM-DD");
                isDev = true;
            }
        }
        if (isDev) {
            if (!this.isVersionInit) {
                this.versionInit(false);
            }
            withDate = false;
            if (withBuild) {
                format.append(" (%b)");
            }
        }
        if (withDate) {
            format.append(" - %DD.MM.YYYY");
        }
        return JayMo.version().format(format.toString());
    }

    public boolean isDevVersion() {
        return JayMo.STAGE.isDevelopment();
    }

    public void parseFile(App app, File file) throws Err_FileSys {
        String source = Lib_TextFile.read(file);
        this.iParseText(app, file.getParent(), file.getName(), source);
    }

    public App parseFile(File file) throws Err_FileSys {
        App app = new App(this.terminalModeRaw, this.debug);
        this.parseFile(app, file);
        return app;
    }

    public void parseText(App app, String source) {
        this.iParseText(app, null, null, source);
    }

    public App parseText(String source) {
        App app = new App(this.terminalModeRaw, this.debug);
        this.iParseText(app, null, null, source);
        return app;
    }

    public App parseText(String basePath, String filePath, String code) {
        App app = new App(this.terminalModeRaw, this.debug);
        this.iParseText(app, basePath, filePath, code);
        return app;
    }

    public void setDebug() {
        this.debug = true;
    }

    public void setTerminalRawMode(boolean inRawMode) {
        this.terminalModeRaw = inRawMode;
    }

    private void iParseText(App app, String basePath, String fileInfo, String code) {
        Parser_Script ps = new Parser_Script(app, basePath, fileInfo, code);
        ps.parse();
    }

    private void versionInit(boolean update) {
        try {
            Lib_Version.init(JayMo.version(), false, update);
        }
        catch (Err_FileSys e) {
            Err.show(e);
        }
    }
}

