/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.filesys;

import de.mn77.base.data.convert.ConvertArray;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.util.Lib_Array;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Byte;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Type;

public class JMo_RandomAccessFile
extends A_Object {
    private final ArgCallBuffer cMode;
    private final ArgCallBuffer cFile;
    private final String[] allowed = new String[]{"r", "rw", "rws", "rwd"};
    private String mode = "r";
    private File file = null;
    private RandomAccessFile raf = null;

    public JMo_RandomAccessFile(Call file, Call mode) {
        this.cFile = new ArgCallBuffer(0, file);
        this.cMode = new ArgCallBuffer(1, mode);
    }

    public JMo_RandomAccessFile(CallRuntime cr, File f, String mode) {
        this.file = f;
        this.cFile = null;
        this.iSetMode(cr, mode);
        this.cMode = null;
    }

    @Override
    public void init(CallRuntime cr) {
        cr.getStrict().checkSandbox(cr, "RandomAccessFile");
        if (this.cFile != null) {
            I_Object fo = this.cFile.initExt(cr, this, JMo_File.class, Str.class);
            this.file = fo instanceof JMo_File ? ((JMo_File)fo).getInternalFile() : new File(((Str)fo).getValue());
        }
        if (this.cMode != null) {
            Str o = this.cMode.init(cr, this, Str.class);
            this.iSetMode(cr, Lib_Convert.getStringValue(cr, o));
        }
        try {
            this.raf = new RandomAccessFile(this.file, this.mode);
        }
        catch (FileNotFoundException e) {
            throw new ExternalError(cr, "File access error", e.getMessage());
        }
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        String typeName = Lib_Type.getName(this);
        switch (type) {
            case NESTED: 
            case IDENT: {
                return typeName;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(typeName);
        sb.append('(');
        sb.append(FormString.quote(this.file.getAbsolutePath(), '\"', '\\', false));
        sb.append(",\"");
        sb.append(this.mode);
        sb.append("\")");
        return sb.toString();
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "close": {
                this.mClose(cr);
                return A_Object.stdResult(Nil.NIL);
            }
            case "seek": {
                this.mSeek(cr);
                return A_Object.stdResult(this);
            }
            case "seekStart": {
                this.mSeekStart(cr);
                return A_Object.stdResult(this);
            }
            case "seekEnd": {
                this.mSeekEnd(cr);
                return A_Object.stdResult(this);
            }
            case "size": {
                return this.mSize(cr);
            }
            case "read": {
                return this.mRead(cr);
            }
            case "readByte": {
                return this.mReadByte(cr);
            }
            case "readBytes": {
                return this.mReadBytes(cr);
            }
            case "readInt": {
                return this.mReadInt(cr);
            }
            case "readString": {
                return this.mReadString(cr);
            }
            case "write": {
                this.mWrite(cr);
                return A_Object.stdResult(this);
            }
            case "writeByte": {
                this.mWriteByte(cr);
                return A_Object.stdResult(this);
            }
            case "writeBytes": {
                this.mWriteBytes(cr);
                return A_Object.stdResult(this);
            }
            case "writeInt": {
                this.mWriteInt(cr);
                return A_Object.stdResult(this);
            }
            case "writeString": {
                this.mWriteString(cr);
                return A_Object.stdResult(this);
            }
            case "flush": {
                this.mFlush(cr);
                return A_Object.stdResult(this);
            }
        }
        return null;
    }

    private ExternalError iError(CallRuntime cr, IOException e) {
        throw new ExternalError(cr, "File access error", e.getMessage());
    }

    private void iSetMode(CallRuntime cr, String newMode) {
        if (Lib_Array.contains(this.allowed, newMode)) {
            this.mode = newMode;
        } else {
            this.mode = "rw";
            cr.warning("Invalid mode for file access", "Allowed are [\"" + ConvertArray.toString("\",\"", (Object[])this.allowed) + "\"], but got \"" + newMode + "\". Using default: \"" + this.mode + '\"');
        }
    }

    private void mClose(CallRuntime cr) {
        cr.argsNone();
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void mFlush(CallRuntime cr) {
        cr.argsNone();
        try {
            this.raf.getFD().sync();
        }
        catch (IOException e) {
            throw new ExternalError(cr, e.getMessage(), this.file.getAbsolutePath());
        }
    }

    private ObjectCallResult mRead(CallRuntime cr) {
        cr.argsNone();
        try {
            int i = this.raf.read();
            return A_Object.stdResult(new Int(i));
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private ObjectCallResult mReadByte(CallRuntime cr) {
        cr.argsNone();
        try {
            byte b = this.raf.readByte();
            return A_Object.stdResult(new JMo_Byte(b));
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private ObjectCallResult mReadBytes(CallRuntime cr) {
        I_Object o = cr.args(this, A_IntNumber.class)[0];
        int len = Lib_Convert.getIntValue(cr, o);
        try {
            byte[] btr = new byte[len];
            this.raf.readFully(btr, 0, len);
            SimpleList<I_Object> al = new SimpleList<I_Object>(len);
            int i = 0;
            while (i < len) {
                al.add(new JMo_Byte(btr[i]));
                ++i;
            }
            return A_Object.stdResult(new JMo_List(al));
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private ObjectCallResult mReadInt(CallRuntime cr) {
        cr.argsNone();
        try {
            int i = this.raf.readInt();
            return A_Object.stdResult(new Int(i));
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private ObjectCallResult mReadString(CallRuntime cr) {
        I_Object[] o = cr.args(this, A_IntNumber.class, Bool.class);
        int len = Lib_Convert.getIntValue(cr, o[0]);
        boolean utf8 = Lib_Convert.getBoolValue(cr, o[1]);
        StringBuilder sb = new StringBuilder();
        try {
            if (this.raf.getFilePointer() + (long)len >= this.raf.length()) {
                len = (int)(this.raf.length() - this.raf.getFilePointer());
            }
            if (utf8) {
                byte[] btr = new byte[len];
                this.raf.readFully(btr, 0, len);
                String s = new String(btr, "UTF-8");
                sb.append(s);
            } else {
                byte[] btr = new byte[len];
                this.raf.readFully(btr, 0, len);
                int i = 0;
                while (i < len) {
                    int bi = btr[i];
                    sb.append((char)(bi &= 0xFF));
                    ++i;
                }
            }
            return A_Object.stdResult(new Str(sb.toString()));
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void mSeek(CallRuntime cr) {
        I_Object o1 = cr.args(this, I_Integer.class)[0];
        long l = Lib_Convert.getLongValue(cr, o1);
        Lib_Error.ifTooSmall(cr, 1L, l);
        try {
            this.raf.seek(l - 1L);
        }
        catch (IOException e) {
            this.iError(cr, e);
        }
    }

    private void mSeekEnd(CallRuntime cr) {
        cr.argsNone();
        try {
            this.raf.seek(this.raf.length());
        }
        catch (IOException e) {
            this.iError(cr, e);
        }
    }

    private void mSeekStart(CallRuntime cr) {
        cr.argsNone();
        try {
            this.raf.seek(0L);
        }
        catch (IOException e) {
            this.iError(cr, e);
        }
    }

    private ObjectCallResult mSize(CallRuntime cr) {
        cr.argsNone();
        try {
            long len = this.raf.length();
            return A_Object.stdResult(new JMo_Long(len));
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void mWrite(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int i = Lib_Convert.getIntValue(cr, o);
        Lib_Error.ifNotBetween(cr, 0, 255, i, "Position to seek");
        try {
            this.raf.write(i);
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void mWriteByte(CallRuntime cr) {
        I_Object o = cr.args(this, JMo_Byte.class)[0];
        byte b = Lib_Convert.getByteValue(cr, o);
        try {
            this.raf.writeByte(b);
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void mWriteBytes(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        try {
            int len = oa.length;
            byte[] ba = new byte[len];
            int i = 0;
            while (i < len) {
                ba[i] = Lib_Convert.getByteValue(cr, cr.argType(oa[i], JMo_Byte.class));
                ++i;
            }
            this.raf.write(ba);
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void mWriteInt(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int i = Lib_Convert.getIntValue(cr, o);
        try {
            this.raf.writeInt(i);
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }

    private void mWriteString(CallRuntime cr) {
        I_Object[] o = cr.args(this, Str.class, Bool.class);
        String s = Lib_Convert.getStringValue(cr, o[0]);
        boolean utf8 = Lib_Convert.getBoolValue(cr, o[1]);
        try {
            if (utf8) {
                this.raf.write(s.getBytes("UTF-8"));
            } else {
                this.raf.writeBytes(s);
            }
        }
        catch (IOException e) {
            throw this.iError(cr, e);
        }
    }
}

