/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.error.Err;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.NOP0;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomicMath;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Byte
extends A_IntNumber
implements I_Integer,
I_Atomic {
    public static final short TOP_VALUE = 255;
    private final byte value;

    public JMo_Byte(byte val) {
        this.value = val;
    }

    @Override
    public ATOMIC getEnum() {
        return ATOMIC.BYTE;
    }

    @Override
    public int getIntValue(CallRuntime cr) {
        return this.value;
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return "" + this.value;
            }
        }
        return "" + this.value + 'b';
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    protected A_Atomic getMaxValue(CallRuntime cr) {
        return new JMo_Byte(127);
    }

    @Override
    protected A_Atomic getMinValue(CallRuntime cr) {
        return new JMo_Byte(-128);
    }

    @Override
    protected A_Number numberCalc0(CallRuntime cr, NOP0 op) {
        switch (op) {
            case NEG: {
                return new JMo_Byte(-this.value);
            }
            case ABS: {
                return new JMo_Byte((byte)Math.abs(this.value));
            }
            case EXP: {
                return JMo_Dec.valueOf(cr, Math.exp(this.value));
            }
            case INC: {
                return new JMo_Byte((byte)(this.value + 1));
            }
            case DEC: {
                return new JMo_Byte((byte)(this.value - 1));
            }
            case POW: {
                return new Int(this.value * this.value);
            }
            case ROOT: {
                return JMo_Dec.valueOf(cr, Math.sqrt(this.value));
            }
            case LOG10: {
                return JMo_Dec.valueOf(cr, Math.log10(this.value));
            }
            case LOGN: {
                return JMo_Dec.valueOf(cr, Math.log(this.value));
            }
        }
        throw Err.invalid(new Object[]{cr, op});
    }

    @Override
    protected A_Number numberCalc1(CallRuntime cr, NOP1 op, A_Number paro) {
        if (paro instanceof I_Integer) {
            if (paro instanceof JMo_BigInt) {
                return Lib_AtomicMath.calcBigInt(cr, op, BigInteger.valueOf(this.value), ((JMo_BigInt)paro).getValue());
            }
            if (paro instanceof JMo_Long) {
                return Lib_AtomicMath.calcLong(cr, op, this.value, ((JMo_Long)paro).getValue());
            }
            return Lib_AtomicMath.calcInt(cr, op, this.value, Lib_Convert.getIntValue(cr, paro));
        }
        if (paro instanceof JMo_BigDec) {
            return Lib_AtomicMath.calcBigDec(cr, op, BigDecimal.valueOf(this.value), ((JMo_BigDec)paro).getValue());
        }
        if (paro instanceof JMo_Dec) {
            return Lib_AtomicMath.calcDec(cr, op, Dec.valueOf(this.value), Lib_Convert.getDecValue(cr, paro));
        }
        return Lib_AtomicMath.calcDouble(cr, op, this.value, Lib_Convert.getDoubleValue(cr, paro));
    }

    @Override
    protected A_Number numberCalcSame(CallRuntime cr, A_Number num, boolean inc) {
        int arg = Lib_Convert.getIntValue(cr, num);
        return new JMo_Byte((byte)(inc ? this.value + arg : this.value - arg));
    }

    @Override
    protected JMo_ByteArray toByteArray(CallRuntime cr) {
        return new JMo_ByteArray(new byte[]{this.value});
    }
}

