/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.COMPARE;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_Chars;
import org.jaymo_lang.object.atom.A_DecNumber;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.atom.JMo_Double;
import org.jaymo_lang.object.atom.JMo_Float;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.NOP0;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomConv;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_NumberStyle;
import org.jaymo_lang.util.Lib_Type;

public abstract class A_Number
extends A_Atomic {
    @Override
    public final Boolean isGreater3(I_Atomic o) {
        double arg;
        if (!(o instanceof A_Number)) {
            return null;
        }
        Double value = ((Number)this.getValue()).doubleValue();
        if (value.compareTo(arg = Lib_Convert.getDoubleValue(null, o)) > 0) {
            return true;
        }
        return false;
    }

    @Override
    protected final ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "+": 
            case "add": {
                return A_Object.stdResult(this.mArithm(cr, NOP1.ADD, true));
            }
            case "-": 
            case "sub": {
                return A_Object.stdResult(this.mArithm(cr, NOP1.SUB, false));
            }
            case "*": 
            case "mul": {
                return A_Object.stdResult(this.mArithm(cr, NOP1.MUL, true));
            }
            case "/": 
            case "div": {
                return A_Object.stdResult(this.mArithm(cr, NOP1.DIV, false));
            }
            case "/~": 
            case "divFloor": 
            case "floorDiv": {
                return A_Object.stdResult(this.mDivFloor(cr));
            }
            case "%": 
            case "mod": {
                return A_Object.stdResult(this.mArithm(cr, NOP1.MOD, false));
            }
            case "log": {
                return A_Object.stdResult(this.mArithm(cr, NOP1.LOG, false));
            }
            case "ln": 
            case "logn": {
                return A_Object.stdResult(this.mArithm(cr, NOP0.LOGN));
            }
            case "log10": {
                return A_Object.stdResult(this.mArithm(cr, NOP0.LOG10));
            }
            case "exp": {
                return A_Object.stdResult(this.mArithm(cr, NOP0.EXP));
            }
            case "++": 
            case "inc": {
                return A_Object.stdResult(this.mArithmSame(cr, true));
            }
            case "--": 
            case "dec": {
                return A_Object.stdResult(this.mArithmSame(cr, false));
            }
            case "neg": {
                return A_Object.stdResult(this.mArithm(cr, NOP0.NEG));
            }
            case "abs": {
                return A_Object.stdResult(this.mArithm(cr, NOP0.ABS));
            }
            case "**": 
            case "pow": {
                return A_Object.stdResult(cr.hasArguments() ? this.mArithm(cr, NOP1.POW, false) : this.mArithm(cr, NOP0.POW));
            }
            case "sqrt": {
                cr.argsNone();
                return A_Object.stdResult(this.mArithm(cr, NOP0.ROOT));
            }
            case "//": 
            case "root": {
                return A_Object.stdResult(cr.hasArguments() ? this.mArithm(cr, NOP1.ROOT, false) : this.mArithm(cr, NOP0.ROOT));
            }
            case "roundDown": 
            case "~": 
            case "floor": {
                return A_Object.stdResult(this.mFloor(cr));
            }
            case "ceil": 
            case "roof": 
            case "roundUp": {
                return A_Object.stdResult(this.mRoof(cr));
            }
            case "round": {
                return A_Object.stdResult(this.mRound(cr));
            }
            case "style": {
                return A_Object.stdResult(this.mStyle(cr));
            }
            case "width": {
                return A_Object.stdResult(this.mWidth(cr));
            }
            case "limit": {
                return A_Object.stdResult(this.mLimit(cr));
            }
            case "cos": {
                cr.argsNone();
                Lib_Error.ifBigNumber(cr, this);
                return this.iCircularUseDec() ? A_Object.stdResult(JMo_Dec.valueOf(cr, Math.cos(((Number)this.getValue()).doubleValue()))) : A_Object.stdResult(new JMo_Double(Math.cos(((Number)this.getValue()).doubleValue())));
            }
            case "sin": {
                cr.argsNone();
                Lib_Error.ifBigNumber(cr, this);
                return this.iCircularUseDec() ? A_Object.stdResult(JMo_Dec.valueOf(cr, Math.sin(((Number)this.getValue()).doubleValue()))) : A_Object.stdResult(new JMo_Double(Math.sin(((Number)this.getValue()).doubleValue())));
            }
            case "tan": {
                cr.argsNone();
                Lib_Error.ifBigNumber(cr, this);
                return this.iCircularUseDec() ? A_Object.stdResult(JMo_Dec.valueOf(cr, Math.tan(((Number)this.getValue()).doubleValue()))) : A_Object.stdResult(new JMo_Double(Math.tan(((Number)this.getValue()).doubleValue())));
            }
            case "acos": {
                cr.argsNone();
                Lib_Error.ifBigNumber(cr, this);
                return this.iCircularUseDec() ? A_Object.stdResult(JMo_Dec.valueOf(cr, Math.acos(((Number)this.getValue()).doubleValue()))) : A_Object.stdResult(new JMo_Double(Math.acos(((Number)this.getValue()).doubleValue())));
            }
            case "asin": {
                cr.argsNone();
                Lib_Error.ifBigNumber(cr, this);
                return this.iCircularUseDec() ? A_Object.stdResult(JMo_Dec.valueOf(cr, Math.asin(((Number)this.getValue()).doubleValue()))) : A_Object.stdResult(new JMo_Double(Math.asin(((Number)this.getValue()).doubleValue())));
            }
            case "atan": {
                cr.argsNone();
                Lib_Error.ifBigNumber(cr, this);
                return this.iCircularUseDec() ? A_Object.stdResult(JMo_Dec.valueOf(cr, Math.atan(((Number)this.getValue()).doubleValue()))) : A_Object.stdResult(new JMo_Double(Math.atan(((Number)this.getValue()).doubleValue())));
            }
        }
        return this.call4(cr, method);
    }

    protected abstract ObjectCallResult call4(CallRuntime var1, String var2);

    @Override
    protected Int getLength(CallRuntime cr) {
        String s = "" + this.getValue();
        return new Int(s.length());
    }

    @Override
    protected final Bool mComparsion(CallRuntime cr, COMPARE m) {
        I_Object paro = cr.argsExt(this, new Class[][]{{Bool.class, A_Number.class}})[0];
        double value = ((Number)this.getValue()).doubleValue();
        double arg = Lib_Convert.getDoubleValue(cr, paro);
        switch (m) {
            case G: {
                return Bool.getObject(value > arg);
            }
            case L: {
                return Bool.getObject(value < arg);
            }
            case GE: {
                return Bool.getObject(value >= arg);
            }
            case LE: {
                return Bool.getObject(value <= arg);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    protected abstract A_Number numberCalc0(CallRuntime var1, NOP0 var2);

    protected abstract A_Number numberCalc1(CallRuntime var1, NOP1 var2, A_Number var3);

    protected abstract A_Number numberCalcSame(CallRuntime var1, A_Number var2, boolean var3);

    private boolean iCircularUseDec() {
        return !(this instanceof JMo_Long) && !(this instanceof JMo_Double) && !(this instanceof JMo_Float);
    }

    private I_Atomic mArithm(CallRuntime cr, NOP0 op) {
        cr.argsNone();
        return this.numberCalc0(cr, op);
    }

    private I_Object mArithm(CallRuntime cr, NOP1 op, boolean strPossible) {
        I_Object arg = cr.argsFlex(this, 1, 1)[0];
        if (strPossible) {
            if (arg == Nil.NIL) {
                return Nil.arithmetic(cr, op, this);
            }
            A_Atomic argAtomic = (A_Atomic)cr.argType(arg, A_Atomic.class);
            if (argAtomic instanceof A_Number) {
                return this.numberCalc1(cr, op, (A_Number)argAtomic);
            }
            if (argAtomic instanceof Bool) {
                return this.numberCalc1(cr, op, new Int(Lib_Convert.getIntValue(cr, argAtomic)));
            }
            return this.number_opStr(cr, op, argAtomic);
        }
        A_Number argNumber = (A_Number)cr.argType(arg, A_Number.class);
        return this.numberCalc1(cr, op, argNumber);
    }

    private I_Atomic mArithmSame(CallRuntime cr, boolean inc) {
        if (cr.hasArguments()) {
            A_Number num = (A_Number)cr.args(this, A_Number.class)[0];
            return this.numberCalcSame(cr, num, inc);
        }
        return this.numberCalc0(cr, inc ? NOP0.INC : NOP0.DEC);
    }

    private I_Object mDivFloor(CallRuntime cr) {
        I_Atomic val = (I_Atomic)this.mArithm(cr, NOP1.DIV, false);
        int i = ((Int)(val = Lib_AtomConv.convert(cr, val, ATOMIC.INT))).getValue();
        return i >= 0 ? val : new Int(i - 1);
    }

    private A_IntNumber mFloor(CallRuntime cr) {
        cr.argsNone();
        if (this instanceof A_IntNumber) {
            return (A_IntNumber)this;
        }
        if (this instanceof JMo_BigDec) {
            return new JMo_BigInt(((JMo_BigDec)this).getValue().round(JMo_BigDec.CONTEXT_DOWN).toBigInteger());
        }
        double value = ((Number)this.getValue()).doubleValue();
        return new JMo_Long((long)Math.floor(value));
    }

    private A_Number mLimit(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_Number.class, A_Number.class);
        Lib_Error.ifBigNumber(cr, args[0]);
        Lib_Error.ifBigNumber(cr, args[1]);
        double min = Lib_Convert.getDoubleValue(cr, args[0]);
        double max = Lib_Convert.getDoubleValue(cr, args[1]);
        if (min > max) {
            throw new RuntimeError(cr, "Min. is greater than max.!", "Min.: " + min + "  Max.: " + max);
        }
        double d = ((Number)this.getValue()).doubleValue();
        if (d > max) {
            d = max;
        }
        if (d < min) {
            d = min;
        }
        return (A_Number)Lib_AtomConv.convert(cr, new JMo_Double(d), this.getEnum());
    }

    private A_IntNumber mRoof(CallRuntime cr) {
        cr.argsNone();
        if (this instanceof A_IntNumber) {
            return (A_IntNumber)this;
        }
        if (this instanceof JMo_BigDec) {
            return new JMo_BigInt(((JMo_BigDec)this).getValue().round(JMo_BigDec.CONTEXT_UP).toBigInteger());
        }
        double value = ((Number)this.getValue()).doubleValue();
        return new JMo_Long((long)Math.ceil(value));
    }

    private A_IntNumber mRound(CallRuntime cr) {
        cr.argsNone();
        if (this instanceof A_IntNumber) {
            return (A_IntNumber)this;
        }
        if (this instanceof JMo_BigDec) {
            return new JMo_BigInt(((JMo_BigDec)this).getValue().round(JMo_BigDec.CONTEXT).toBigInteger());
        }
        double value = ((Number)this.getValue()).doubleValue();
        return new JMo_Long(Math.round(value));
    }

    private Str mStyle(CallRuntime cr) {
        Str o = (Str)cr.args(this, Str.class)[0];
        String styled = Lib_NumberStyle.style(cr, this, o.getValue());
        return new Str(styled);
    }

    private Str mWidth(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int width = Lib_Convert.getIntValue(cr, arg);
        Number raw = (Number)this.getValue();
        String form = FormNumber.right(width, raw.longValue());
        return new Str(form);
    }

    private final A_Chars number_opStr(CallRuntime cr, NOP1 op, A_Atomic p) {
        String arg = Lib_Convert.getStringValue(cr, p);
        if (op == NOP1.ADD) {
            return new Str(this.getValue() + arg);
        }
        if (op == NOP1.MUL) {
            if (this instanceof A_DecNumber) {
                throw new CodeError(cr, "Invalid type to multiply a <Char> or <Str>", "Got " + Lib_Type.getTypeString(this) + ", please use <Int>");
            }
            String s = Lib_String.sequence(arg, ((Number)this.getValue()).longValue());
            return new Str(s);
        }
        throw new CodeError(cr, "Unknown type or function", this.getValue() + " " + (Object)((Object)op) + " " + Lib_Type.getName(p));
    }
}

