/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.data.struct.SimpleList;
import java.util.Collection;
import java.util.HashMap;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.JayMoError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.EventManager;
import org.jaymo_lang.model.FuncManager;
import org.jaymo_lang.model.FunctionPar;
import org.jaymo_lang.object.A_ObjectToString;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.JMo_Enum;
import org.jaymo_lang.object.pseudo.NonAtomic;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Prefix;
import org.jaymo_lang.util.Lib_Type;

public class Type
extends A_ObjectToString {
    private final String name;
    private final Block mainblock;
    private final FuncManager functions;
    private final EventManager events;
    private final FunctionPar[] args;
    private final String autoBlockFunction;
    private final boolean control;
    private final boolean varargs;
    private final int defaultArgs;
    private HashMap<String, Type> selfTypes = null;
    private HashMap<String, A_Immutable> selfConst = null;
    private final I_Object parent;

    public Type(String name, FunctionPar[] args, String abf, boolean control, boolean varargs, Parser_Script parser, DebugInfo debug) {
        this(name, args, abf, control, varargs, parser, null, debug);
    }

    public Type(String name, FunctionPar[] args, String abf, boolean control, boolean varargs, Parser_Script parser, I_Object parent, DebugInfo debug) {
        this.name = Lib_Prefix.addPrefix(name, parser);
        if (parser != null) {
            Lib_Type.checkValidity(this.name, parser);
        }
        this.autoBlockFunction = abf;
        this.mainblock = new Block(this);
        if (parent != null && !(parent instanceof NonAtomic) && !(parent instanceof A_Immutable)) {
            throw new JayMoError("Invalid parent object", "Parent object is not immutable: " + parent, debug);
        }
        this.parent = parent;
        this.functions = new FuncManager();
        this.events = new EventManager();
        this.control = control;
        this.varargs = varargs;
        this.args = args;
        int defArgCounter = 0;
        if (this.args != null) {
            FunctionPar[] functionParArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionPar arg = functionParArray[n2];
                if (arg.isConst) {
                    this.mainblock.getConstManager().define(arg.name, debug);
                } else {
                    this.mainblock.getVarManager().define(arg.name, debug);
                }
                if (arg.defaultValue != null) {
                    ++defArgCounter;
                }
                ++n2;
            }
        }
        this.defaultArgs = defArgCounter;
    }

    public void addConstant(String name, A_Immutable value, DebugInfo debug) {
        if (this.selfConst == null) {
            this.selfConst = new HashMap();
        }
        if (this.selfConst.containsKey(name)) {
            throw new CodeError("Enum-Name already used!", "Enum is already set: " + name, debug);
        }
        this.selfConst.put(name, value);
        if (value instanceof JMo_Enum) {
            ((JMo_Enum)value).setOrdinal(this.selfConst.size());
        }
    }

    public void addType(Type typ, DebugInfo debug) {
        String newName = typ.getName();
        String newNameLower = newName.toLowerCase();
        if (this.selfTypes == null) {
            this.selfTypes = new HashMap();
        }
        for (String s : this.selfTypes.keySet()) {
            if (!newNameLower.equals(s.toLowerCase())) continue;
            String m2 = newName.equals(s) ? "You cannot redefine: " : "You cannot redefine '" + s + "' with: ";
            throw new CodeError("Type-Name already used!", String.valueOf(m2) + newName, debug);
        }
        this.selfTypes.put(newName, typ);
    }

    public SimpleList<String> getAllTypeNames() {
        SimpleList<String> result = new SimpleList<String>();
        if (this.selfTypes != null) {
            result.addAll((Collection<String>)this.selfTypes.keySet());
        }
        return result;
    }

    public String getAutoBlockFunction() {
        return this.autoBlockFunction;
    }

    public Block getBlock() {
        return this.mainblock;
    }

    public int getDefaultArgs() {
        return this.defaultArgs;
    }

    public A_Immutable getEnum(String name, DebugInfo debug) {
        A_Immutable result;
        A_Immutable a_Immutable = result = this.selfConst == null ? null : (A_Immutable)this.selfConst.getOrDefault(name, null);
        if (result == null) {
            throw new CodeError("Unknown Enum!", "Enum is not known: " + name, debug);
        }
        return result;
    }

    public EventManager getEvents() {
        return this.events;
    }

    public FuncManager getFunctions() {
        return this.functions;
    }

    public String getName() {
        return this.name;
    }

    public I_Object getParent() {
        return this.parent;
    }

    public Type getType(String type) {
        return this.selfTypes == null ? null : (Type)this.selfTypes.getOrDefault(type, null);
    }

    public FunctionPar[] getVars() {
        return this.args;
    }

    public boolean isControl() {
        return this.control;
    }

    public boolean isVarArgs() {
        return this.varargs;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return this.name;
            }
            case IDENT: {
                return "::" + this.name;
            }
        }
        StringBuilder sb = new StringBuilder();
        if (this.functions != null) {
            String sf = this.functions.toString(cr, STYPE.DESCRIBE);
            sb.append(sf);
            sb.append('\n');
        }
        if (this.events != null) {
            String se = this.events.toString(cr, STYPE.DESCRIBE);
            sb.append(se);
            sb.append('\n');
        }
        if (this.mainblock != null) {
            String sm = this.mainblock.toString(cr, STYPE.DESCRIBE);
            sb.append(sm);
            sb.append('\n');
        }
        if (this.selfTypes != null) {
            for (Type t : this.selfTypes.values()) {
                String st = t.toString(cr, STYPE.DESCRIBE);
                sb.append(st);
                sb.append('\n');
            }
        }
        Lib_Output.removeEnd(sb, '\n');
        return Lib_Output.appShowPart(this.toString(cr, STYPE.IDENT), sb.toString());
    }
}

