/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.data.group.Group4;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.JayMoError;
import org.jaymo_lang.error.ReturnException;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.FunctionPar;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.model.Type;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Exec;
import org.jaymo_lang.util.Lib_MagicVar;
import org.jaymo_lang.util.Lib_Output;

public class Function
extends A_Object {
    private final String[] names;
    private final Block block;
    private final boolean control;
    private final FunctionPar[] args;
    private final String returnType;
    private final boolean returnNil;
    private final boolean isPrivate;
    private final Type typ;
    private boolean oneLine = false;
    private boolean varArgs;
    private final int defaultArgs;

    public Function(Type typ, String[] names, FunctionPar[] args, boolean control, boolean isPrivate, String returnType, boolean returnNil, DebugInfo debugInfo) {
        this.typ = typ;
        this.names = names;
        this.isPrivate = isPrivate;
        this.block = new Block(typ, this, typ.getBlock());
        this.args = args;
        int defArgCounter = 0;
        if (args != null) {
            FunctionPar[] functionParArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionPar arg = functionParArray[n2];
                if (arg.isConst) {
                    this.block.getConstManager().define(arg.name, debugInfo);
                } else {
                    this.block.getVarManager().define(arg.name, debugInfo);
                }
                if (arg.defaultValue != null) {
                    ++defArgCounter;
                }
                ++n2;
            }
        }
        this.defaultArgs = defArgCounter;
        this.control = control;
        this.returnType = returnType;
        this.returnNil = returnNil;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getDefaultArgs() {
        return this.defaultArgs;
    }

    public String[] getNames() {
        return this.names;
    }

    public boolean getReturnNil() {
        return this.returnNil;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Type getType() {
        return this.typ;
    }

    public FunctionPar[] getVars() {
        return this.args;
    }

    public boolean hasControl() {
        return this.control;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    public boolean isOneLine() {
        return this.oneLine;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public void setOneLine() {
        this.oneLine = true;
    }

    public void setVarArgs() {
        this.varArgs = true;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return String.valueOf(this.typ.getName()) + "." + this.names[0];
            }
        }
        return Lib_Output.appShowPart("::" + this.names[0], this.block.toString(cr, type));
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "=": {
                return this.mResult(cr, 1, 1);
            }
            case "return": {
                return this.mResult(cr, 0, 1);
            }
            case "init": 
            case "_init": {
                return this.iInit(cr);
            }
            case "exportLoop": {
                return this.iExportLoop(cr);
            }
            case "hasStream": {
                this.iCheckControl(cr, CONTROL_PART.STREAM);
                Bool res = Bool.getObject(cr.funcOutside.hasStream());
                return A_Object.stdResult(res);
            }
            case "hasBlock": {
                this.iCheckControl(cr, CONTROL_PART.BLOCK);
                Bool resb = Bool.getObject(cr.funcOutside.hasBlock());
                return A_Object.stdResult(resb);
            }
            case "execStream": 
            case "pushStream": {
                this.iCheckControl(cr, CONTROL_PART.STREAM);
                return A_Object.stdResult(this.mExecStream(cr));
            }
            case "execBlock": 
            case "pushBlock": {
                this.iCheckControl(cr, CONTROL_PART.BLOCK);
                return this.mExecBlock(cr);
            }
            case "push": {
                this.iCheckControl(cr, null);
                return this.mExecBlockStream(cr);
            }
        }
        Lib_MagicVar.checkForbiddenFuncs(cr, method);
        return null;
    }

    private void iCheckControl(CallRuntime cr, CONTROL_PART bs) {
        if (!this.control || cr.funcOutside == null) {
            throw new CodeError(cr, "Invalid " + (bs == null ? "block/stream" : bs.name().toLowerCase()) + " access", "This function has no control functionality!");
        }
    }

    private ObjectCallResult iExportLoop(CallRuntime cr) {
        if (!this.control) {
            throw new CodeError(cr, "Function has no control-functionality.", "Function: " + this.names[0]);
        }
        LoopHandle handle = cr.vce.loopGet(cr);
        if (handle == null) {
            throw new CodeError(cr, "No loop found.", "Please place this function inside a loop, to export it");
        }
        cr.funcOutside.vce.setChildLoop(handle);
        return new ObjectCallResult(this, false);
    }

    private ObjectCallResult iInit(CallRuntime cr) {
        if (!this.control) {
            throw new CodeError(cr, "Function has no control-functionality.", "Function: " + this.names[0]);
        }
        I_Object[] args = cr.argsFlex(null, 0, 2);
        Group4<Block, CallRuntime, CallRuntime, FunctionPar[]> g = cr.vce.getFuncInit(cr);
        if (g == null) {
            throw new JayMoError(cr, "Initializing parameters failed", "Function: " + this.names[0]);
        }
        if (args.length == 0) {
            ((Block)g.o1).initPars((CallRuntime)g.o2, (CallRuntime)g.o3, (FunctionPar[])g.o4, ((CallRuntime)g.o2).getArgs(null, false));
        } else {
            int parNr = Lib_Convert.getIntValue(cr, cr.argType(args[0], A_IntNumber.class));
            Lib_Error.ifNotBetween(cr, 1, ((FunctionPar[])g.o4).length, parNr, "Argument position");
            I_Object argArg = args.length == 1 ? null : args[1];
            I_Object arg = ((CallRuntime)g.o2).getArgAdvance(cr, Nil.NIL, parNr - 1, (FunctionPar[])g.o4, false, argArg);
            int funcParCount = ((FunctionPar[])g.o4).length;
            I_Object[] initPars = new I_Object[funcParCount];
            initPars[parNr - 1] = arg;
            ((Block)g.o1).initPars((CallRuntime)g.o2, (CallRuntime)g.o3, (FunctionPar[])g.o4, initPars);
        }
        return A_Object.stdResult(Nil.NIL);
    }

    private ObjectCallResult mExecBlock(CallRuntime cr) {
        I_Object result = cr.args(this, I_Object.class)[0];
        if (cr.funcOutside.getCallBlock() == null) {
            return A_Object.stdResult(result);
        }
        try {
            I_Object it2 = cr.funcOutside.getCallBlock().exec(cr, result);
            return A_Object.stdResult(it2);
        }
        catch (ReturnException e) {
            return new ObjectCallResult(e.get(), true);
        }
    }

    private ObjectCallResult mExecBlockStream(CallRuntime cr) {
        I_Object result = cr.args(this, I_Object.class)[0];
        if (cr.funcOutside.getCallBlock() != null) {
            try {
                Group4<Block, CallRuntime, CallRuntime, FunctionPar[]> g = cr.vce.getFuncInit(cr);
                if (g == null) {
                    throw new JayMoError(null, cr, "Missing initialization of the parameters.", "Function: " + this.names[0]);
                }
                result = cr.funcOutside.getCallBlock().exec((CallRuntime)g.o2, result);
            }
            catch (ReturnException e) {
                return new ObjectCallResult(e.get(), true);
            }
        }
        if (cr.funcOutside.getStream() != null) {
            result = cr.funcOutside.execInit(cr.funcOutside.getStream(), result);
        }
        return A_Object.stdResult(result);
    }

    private I_Object mExecStream(CallRuntime cr) {
        I_Object it = cr.args(this, I_Object.class)[0];
        CallRuntime crOutside = cr.funcOutside;
        if (crOutside.getStream() == null) {
            return it;
        }
        return crOutside.execInit(crOutside.getStream(), it);
    }

    private ObjectCallResult mResult(CallRuntime cr, int min, int max) {
        I_Object o = Lib_Exec.mSingleArgument(cr, this, min, max, Nil.NIL);
        return A_Object.stdResult(new Return(Return.LEVEL.RETURN, o));
    }

    private static enum CONTROL_PART {
        BLOCK,
        STREAM;

    }
}

