/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.thread;

import de.mn77.base.data.struct.SimpleQueue;
import de.mn77.base.error.Err;

public class ThreadQueue {
    private final SimpleQueue<ThreadQueue> fifo = new SimpleQueue();
    private Thread current = null;

    public synchronized boolean entrance() throws Exception {
        if (this.current != null && this.current.equals(Thread.currentThread())) {
            return true;
        }
        if (!this.fifo.isEmpty() || this.current != null) {
            this.fifo.add(this);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw Err.wrap(e, this.current, this.fifo);
            }
        } else {
            this.current = Thread.currentThread();
        }
        return false;
    }

    public synchronized void leave() {
        this.current = null;
        if (!this.fifo.isEmpty()) {
            this.fifo.next().notify();
        }
    }
}

