/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.data.charset.ConvertCharset;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.Lib_RandomAccess;
import java.io.File;
import java.nio.charset.Charset;

public class Lib_TextFile {
    public static void append(File file, String s) throws Err_FileSys {
        Lib_TextFile.append(file, s, null);
    }

    public static void append(File file, String s, Charset cs) throws Err_FileSys {
        Err.ifNull(file, s);
        byte[] ba = cs == null ? s.getBytes() : s.getBytes(cs);
        Lib_RandomAccess.append(file, ba);
    }

    public static String read(File file) throws Err_FileSys {
        byte[] ba = Lib_RandomAccess.read(file);
        return new String(ba);
    }

    public static String read(File file, Charset cs) throws Err_FileSys {
        byte[] ba = Lib_RandomAccess.read(file);
        return ConvertCharset.toString(ba, cs);
    }

    public static void set(File file, String s) throws Err_FileSys {
        Lib_TextFile.write(file, null, s, null);
    }

    public static void set(File file, String s, Charset charset) throws Err_FileSys {
        Lib_TextFile.write(file, null, s, charset);
    }

    public static void write(File file, Long index, String s) throws Err_FileSys {
        Lib_TextFile.write(file, index, s, null);
    }

    public static void write(File file, Long index, String s, Charset cs) throws Err_FileSys {
        Err.ifNull(file, s);
        byte[] ba = cs == null ? s.getBytes() : s.getBytes(cs);
        Lib_RandomAccess.write(file, index, ba);
    }
}

